# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/iceberg/icebergCatalog.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import (
    dynamoDbCatalogConnection,
    glueCatalogConnection,
    hiveCatalogConnection,
    restCatalogConnection,
)


class IcebergCatalog(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[str, Field(description='Catalog Name.', title='Name')]
    connection: Annotated[
        Union[
            hiveCatalogConnection.HiveCatalogConnection,
            restCatalogConnection.RestCatalogConnection,
            glueCatalogConnection.GlueCatalogConnection,
            dynamoDbCatalogConnection.DynamoDbCatalogConnection,
        ],
        Field(
            description='Catalog connection configuration, depending on your catalog type.',
            title='Connection',
        ),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            None,
            description="Custom Database Name for your Iceberg Service. If not set it will be 'default'.",
            title='Database Name',
        ),
    ]
    warehouseLocation: Annotated[
        Optional[str],
        Field(
            None,
            description='Warehouse Location. Used to specify a custom warehouse location if needed.',
            title='Warehouse Location',
        ),
    ]
