# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/mongoDBConnection.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class MongoDBType(Enum):
    MongoDB = 'MongoDB'


class MongoDBScheme(Enum):
    mongodb = 'mongodb'
    mongodb_srv = 'mongodb+srv'


class MongoDBConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[MongoDBType],
        Field(MongoDBType.MongoDB, description='Service Type', title='Service Type'),
    ]
    scheme: Annotated[
        Optional[MongoDBScheme],
        Field(
            MongoDBScheme.mongodb,
            description='Mongo connection scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        Optional[str],
        Field(
            None,
            description='Username to connect to MongoDB. This user should have privileges to read all the metadata in MongoDB.',
            title='Username',
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='Password to connect to MongoDB.', title='Password'),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the MongoDB service.', title='Host and Port'
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
            title='Database Name',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
