# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/trinoConnection.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .. import connectionBasicType
from .common import azureConfig, basicAuth, jwtAuth


class TrinoType(Enum):
    Trino = 'Trino'


class TrinoScheme(Enum):
    trino = 'trino'


class TrinoConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[TrinoType],
        Field(TrinoType.Trino, description='Service Type', title='Service Type'),
    ]
    scheme: Annotated[
        Optional[TrinoScheme],
        Field(
            TrinoScheme.trino,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to Trino. This user should have privileges to read all the metadata in Trino.',
            title='Username',
        ),
    ]
    authType: Annotated[
        Optional[
            Union[
                basicAuth.BasicAuth,
                jwtAuth.JwtAuth,
                azureConfig.AzureConfigurationSource,
            ]
        ],
        Field(
            None,
            description='Choose Auth Config Type.',
            title='Auth Configuration Type',
        ),
    ]
    hostPort: Annotated[
        str,
        Field(description='Host and port of the Trino service.', title='Host and Port'),
    ]
    catalog: Annotated[
        Optional[str],
        Field(None, description='Catalog of the data source.', title='Catalog'),
    ]
    databaseSchema: Annotated[
        Optional[str],
        Field(
            None,
            description='databaseSchema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single databaseSchema. When left blank, OpenMetadata Ingestion attempts to scan all the databaseSchema.',
            title='databaseSchema',
        ),
    ]
    proxies: Annotated[
        Optional[Dict[str, str]],
        Field(
            None,
            description='Proxies for the connection to Trino data source',
            title='Proxies',
        ),
    ]
    verify: Annotated[
        Optional[str],
        Field(
            None,
            description='Verify ( Connection Argument for SSL ) to connect to Trino.',
            title='Verify',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsUsageExtraction: Annotated[
        Optional[connectionBasicType.SupportsUsageExtraction],
        Field(None, title='Supports Usage Extraction'),
    ]
    supportsLineageExtraction: Annotated[
        Optional[connectionBasicType.SupportsLineageExtraction],
        Field(None, title='Supports Lineage Extraction'),
    ]
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    supportsDatabase: Annotated[
        Optional[connectionBasicType.SupportsDatabase],
        Field(None, title='Supports Database'),
    ]
    supportsQueryComment: Annotated[
        Optional[connectionBasicType.SupportsQueryComment],
        Field(None, title='Supports Query Comment'),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
