# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/dbtCloudConnection.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr


class DBTCloudType(Enum):
    DBTCloud = 'DBTCloud'


class DBTCloudConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DBTCloudType],
        Field(DBTCloudType.DBTCloud, description='Service Type', title='Service Type'),
    ]
    host: Annotated[AnyUrl, Field(description='DBT cloud Access URL.', title='Host')]
    discoveryAPI: Annotated[
        AnyUrl,
        Field(description='DBT cloud Metadata API URL.', title='Discovery API URL'),
    ]
    accountId: Annotated[
        str, Field(description='ID of your DBT cloud account', title='Account Id')
    ]
    jobId: Annotated[
        Optional[str],
        Field(None, description='ID of your DBT cloud job', title='Job Id'),
    ]
    token: Annotated[
        CustomSecretStr,
        Field(description='Generated Token to connect to DBTCloud.', title='Token'),
    ]
