# generated by datamodel-codegen:
#   filename:  entity/teams/persona.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReference, entityReferenceList


class Team(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: basic.Uuid
    name: Annotated[
        basic.EntityName,
        Field(description="A unique name of Persona. Example 'data engineer'"),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None, description="Name used for display purposes. Example 'Data Steward'."
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of the persona.')
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    users: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Users that are assigned a persona.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
