# generated by datamodel-codegen:
#   filename:  metadataIngestion/dbtconfig/dbtLocalConfig.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class DbtConfigType(Enum):
    local = 'local'


class DbtLocalConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbtConfigType: Annotated[DbtConfigType, Field(description='dbt Configuration type')]
    dbtCatalogFilePath: Annotated[
        Optional[str],
        Field(
            None,
            description='DBT catalog file path to extract dbt models with their column schemas.',
            title='DBT Catalog File Path',
        ),
    ]
    dbtManifestFilePath: Annotated[
        str,
        Field(
            description='DBT manifest file path to extract dbt models and associate with tables.',
            title='DBT Manifest File Path',
        ),
    ]
    dbtRunResultsFilePath: Annotated[
        Optional[str],
        Field(
            None,
            description='DBT run results file path to extract the test results information.',
            title='DBT Run Results File Path',
        ),
    ]
