# generated by datamodel-codegen:
#   filename:  system/eventPublisherJob.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..configuration import elasticSearchConfiguration
from ..type import basic
from . import indexingError


class Status(Enum):
    started = 'started'
    running = 'running'
    completed = 'completed'
    failed = 'failed'
    active = 'active'
    activeError = 'activeError'
    stopped = 'stopped'
    success = 'success'


class StepStats(BaseModel):
    totalRecords: Annotated[
        Optional[int], Field(0, description='Count of Total Failed Records')
    ]
    successRecords: Annotated[
        Optional[int], Field(0, description='Count of Total Successfully Records')
    ]
    failedRecords: Annotated[
        Optional[int], Field(0, description='Count of Total Failed Records')
    ]


class Stats(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    jobStats: Optional[StepStats] = None
    entityStats: Optional[StepStats] = None


class RunMode(Enum):
    stream = 'stream'
    batch = 'batch'


class PublisherType(Enum):
    elasticSearch = 'elasticSearch'
    kafka = 'kafka'


class EventPublisherResult(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[Optional[str], Field(None, description='Name of the result')]
    timestamp: basic.Timestamp
    status: Annotated[
        Status, Field(description='This schema publisher run job status.')
    ]
    failure: Annotated[
        Optional[indexingError.IndexingAppError],
        Field(None, description='Failure for the job'),
    ]
    stats: Optional[Stats] = None
    entities: Annotated[
        Optional[List[str]], Field(None, description='List of Entities to Reindex')
    ]
    recreateIndex: Annotated[
        Optional[bool], Field(None, description='This schema publisher run modes.')
    ]
    batchSize: Annotated[
        Optional[int],
        Field(
            None, description='Maximum number of events sent in a batch (Default 10).'
        ),
    ]
    payLoadSize: Annotated[
        Optional[int],
        Field(104857600, description='Payload size in bytes depending on config.'),
    ]
    searchIndexMappingLanguage: Annotated[
        Optional[elasticSearchConfiguration.SearchIndexMappingLanguage],
        Field(
            elasticSearchConfiguration.SearchIndexMappingLanguage.EN,
            description='Recreate Indexes with updated Language',
        ),
    ]
    afterCursor: Annotated[
        Optional[str],
        Field(
            None,
            description='Provide After in case of failure to start reindexing after the issue is solved',
        ),
    ]
