# generated by datamodel-codegen:
#   filename:  tests/testCase.json
#   timestamp: 2024-10-24T15:21:08+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..entity.data import table
from ..type import basic, entityHistory, entityReference, entityReferenceList, tagLabel
from . import basic as basic_1
from . import testSuite


class TestCaseParameterValue(BaseModel):
    name: Annotated[
        Optional[str],
        Field(
            None,
            description='name of the parameter. Must match the parameter names in testCaseParameterDefinition',
        ),
    ]
    value: Annotated[
        Optional[str],
        Field(
            None,
            description='value to be passed for the Parameters. These are input from Users. We capture this in string and convert during the runtime.',
        ),
    ]


class TestCase(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(None, description='Unique identifier of this table instance.'),
    ]
    name: Annotated[
        basic.TestCaseEntityName,
        Field(description='Name that identifies this test case.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this test.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the testcase.'),
    ]
    testDefinition: Annotated[
        entityReference.EntityReference,
        Field(description='Test definition that this test case is based on.'),
    ]
    entityLink: Annotated[
        basic.EntityLink,
        Field(description='Link to the entity that this test case is testing.'),
    ]
    entityFQN: Optional[str] = None
    testSuite: Annotated[
        entityReference.EntityReference,
        Field(description='Test Suite that this test case belongs to.'),
    ]
    testSuites: Optional[List[testSuite.TestSuite]] = None
    parameterValues: Optional[List[TestCaseParameterValue]] = None
    testCaseResult: Annotated[
        Optional[basic_1.TestCaseResult],
        Field(None, description='Latest test case result obtained for this test case.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this Pipeline.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    computePassedFailedRowCount: Annotated[
        Optional[bool],
        Field(
            False,
            description='Compute the passed and failed row count for the test case.',
        ),
    ]
    incidentId: Annotated[
        Optional[basic.Uuid],
        Field(
            None,
            description='Reference to an ongoing Incident ID (stateId) for this test case.',
        ),
    ]
    failedRowsSample: Annotated[
        Optional[table.TableData],
        Field(None, description='Sample of failed rows for this test case.'),
    ]
    inspectionQuery: Annotated[
        Optional[basic.SqlQuery],
        Field(
            None,
            description='SQL query to retrieve the failed rows for this test case.',
        ),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the test case belongs to. When not set, the test case inherits the domain from the table it belongs to.',
        ),
    ]
    useDynamicAssertion: Annotated[
        Optional[bool],
        Field(
            False,
            description='If the test definition supports it, use dynamic assertion to evaluate the test case.',
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(
            None,
            description='Tags for this test case. This is an inherited field from the parent entity and is not set directly on the test case.',
        ),
    ]
