# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TriggerActionArgs', 'TriggerAction']

@pulumi.input_type
class TriggerActionArgs:
    def __init__(__self__, *,
                 action_id: pulumi.Input[str],
                 trigger: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TriggerAction resource.
        :param pulumi.Input[str] action_id: The ID of the action to bind to the trigger.
        :param pulumi.Input[str] trigger: The ID of the trigger to bind with. Available options: `post-login`, `credentials-exchange`, `pre-user-registration`, `post-user-registration`, `post-change-password`, `send-phone-message`, `password-reset-post-challenge`, `iga-approval`, `iga-certification`, `iga-fulfillment-assignment`, `iga-fulfillment-execution`.
        :param pulumi.Input[str] display_name: The name for this action within the trigger. This can be useful for distinguishing between multiple instances of the same action bound to a trigger. Defaults to action name when not provided.
        """
        pulumi.set(__self__, "action_id", action_id)
        pulumi.set(__self__, "trigger", trigger)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="actionId")
    def action_id(self) -> pulumi.Input[str]:
        """
        The ID of the action to bind to the trigger.
        """
        return pulumi.get(self, "action_id")

    @action_id.setter
    def action_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_id", value)

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Input[str]:
        """
        The ID of the trigger to bind with. Available options: `post-login`, `credentials-exchange`, `pre-user-registration`, `post-user-registration`, `post-change-password`, `send-phone-message`, `password-reset-post-challenge`, `iga-approval`, `iga-certification`, `iga-fulfillment-assignment`, `iga-fulfillment-execution`.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: pulumi.Input[str]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for this action within the trigger. This can be useful for distinguishing between multiple instances of the same action bound to a trigger. Defaults to action name when not provided.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _TriggerActionState:
    def __init__(__self__, *,
                 action_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 trigger: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TriggerAction resources.
        :param pulumi.Input[str] action_id: The ID of the action to bind to the trigger.
        :param pulumi.Input[str] display_name: The name for this action within the trigger. This can be useful for distinguishing between multiple instances of the same action bound to a trigger. Defaults to action name when not provided.
        :param pulumi.Input[str] trigger: The ID of the trigger to bind with. Available options: `post-login`, `credentials-exchange`, `pre-user-registration`, `post-user-registration`, `post-change-password`, `send-phone-message`, `password-reset-post-challenge`, `iga-approval`, `iga-certification`, `iga-fulfillment-assignment`, `iga-fulfillment-execution`.
        """
        if action_id is not None:
            pulumi.set(__self__, "action_id", action_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter(name="actionId")
    def action_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the action to bind to the trigger.
        """
        return pulumi.get(self, "action_id")

    @action_id.setter
    def action_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for this action within the trigger. This can be useful for distinguishing between multiple instances of the same action bound to a trigger. Defaults to action name when not provided.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the trigger to bind with. Available options: `post-login`, `credentials-exchange`, `pre-user-registration`, `post-user-registration`, `post-change-password`, `send-phone-message`, `password-reset-post-challenge`, `iga-approval`, `iga-certification`, `iga-fulfillment-assignment`, `iga-fulfillment-execution`.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger", value)


class TriggerAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 trigger: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        With this resource, you can bind an action to a trigger. Once an action is created and deployed, it can be attached (i.e. bound) to a trigger so that it will be executed as part of a flow.

        Ordering of an action within a specific flow is not currently supported when using this resource; the action will get appended to the end of the flow. To precisely manage ordering, it is advised to either do so with the dashboard UI or with the `auth0_trigger_bindings` resource.

        !> This resource appends an action to the trigger binding. In contrast, the `TriggerActions` resource manages all
        the action bindings to a trigger. To avoid potential issues, it is recommended not to use this resource in conjunction
        with the `TriggerAction` resource when binding actions to the same trigger.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        login_alert = auth0.Action("loginAlert",
            code=\"\"\"exports.onContinuePostLogin = async (event, api) => {
          console.log("foo");
        };"
        \"\"\",
            deploy=True,
            supported_triggers=auth0.ActionSupportedTriggersArgs(
                id="post-login",
                version="v3",
            ))
        post_login_alert_action = auth0.TriggerAction("postLoginAlertAction",
            trigger="post-login",
            action_id=login_alert.id)
        ```

        ## Import

        This resource can be imported by specifying the trigger and action ID separated by "::" (note the double colon) <trigger>::<actionID> # Example

        ```sh
         $ pulumi import auth0:index/triggerAction:TriggerAction post_login_action "post-login::28b5c8fa-d371-5734-acf6-d0cf80ead918"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action_id: The ID of the action to bind to the trigger.
        :param pulumi.Input[str] display_name: The name for this action within the trigger. This can be useful for distinguishing between multiple instances of the same action bound to a trigger. Defaults to action name when not provided.
        :param pulumi.Input[str] trigger: The ID of the trigger to bind with. Available options: `post-login`, `credentials-exchange`, `pre-user-registration`, `post-user-registration`, `post-change-password`, `send-phone-message`, `password-reset-post-challenge`, `iga-approval`, `iga-certification`, `iga-fulfillment-assignment`, `iga-fulfillment-execution`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TriggerActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can bind an action to a trigger. Once an action is created and deployed, it can be attached (i.e. bound) to a trigger so that it will be executed as part of a flow.

        Ordering of an action within a specific flow is not currently supported when using this resource; the action will get appended to the end of the flow. To precisely manage ordering, it is advised to either do so with the dashboard UI or with the `auth0_trigger_bindings` resource.

        !> This resource appends an action to the trigger binding. In contrast, the `TriggerActions` resource manages all
        the action bindings to a trigger. To avoid potential issues, it is recommended not to use this resource in conjunction
        with the `TriggerAction` resource when binding actions to the same trigger.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        login_alert = auth0.Action("loginAlert",
            code=\"\"\"exports.onContinuePostLogin = async (event, api) => {
          console.log("foo");
        };"
        \"\"\",
            deploy=True,
            supported_triggers=auth0.ActionSupportedTriggersArgs(
                id="post-login",
                version="v3",
            ))
        post_login_alert_action = auth0.TriggerAction("postLoginAlertAction",
            trigger="post-login",
            action_id=login_alert.id)
        ```

        ## Import

        This resource can be imported by specifying the trigger and action ID separated by "::" (note the double colon) <trigger>::<actionID> # Example

        ```sh
         $ pulumi import auth0:index/triggerAction:TriggerAction post_login_action "post-login::28b5c8fa-d371-5734-acf6-d0cf80ead918"
        ```

        :param str resource_name: The name of the resource.
        :param TriggerActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 trigger: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerActionArgs.__new__(TriggerActionArgs)

            if action_id is None and not opts.urn:
                raise TypeError("Missing required property 'action_id'")
            __props__.__dict__["action_id"] = action_id
            __props__.__dict__["display_name"] = display_name
            if trigger is None and not opts.urn:
                raise TypeError("Missing required property 'trigger'")
            __props__.__dict__["trigger"] = trigger
        super(TriggerAction, __self__).__init__(
            'auth0:index/triggerAction:TriggerAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_id: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            trigger: Optional[pulumi.Input[str]] = None) -> 'TriggerAction':
        """
        Get an existing TriggerAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action_id: The ID of the action to bind to the trigger.
        :param pulumi.Input[str] display_name: The name for this action within the trigger. This can be useful for distinguishing between multiple instances of the same action bound to a trigger. Defaults to action name when not provided.
        :param pulumi.Input[str] trigger: The ID of the trigger to bind with. Available options: `post-login`, `credentials-exchange`, `pre-user-registration`, `post-user-registration`, `post-change-password`, `send-phone-message`, `password-reset-post-challenge`, `iga-approval`, `iga-certification`, `iga-fulfillment-assignment`, `iga-fulfillment-execution`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerActionState.__new__(_TriggerActionState)

        __props__.__dict__["action_id"] = action_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["trigger"] = trigger
        return TriggerAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionId")
    def action_id(self) -> pulumi.Output[str]:
        """
        The ID of the action to bind to the trigger.
        """
        return pulumi.get(self, "action_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The name for this action within the trigger. This can be useful for distinguishing between multiple instances of the same action bound to a trigger. Defaults to action name when not provided.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Output[str]:
        """
        The ID of the trigger to bind with. Available options: `post-login`, `credentials-exchange`, `pre-user-registration`, `post-user-registration`, `post-change-password`, `send-phone-message`, `password-reset-post-challenge`, `iga-approval`, `iga-certification`, `iga-fulfillment-assignment`, `iga-fulfillment-execution`.
        """
        return pulumi.get(self, "trigger")

