import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BotChannelWebChatConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#bot_name BotChannelWebChat#bot_name}
    */
    readonly botName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#location BotChannelWebChat#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#resource_group_name BotChannelWebChat#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#site_names BotChannelWebChat#site_names}
    */
    readonly siteNames: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#timeouts BotChannelWebChat#timeouts}
    */
    readonly timeouts?: BotChannelWebChatTimeouts;
}
export interface BotChannelWebChatTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#create BotChannelWebChat#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#delete BotChannelWebChat#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#read BotChannelWebChat#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat#update BotChannelWebChat#update}
    */
    readonly update?: string;
}
export declare function botChannelWebChatTimeoutsToTerraform(struct?: BotChannelWebChatTimeoutsOutputReference | BotChannelWebChatTimeouts | cdktf.IResolvable): any;
export declare class BotChannelWebChatTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BotChannelWebChatTimeouts | undefined;
    set internalValue(value: BotChannelWebChatTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat azurerm_bot_channel_web_chat}
*/
export declare class BotChannelWebChat extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_bot_channel_web_chat";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_web_chat azurerm_bot_channel_web_chat} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BotChannelWebChatConfig
    */
    constructor(scope: Construct, id: string, config: BotChannelWebChatConfig);
    private _botName?;
    get botName(): string;
    set botName(value: string);
    get botNameInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _siteNames?;
    get siteNames(): string[];
    set siteNames(value: string[]);
    get siteNamesInput(): string[] | undefined;
    private _timeouts;
    get timeouts(): BotChannelWebChatTimeoutsOutputReference;
    putTimeouts(value: BotChannelWebChatTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): BotChannelWebChatTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
