import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConsumptionBudgetResourceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#amount ConsumptionBudgetResourceGroup#amount}
    */
    readonly amount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#etag ConsumptionBudgetResourceGroup#etag}
    */
    readonly etag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#resource_group_id ConsumptionBudgetResourceGroup#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#time_grain ConsumptionBudgetResourceGroup#time_grain}
    */
    readonly timeGrain?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#filter ConsumptionBudgetResourceGroup#filter}
    */
    readonly filter?: ConsumptionBudgetResourceGroupFilter;
    /**
    * notification block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#notification ConsumptionBudgetResourceGroup#notification}
    */
    readonly notification: ConsumptionBudgetResourceGroupNotification[] | cdktf.IResolvable;
    /**
    * time_period block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#time_period ConsumptionBudgetResourceGroup#time_period}
    */
    readonly timePeriod: ConsumptionBudgetResourceGroupTimePeriod;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#timeouts ConsumptionBudgetResourceGroup#timeouts}
    */
    readonly timeouts?: ConsumptionBudgetResourceGroupTimeouts;
}
export interface ConsumptionBudgetResourceGroupFilterDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#values ConsumptionBudgetResourceGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetResourceGroupFilterDimensionToTerraform(struct?: ConsumptionBudgetResourceGroupFilterDimension | cdktf.IResolvable): any;
export interface ConsumptionBudgetResourceGroupFilterNotDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#values ConsumptionBudgetResourceGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetResourceGroupFilterNotDimensionToTerraform(struct?: ConsumptionBudgetResourceGroupFilterNotDimensionOutputReference | ConsumptionBudgetResourceGroupFilterNotDimension): any;
export declare class ConsumptionBudgetResourceGroupFilterNotDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetResourceGroupFilterNotDimension | undefined;
    set internalValue(value: ConsumptionBudgetResourceGroupFilterNotDimension | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ConsumptionBudgetResourceGroupFilterNotTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#values ConsumptionBudgetResourceGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetResourceGroupFilterNotTagToTerraform(struct?: ConsumptionBudgetResourceGroupFilterNotTagOutputReference | ConsumptionBudgetResourceGroupFilterNotTag): any;
export declare class ConsumptionBudgetResourceGroupFilterNotTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetResourceGroupFilterNotTag | undefined;
    set internalValue(value: ConsumptionBudgetResourceGroupFilterNotTag | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ConsumptionBudgetResourceGroupFilterNot {
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#dimension ConsumptionBudgetResourceGroup#dimension}
    */
    readonly dimension?: ConsumptionBudgetResourceGroupFilterNotDimension;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#tag ConsumptionBudgetResourceGroup#tag}
    */
    readonly tag?: ConsumptionBudgetResourceGroupFilterNotTag;
}
export declare function consumptionBudgetResourceGroupFilterNotToTerraform(struct?: ConsumptionBudgetResourceGroupFilterNotOutputReference | ConsumptionBudgetResourceGroupFilterNot): any;
export declare class ConsumptionBudgetResourceGroupFilterNotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetResourceGroupFilterNot | undefined;
    set internalValue(value: ConsumptionBudgetResourceGroupFilterNot | undefined);
    private _dimension;
    get dimension(): ConsumptionBudgetResourceGroupFilterNotDimensionOutputReference;
    putDimension(value: ConsumptionBudgetResourceGroupFilterNotDimension): void;
    resetDimension(): void;
    get dimensionInput(): ConsumptionBudgetResourceGroupFilterNotDimension | undefined;
    private _tag;
    get tag(): ConsumptionBudgetResourceGroupFilterNotTagOutputReference;
    putTag(value: ConsumptionBudgetResourceGroupFilterNotTag): void;
    resetTag(): void;
    get tagInput(): ConsumptionBudgetResourceGroupFilterNotTag | undefined;
}
export interface ConsumptionBudgetResourceGroupFilterTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#values ConsumptionBudgetResourceGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetResourceGroupFilterTagToTerraform(struct?: ConsumptionBudgetResourceGroupFilterTag | cdktf.IResolvable): any;
export interface ConsumptionBudgetResourceGroupFilter {
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#dimension ConsumptionBudgetResourceGroup#dimension}
    */
    readonly dimension?: ConsumptionBudgetResourceGroupFilterDimension[] | cdktf.IResolvable;
    /**
    * not block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#not ConsumptionBudgetResourceGroup#not}
    */
    readonly not?: ConsumptionBudgetResourceGroupFilterNot;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#tag ConsumptionBudgetResourceGroup#tag}
    */
    readonly tag?: ConsumptionBudgetResourceGroupFilterTag[] | cdktf.IResolvable;
}
export declare function consumptionBudgetResourceGroupFilterToTerraform(struct?: ConsumptionBudgetResourceGroupFilterOutputReference | ConsumptionBudgetResourceGroupFilter): any;
export declare class ConsumptionBudgetResourceGroupFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetResourceGroupFilter | undefined;
    set internalValue(value: ConsumptionBudgetResourceGroupFilter | undefined);
    private _dimension?;
    get dimension(): ConsumptionBudgetResourceGroupFilterDimension[] | cdktf.IResolvable;
    set dimension(value: ConsumptionBudgetResourceGroupFilterDimension[] | cdktf.IResolvable);
    resetDimension(): void;
    get dimensionInput(): cdktf.IResolvable | ConsumptionBudgetResourceGroupFilterDimension[] | undefined;
    private _not;
    get not(): ConsumptionBudgetResourceGroupFilterNotOutputReference;
    putNot(value: ConsumptionBudgetResourceGroupFilterNot): void;
    resetNot(): void;
    get notInput(): ConsumptionBudgetResourceGroupFilterNot | undefined;
    private _tag?;
    get tag(): ConsumptionBudgetResourceGroupFilterTag[] | cdktf.IResolvable;
    set tag(value: ConsumptionBudgetResourceGroupFilterTag[] | cdktf.IResolvable);
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | ConsumptionBudgetResourceGroupFilterTag[] | undefined;
}
export interface ConsumptionBudgetResourceGroupNotification {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#contact_emails ConsumptionBudgetResourceGroup#contact_emails}
    */
    readonly contactEmails?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#contact_groups ConsumptionBudgetResourceGroup#contact_groups}
    */
    readonly contactGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#contact_roles ConsumptionBudgetResourceGroup#contact_roles}
    */
    readonly contactRoles?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#enabled ConsumptionBudgetResourceGroup#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#threshold ConsumptionBudgetResourceGroup#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#threshold_type ConsumptionBudgetResourceGroup#threshold_type}
    */
    readonly thresholdType?: string;
}
export declare function consumptionBudgetResourceGroupNotificationToTerraform(struct?: ConsumptionBudgetResourceGroupNotification | cdktf.IResolvable): any;
export interface ConsumptionBudgetResourceGroupTimePeriod {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#end_date ConsumptionBudgetResourceGroup#end_date}
    */
    readonly endDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#start_date ConsumptionBudgetResourceGroup#start_date}
    */
    readonly startDate: string;
}
export declare function consumptionBudgetResourceGroupTimePeriodToTerraform(struct?: ConsumptionBudgetResourceGroupTimePeriodOutputReference | ConsumptionBudgetResourceGroupTimePeriod): any;
export declare class ConsumptionBudgetResourceGroupTimePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetResourceGroupTimePeriod | undefined;
    set internalValue(value: ConsumptionBudgetResourceGroupTimePeriod | undefined);
    private _endDate?;
    get endDate(): string;
    set endDate(value: string);
    resetEndDate(): void;
    get endDateInput(): string | undefined;
    private _startDate?;
    get startDate(): string;
    set startDate(value: string);
    get startDateInput(): string | undefined;
}
export interface ConsumptionBudgetResourceGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#create ConsumptionBudgetResourceGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#delete ConsumptionBudgetResourceGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#read ConsumptionBudgetResourceGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group#update ConsumptionBudgetResourceGroup#update}
    */
    readonly update?: string;
}
export declare function consumptionBudgetResourceGroupTimeoutsToTerraform(struct?: ConsumptionBudgetResourceGroupTimeoutsOutputReference | ConsumptionBudgetResourceGroupTimeouts | cdktf.IResolvable): any;
export declare class ConsumptionBudgetResourceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetResourceGroupTimeouts | undefined;
    set internalValue(value: ConsumptionBudgetResourceGroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group azurerm_consumption_budget_resource_group}
*/
export declare class ConsumptionBudgetResourceGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_consumption_budget_resource_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_resource_group azurerm_consumption_budget_resource_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConsumptionBudgetResourceGroupConfig
    */
    constructor(scope: Construct, id: string, config: ConsumptionBudgetResourceGroupConfig);
    private _amount?;
    get amount(): number;
    set amount(value: number);
    get amountInput(): number | undefined;
    private _etag?;
    get etag(): string;
    set etag(value: string);
    resetEtag(): void;
    get etagInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    private _timeGrain?;
    get timeGrain(): string;
    set timeGrain(value: string);
    resetTimeGrain(): void;
    get timeGrainInput(): string | undefined;
    private _filter;
    get filter(): ConsumptionBudgetResourceGroupFilterOutputReference;
    putFilter(value: ConsumptionBudgetResourceGroupFilter): void;
    resetFilter(): void;
    get filterInput(): ConsumptionBudgetResourceGroupFilter | undefined;
    private _notification?;
    get notification(): ConsumptionBudgetResourceGroupNotification[] | cdktf.IResolvable;
    set notification(value: ConsumptionBudgetResourceGroupNotification[] | cdktf.IResolvable);
    get notificationInput(): cdktf.IResolvable | ConsumptionBudgetResourceGroupNotification[] | undefined;
    private _timePeriod;
    get timePeriod(): ConsumptionBudgetResourceGroupTimePeriodOutputReference;
    putTimePeriod(value: ConsumptionBudgetResourceGroupTimePeriod): void;
    get timePeriodInput(): ConsumptionBudgetResourceGroupTimePeriod | undefined;
    private _timeouts;
    get timeouts(): ConsumptionBudgetResourceGroupTimeoutsOutputReference;
    putTimeouts(value: ConsumptionBudgetResourceGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ConsumptionBudgetResourceGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
