import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#admin_enabled ContainerRegistry#admin_enabled}
    */
    readonly adminEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#anonymous_pull_enabled ContainerRegistry#anonymous_pull_enabled}
    */
    readonly anonymousPullEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#data_endpoint_enabled ContainerRegistry#data_endpoint_enabled}
    */
    readonly dataEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#encryption ContainerRegistry#encryption}
    */
    readonly encryption?: ContainerRegistryEncryption[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#export_policy_enabled ContainerRegistry#export_policy_enabled}
    */
    readonly exportPolicyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#georeplication_locations ContainerRegistry#georeplication_locations}
    */
    readonly georeplicationLocations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#georeplications ContainerRegistry#georeplications}
    */
    readonly georeplications?: ContainerRegistryGeoreplications[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#location ContainerRegistry#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#name ContainerRegistry#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#network_rule_bypass_option ContainerRegistry#network_rule_bypass_option}
    */
    readonly networkRuleBypassOption?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#network_rule_set ContainerRegistry#network_rule_set}
    */
    readonly networkRuleSet?: ContainerRegistryNetworkRuleSet[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#public_network_access_enabled ContainerRegistry#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#quarantine_policy_enabled ContainerRegistry#quarantine_policy_enabled}
    */
    readonly quarantinePolicyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#resource_group_name ContainerRegistry#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#retention_policy ContainerRegistry#retention_policy}
    */
    readonly retentionPolicy?: ContainerRegistryRetentionPolicy[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#sku ContainerRegistry#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#storage_account_id ContainerRegistry#storage_account_id}
    */
    readonly storageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#tags ContainerRegistry#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#trust_policy ContainerRegistry#trust_policy}
    */
    readonly trustPolicy?: ContainerRegistryTrustPolicy[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#zone_redundancy_enabled ContainerRegistry#zone_redundancy_enabled}
    */
    readonly zoneRedundancyEnabled?: boolean | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#identity ContainerRegistry#identity}
    */
    readonly identity?: ContainerRegistryIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#timeouts ContainerRegistry#timeouts}
    */
    readonly timeouts?: ContainerRegistryTimeouts;
}
export interface ContainerRegistryEncryption {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#enabled ContainerRegistry#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#identity_client_id ContainerRegistry#identity_client_id}
    */
    readonly identityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#key_vault_key_id ContainerRegistry#key_vault_key_id}
    */
    readonly keyVaultKeyId?: string;
}
export declare function containerRegistryEncryptionToTerraform(struct?: ContainerRegistryEncryption | cdktf.IResolvable): any;
export interface ContainerRegistryGeoreplications {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#location ContainerRegistry#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#regional_endpoint_enabled ContainerRegistry#regional_endpoint_enabled}
    */
    readonly regionalEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#tags ContainerRegistry#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#zone_redundancy_enabled ContainerRegistry#zone_redundancy_enabled}
    */
    readonly zoneRedundancyEnabled?: boolean | cdktf.IResolvable;
}
export declare function containerRegistryGeoreplicationsToTerraform(struct?: ContainerRegistryGeoreplications | cdktf.IResolvable): any;
export interface ContainerRegistryNetworkRuleSetIpRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#action ContainerRegistry#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#ip_range ContainerRegistry#ip_range}
    */
    readonly ipRange?: string;
}
export declare function containerRegistryNetworkRuleSetIpRuleToTerraform(struct?: ContainerRegistryNetworkRuleSetIpRule | cdktf.IResolvable): any;
export interface ContainerRegistryNetworkRuleSetVirtualNetwork {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#action ContainerRegistry#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#subnet_id ContainerRegistry#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function containerRegistryNetworkRuleSetVirtualNetworkToTerraform(struct?: ContainerRegistryNetworkRuleSetVirtualNetwork | cdktf.IResolvable): any;
export interface ContainerRegistryNetworkRuleSet {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#default_action ContainerRegistry#default_action}
    */
    readonly defaultAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#ip_rule ContainerRegistry#ip_rule}
    */
    readonly ipRule?: ContainerRegistryNetworkRuleSetIpRule[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#virtual_network ContainerRegistry#virtual_network}
    */
    readonly virtualNetwork?: ContainerRegistryNetworkRuleSetVirtualNetwork[] | cdktf.IResolvable;
}
export declare function containerRegistryNetworkRuleSetToTerraform(struct?: ContainerRegistryNetworkRuleSet | cdktf.IResolvable): any;
export interface ContainerRegistryRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#days ContainerRegistry#days}
    */
    readonly days?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#enabled ContainerRegistry#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function containerRegistryRetentionPolicyToTerraform(struct?: ContainerRegistryRetentionPolicy | cdktf.IResolvable): any;
export interface ContainerRegistryTrustPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#enabled ContainerRegistry#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function containerRegistryTrustPolicyToTerraform(struct?: ContainerRegistryTrustPolicy | cdktf.IResolvable): any;
export interface ContainerRegistryIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#identity_ids ContainerRegistry#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#type ContainerRegistry#type}
    */
    readonly type: string;
}
export declare function containerRegistryIdentityToTerraform(struct?: ContainerRegistryIdentityOutputReference | ContainerRegistryIdentity): any;
export declare class ContainerRegistryIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryIdentity | undefined;
    set internalValue(value: ContainerRegistryIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ContainerRegistryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#create ContainerRegistry#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#delete ContainerRegistry#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#read ContainerRegistry#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry#update ContainerRegistry#update}
    */
    readonly update?: string;
}
export declare function containerRegistryTimeoutsToTerraform(struct?: ContainerRegistryTimeoutsOutputReference | ContainerRegistryTimeouts | cdktf.IResolvable): any;
export declare class ContainerRegistryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTimeouts | undefined;
    set internalValue(value: ContainerRegistryTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry azurerm_container_registry}
*/
export declare class ContainerRegistry extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_registry";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry azurerm_container_registry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerRegistryConfig
    */
    constructor(scope: Construct, id: string, config: ContainerRegistryConfig);
    private _adminEnabled?;
    get adminEnabled(): boolean | cdktf.IResolvable;
    set adminEnabled(value: boolean | cdktf.IResolvable);
    resetAdminEnabled(): void;
    get adminEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get adminPassword(): string;
    get adminUsername(): string;
    private _anonymousPullEnabled?;
    get anonymousPullEnabled(): boolean | cdktf.IResolvable;
    set anonymousPullEnabled(value: boolean | cdktf.IResolvable);
    resetAnonymousPullEnabled(): void;
    get anonymousPullEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEndpointEnabled?;
    get dataEndpointEnabled(): boolean | cdktf.IResolvable;
    set dataEndpointEnabled(value: boolean | cdktf.IResolvable);
    resetDataEndpointEnabled(): void;
    get dataEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _encryption?;
    get encryption(): ContainerRegistryEncryption[] | cdktf.IResolvable;
    set encryption(value: ContainerRegistryEncryption[] | cdktf.IResolvable);
    resetEncryption(): void;
    get encryptionInput(): cdktf.IResolvable | ContainerRegistryEncryption[] | undefined;
    private _exportPolicyEnabled?;
    get exportPolicyEnabled(): boolean | cdktf.IResolvable;
    set exportPolicyEnabled(value: boolean | cdktf.IResolvable);
    resetExportPolicyEnabled(): void;
    get exportPolicyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _georeplicationLocations?;
    get georeplicationLocations(): string[];
    set georeplicationLocations(value: string[]);
    resetGeoreplicationLocations(): void;
    get georeplicationLocationsInput(): string[] | undefined;
    private _georeplications?;
    get georeplications(): ContainerRegistryGeoreplications[] | cdktf.IResolvable;
    set georeplications(value: ContainerRegistryGeoreplications[] | cdktf.IResolvable);
    resetGeoreplications(): void;
    get georeplicationsInput(): cdktf.IResolvable | ContainerRegistryGeoreplications[] | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get loginServer(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkRuleBypassOption?;
    get networkRuleBypassOption(): string;
    set networkRuleBypassOption(value: string);
    resetNetworkRuleBypassOption(): void;
    get networkRuleBypassOptionInput(): string | undefined;
    private _networkRuleSet?;
    get networkRuleSet(): ContainerRegistryNetworkRuleSet[] | cdktf.IResolvable;
    set networkRuleSet(value: ContainerRegistryNetworkRuleSet[] | cdktf.IResolvable);
    resetNetworkRuleSet(): void;
    get networkRuleSetInput(): cdktf.IResolvable | ContainerRegistryNetworkRuleSet[] | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _quarantinePolicyEnabled?;
    get quarantinePolicyEnabled(): boolean | cdktf.IResolvable;
    set quarantinePolicyEnabled(value: boolean | cdktf.IResolvable);
    resetQuarantinePolicyEnabled(): void;
    get quarantinePolicyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _retentionPolicy?;
    get retentionPolicy(): ContainerRegistryRetentionPolicy[] | cdktf.IResolvable;
    set retentionPolicy(value: ContainerRegistryRetentionPolicy[] | cdktf.IResolvable);
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): cdktf.IResolvable | ContainerRegistryRetentionPolicy[] | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _trustPolicy?;
    get trustPolicy(): ContainerRegistryTrustPolicy[] | cdktf.IResolvable;
    set trustPolicy(value: ContainerRegistryTrustPolicy[] | cdktf.IResolvable);
    resetTrustPolicy(): void;
    get trustPolicyInput(): cdktf.IResolvable | ContainerRegistryTrustPolicy[] | undefined;
    private _zoneRedundancyEnabled?;
    get zoneRedundancyEnabled(): boolean | cdktf.IResolvable;
    set zoneRedundancyEnabled(value: boolean | cdktf.IResolvable);
    resetZoneRedundancyEnabled(): void;
    get zoneRedundancyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _identity;
    get identity(): ContainerRegistryIdentityOutputReference;
    putIdentity(value: ContainerRegistryIdentity): void;
    resetIdentity(): void;
    get identityInput(): ContainerRegistryIdentity | undefined;
    private _timeouts;
    get timeouts(): ContainerRegistryTimeoutsOutputReference;
    putTimeouts(value: ContainerRegistryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ContainerRegistryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
