import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermEventhubClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_cluster#name DataAzurermEventhubCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_cluster#resource_group_name DataAzurermEventhubCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_cluster#timeouts DataAzurermEventhubCluster#timeouts}
    */
    readonly timeouts?: DataAzurermEventhubClusterTimeouts;
}
export interface DataAzurermEventhubClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_cluster#read DataAzurermEventhubCluster#read}
    */
    readonly read?: string;
}
export declare function dataAzurermEventhubClusterTimeoutsToTerraform(struct?: DataAzurermEventhubClusterTimeoutsOutputReference | DataAzurermEventhubClusterTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermEventhubClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermEventhubClusterTimeouts | undefined;
    set internalValue(value: DataAzurermEventhubClusterTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_cluster azurerm_eventhub_cluster}
*/
export declare class DataAzurermEventhubCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_eventhub_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_cluster azurerm_eventhub_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermEventhubClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermEventhubClusterConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    private _timeouts;
    get timeouts(): DataAzurermEventhubClusterTimeoutsOutputReference;
    putTimeouts(value: DataAzurermEventhubClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermEventhubClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
