import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageContainerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container#metadata DataAzurermStorageContainer#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container#name DataAzurermStorageContainer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container#storage_account_name DataAzurermStorageContainer#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container#timeouts DataAzurermStorageContainer#timeouts}
    */
    readonly timeouts?: DataAzurermStorageContainerTimeouts;
}
export interface DataAzurermStorageContainerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container#read DataAzurermStorageContainer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageContainerTimeoutsToTerraform(struct?: DataAzurermStorageContainerTimeoutsOutputReference | DataAzurermStorageContainerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageContainerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageContainerTimeouts | undefined;
    set internalValue(value: DataAzurermStorageContainerTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container azurerm_storage_container}
*/
export declare class DataAzurermStorageContainer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_storage_container";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container azurerm_storage_container} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageContainerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageContainerConfig);
    get containerAccessType(): string;
    get hasImmutabilityPolicy(): cdktf.IResolvable;
    get hasLegalHold(): cdktf.IResolvable;
    get id(): string;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get resourceManagerId(): string;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermStorageContainerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageContainerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermStorageContainerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
