import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceFabricMeshLocalNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network#description ServiceFabricMeshLocalNetwork#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network#location ServiceFabricMeshLocalNetwork#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network#name ServiceFabricMeshLocalNetwork#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network#network_address_prefix ServiceFabricMeshLocalNetwork#network_address_prefix}
    */
    readonly networkAddressPrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network#resource_group_name ServiceFabricMeshLocalNetwork#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network#tags ServiceFabricMeshLocalNetwork#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network#timeouts ServiceFabricMeshLocalNetwork#timeouts}
    */
    readonly timeouts?: ServiceFabricMeshLocalNetworkTimeouts;
}
export interface ServiceFabricMeshLocalNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network#create ServiceFabricMeshLocalNetwork#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network#delete ServiceFabricMeshLocalNetwork#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network#read ServiceFabricMeshLocalNetwork#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network#update ServiceFabricMeshLocalNetwork#update}
    */
    readonly update?: string;
}
export declare function serviceFabricMeshLocalNetworkTimeoutsToTerraform(struct?: ServiceFabricMeshLocalNetworkTimeoutsOutputReference | ServiceFabricMeshLocalNetworkTimeouts | cdktf.IResolvable): any;
export declare class ServiceFabricMeshLocalNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricMeshLocalNetworkTimeouts | undefined;
    set internalValue(value: ServiceFabricMeshLocalNetworkTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network azurerm_service_fabric_mesh_local_network}
*/
export declare class ServiceFabricMeshLocalNetwork extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_service_fabric_mesh_local_network";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_local_network azurerm_service_fabric_mesh_local_network} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceFabricMeshLocalNetworkConfig
    */
    constructor(scope: Construct, id: string, config: ServiceFabricMeshLocalNetworkConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkAddressPrefix?;
    get networkAddressPrefix(): string;
    set networkAddressPrefix(value: string);
    get networkAddressPrefixInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): ServiceFabricMeshLocalNetworkTimeoutsOutputReference;
    putTimeouts(value: ServiceFabricMeshLocalNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServiceFabricMeshLocalNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
