import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageDataLakeGen2PathConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#filesystem_name StorageDataLakeGen2Path#filesystem_name}
    */
    readonly filesystemName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#group StorageDataLakeGen2Path#group}
    */
    readonly group?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#owner StorageDataLakeGen2Path#owner}
    */
    readonly owner?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#path StorageDataLakeGen2Path#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#resource StorageDataLakeGen2Path#resource}
    */
    readonly resource: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#storage_account_id StorageDataLakeGen2Path#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * ace block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#ace StorageDataLakeGen2Path#ace}
    */
    readonly ace?: StorageDataLakeGen2PathAce[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#timeouts StorageDataLakeGen2Path#timeouts}
    */
    readonly timeouts?: StorageDataLakeGen2PathTimeouts;
}
export interface StorageDataLakeGen2PathAce {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#id StorageDataLakeGen2Path#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#permissions StorageDataLakeGen2Path#permissions}
    */
    readonly permissions: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#scope StorageDataLakeGen2Path#scope}
    */
    readonly scope?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#type StorageDataLakeGen2Path#type}
    */
    readonly type: string;
}
export declare function storageDataLakeGen2PathAceToTerraform(struct?: StorageDataLakeGen2PathAce | cdktf.IResolvable): any;
export interface StorageDataLakeGen2PathTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#create StorageDataLakeGen2Path#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#delete StorageDataLakeGen2Path#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#read StorageDataLakeGen2Path#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path#update StorageDataLakeGen2Path#update}
    */
    readonly update?: string;
}
export declare function storageDataLakeGen2PathTimeoutsToTerraform(struct?: StorageDataLakeGen2PathTimeoutsOutputReference | StorageDataLakeGen2PathTimeouts | cdktf.IResolvable): any;
export declare class StorageDataLakeGen2PathTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageDataLakeGen2PathTimeouts | undefined;
    set internalValue(value: StorageDataLakeGen2PathTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path azurerm_storage_data_lake_gen2_path}
*/
export declare class StorageDataLakeGen2Path extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_data_lake_gen2_path";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path azurerm_storage_data_lake_gen2_path} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageDataLakeGen2PathConfig
    */
    constructor(scope: Construct, id: string, config: StorageDataLakeGen2PathConfig);
    private _filesystemName?;
    get filesystemName(): string;
    set filesystemName(value: string);
    get filesystemNameInput(): string | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    get id(): string;
    private _owner?;
    get owner(): string;
    set owner(value: string);
    resetOwner(): void;
    get ownerInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _ace?;
    get ace(): StorageDataLakeGen2PathAce[] | cdktf.IResolvable;
    set ace(value: StorageDataLakeGen2PathAce[] | cdktf.IResolvable);
    resetAce(): void;
    get aceInput(): cdktf.IResolvable | StorageDataLakeGen2PathAce[] | undefined;
    private _timeouts;
    get timeouts(): StorageDataLakeGen2PathTimeoutsOutputReference;
    putTimeouts(value: StorageDataLakeGen2PathTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageDataLakeGen2PathTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
