import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubnetNatGatewayAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_nat_gateway_association#nat_gateway_id SubnetNatGatewayAssociation#nat_gateway_id}
    */
    readonly natGatewayId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_nat_gateway_association#subnet_id SubnetNatGatewayAssociation#subnet_id}
    */
    readonly subnetId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_nat_gateway_association#timeouts SubnetNatGatewayAssociation#timeouts}
    */
    readonly timeouts?: SubnetNatGatewayAssociationTimeouts;
}
export interface SubnetNatGatewayAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_nat_gateway_association#create SubnetNatGatewayAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_nat_gateway_association#delete SubnetNatGatewayAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_nat_gateway_association#read SubnetNatGatewayAssociation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_nat_gateway_association#update SubnetNatGatewayAssociation#update}
    */
    readonly update?: string;
}
export declare function subnetNatGatewayAssociationTimeoutsToTerraform(struct?: SubnetNatGatewayAssociationTimeoutsOutputReference | SubnetNatGatewayAssociationTimeouts | cdktf.IResolvable): any;
export declare class SubnetNatGatewayAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubnetNatGatewayAssociationTimeouts | undefined;
    set internalValue(value: SubnetNatGatewayAssociationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_nat_gateway_association azurerm_subnet_nat_gateway_association}
*/
export declare class SubnetNatGatewayAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_subnet_nat_gateway_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_nat_gateway_association azurerm_subnet_nat_gateway_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubnetNatGatewayAssociationConfig
    */
    constructor(scope: Construct, id: string, config: SubnetNatGatewayAssociationConfig);
    get id(): string;
    private _natGatewayId?;
    get natGatewayId(): string;
    set natGatewayId(value: string);
    get natGatewayIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SubnetNatGatewayAssociationTimeoutsOutputReference;
    putTimeouts(value: SubnetNatGatewayAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SubnetNatGatewayAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
