import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubnetRouteTableAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_route_table_association#route_table_id SubnetRouteTableAssociation#route_table_id}
    */
    readonly routeTableId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_route_table_association#subnet_id SubnetRouteTableAssociation#subnet_id}
    */
    readonly subnetId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_route_table_association#timeouts SubnetRouteTableAssociation#timeouts}
    */
    readonly timeouts?: SubnetRouteTableAssociationTimeouts;
}
export interface SubnetRouteTableAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_route_table_association#create SubnetRouteTableAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_route_table_association#delete SubnetRouteTableAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_route_table_association#read SubnetRouteTableAssociation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_route_table_association#update SubnetRouteTableAssociation#update}
    */
    readonly update?: string;
}
export declare function subnetRouteTableAssociationTimeoutsToTerraform(struct?: SubnetRouteTableAssociationTimeoutsOutputReference | SubnetRouteTableAssociationTimeouts | cdktf.IResolvable): any;
export declare class SubnetRouteTableAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubnetRouteTableAssociationTimeouts | undefined;
    set internalValue(value: SubnetRouteTableAssociationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_route_table_association azurerm_subnet_route_table_association}
*/
export declare class SubnetRouteTableAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_subnet_route_table_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/subnet_route_table_association azurerm_subnet_route_table_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubnetRouteTableAssociationConfig
    */
    constructor(scope: Construct, id: string, config: SubnetRouteTableAssociationConfig);
    get id(): string;
    private _routeTableId?;
    get routeTableId(): string;
    set routeTableId(value: string);
    get routeTableIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SubnetRouteTableAssociationTimeoutsOutputReference;
    putTimeouts(value: SubnetRouteTableAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SubnetRouteTableAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
