"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const cognito_verifier_1 = require("./aws-jwt-verify-ripout/cognito-verifier");
async function handler(event) {
    var _a, _b, _c, _d, _e, _f, _g;
    console.debug(`event: ${JSON.stringify(event)}`);
    const request = event.Records[0].cf.request;
    // Example request including the token.
    // "request": {
    //     "headers": {
    //         "cookie": [
    //             {
    //                 "key": "Cookie",
    //                 "value": "token=ey123"
    //             }
    //         ],
    //     },
    // }
    // Consider using Postman with collection in devops/test/Test.postman_collection.json for testing like with cookies.
    // For Debugging with Cloudwatch go to the AWS Console --> Cloudwatch --> Log groups --> switch to the region you are closest to --> figure out which log group is correct
    const token = ((_c = (_b = (_a = request.headers.cookie) === null || _a === void 0 ? void 0 : _a.filter(cookie => cookie.key === 'Cookie' && cookie.value.startsWith('token'))) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.value.substring(6)) || 'notValid';
    if (token) {
        console.debug('got token in cookie');
        const userPoolId = ((_e = (_d = request.origin) === null || _d === void 0 ? void 0 : _d.s3) === null || _e === void 0 ? void 0 : _e.customHeaders['x-env-userpoolid'][0].value) || '';
        const clientId = ((_g = (_f = request.origin) === null || _f === void 0 ? void 0 : _f.s3) === null || _g === void 0 ? void 0 : _g.customHeaders['x-env-clientid'][0].value) || '';
        console.debug(`userPoolId: ${userPoolId}`);
        console.debug(`clientId: ${clientId}`);
        const verifier = cognito_verifier_1.CognitoJwtVerifier.create({
            userPoolId,
            tokenUse: 'access',
            clientId,
        });
        try {
            const payload = await verifier.verify(token);
            console.debug('Token is valid. Payload:', payload);
            return request;
        }
        catch {
            console.error(`Unauthorized JWT ${token === 'notValid' ? 'missing token' : ''}`);
            const response = {
                status: '401',
                statusDescription: `Unauthorized JWT ${token === 'notValid' ? 'missing token' : ''}`,
                headers: {
                    location: [
                        {
                            key: 'Location',
                            value: 'www.mianio.com/401',
                        },
                    ],
                },
            };
            return response;
        }
        // return { status: 200, body: `hab token ${token}` };
    }
    else {
        console.debug('got no token in cookie :(');
    }
    const unauthorizedResponse = {
        status: '403',
        statusDescription: 'Forbidden',
        headers: {
            location: [
                {
                    key: 'Location',
                    value: 'www.mianio.com/403',
                },
            ],
        },
    };
    return unauthorizedResponse;
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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