from typing import Any, Callable, Dict, List, Optional
from pydantic import BaseModel


class AgentSchemaBaseModel(BaseModel):
    id: Optional[str] = None
    llm: Optional[Any] = None
    template: Optional[str] = None
    max_loops: Optional[int] = None
    stopping_condition: Optional[Callable[[str], bool]] = None
    loop_interval: Optional[int] = None
    retry_attempts: Optional[int] = None
    retry_interval: Optional[int] = None
    return_history: Optional[bool] = False
    stopping_token: Optional[str] = None
    dynamic_loops: Optional[bool] = False
    interactive: Optional[bool] = False
    dashboard: Optional[bool] = False
    agent_name: Optional[str] = None
    agent_description: Optional[str] = None
    system_prompt: Optional[str] = None
    tools: Optional[List[Callable]] = None
    dynamic_temperature_enabled: Optional[bool] = None
    sop: Optional[str] = None
    sop_list: Optional[List[str]] = None
    saved_state_path: Optional[str] = None
    autosave: Optional[bool] = True
    context_length: Optional[int] = None
    user_name: Optional[str] = None
    self_healing_enabled: Optional[bool] = None
    code_interpreter: Optional[bool] = False
    multi_modal: Optional[bool] = False
    pdf_path: Optional[str] = None
    list_of_pdf: Optional[str] = None
    tokenizer: Optional[Any] = None
    long_term_memory: Optional[Any] = None
    preset_stopping_token: Optional[bool] = False
    traceback: Optional[Any] = None
    traceback_handlers: Optional[Any] = None
    streaming_on: Optional[bool] = False
    docs: Optional[List[str]] = None
    docs_folder: Optional[str] = None
    verbose: Optional[bool] = True
    parser: Optional[Callable] = None
    best_of_n: Optional[int] = None
    callback: Optional[Callable] = None
    metadata: Optional[Dict[str, Any]] = None
    callbacks: Optional[List[Callable]] = None
    logger_handler: Optional[Any] = None
    search_algorithm: Optional[Callable] = None
    logs_to_filename: Optional[str] = None
    evaluator: Optional[Callable] = None
    output_json: Optional[bool] = False
    stopping_func: Optional[Callable] = None
    custom_loop_condition: Optional[Callable] = None
    sentiment_threshold: Optional[float] = None
    custom_exit_command: Optional[str] = None
    sentiment_analyzer: Optional[Callable] = None
    limit_tokens_from_string: Optional[Callable] = None
    custom_tools_prompt: Optional[Callable] = None
    tool_schema: Optional[Any] = None
    output_type: Optional[Any] = None
    function_calling_type: Optional[str] = None
    output_cleaner: Optional[Callable] = None
    function_calling_format_type: Optional[str] = None
    list_base_models: Optional[List[Any]] = None
    metadata_output_type: Optional[str] = None
    state_save_file_type: Optional[str] = None
    chain_of_thoughts: Optional[bool] = False
    algorithm_of_thoughts: Optional[bool] = False
    tree_of_thoughts: Optional[bool] = False
    tool_choice: Optional[str] = None
    execute_tool: Optional[bool] = False
    rules: Optional[str] = None
    planning: Optional[str] = None
    planning_prompt: Optional[str] = None
    device: Optional[str] = None
    custom_planning_prompt: Optional[str] = None
