from ..sc_test_case import SCTestCase
from odoo.exceptions import ValidationError


class ProductCategoryTechnologySupplier(SCTestCase):

    def setUp(self, *args, **kwargs):
        super().setUp(*args, **kwargs)
        self.partner = self.browse_ref('base.partner_demo')
        self.router_product = self.env['product.product'].search(
            [
                ("default_code", "=", "NCDS224WTV"),
            ]
        )
        self.router_lot = self.env['stock.production.lot'].create({
            'product_id': self.router_product.id,
            'name': '123',
            'router_mac_address': '12:BB:CC:DD:EE:90'
        })
        self.mobile_contract_service_info = self.env[
            'mobile.service.contract.info'
        ].create({
            'phone_number': '654987654',
            'icc': '123'
        })
        self.adsl_contract_service_info = self.env[
            'adsl.service.contract.info'
        ].create({
            'phone_number': '654987654',
            'administrative_number': '123',
            'router_product_id': self.router_product.id,
            'router_lot_id': self.router_lot.id,
            'ppp_user': 'ringo',
            'ppp_password': 'rango',
            'endpoint_user': 'user',
            'endpoint_password': 'password'
        })
        self.vodafone_fiber_contract_service_info = self.env[
            'vodafone.fiber.service.contract.info'
        ].create({
            'phone_number': '654321123',
            'vodafone_id': '123',
            'vodafone_offer_code': '456',
        })
        self.router_4G_contract_service_info = self.env[
            'router.4g.service.contract.info'
        ].create({
            'phone_number': '654321123',
            'vodafone_id': '123',
            'vodafone_offer_code': '456',
            'icc': '2222'
        })
        self.mm_fiber_contract_service_info = self.env[
            'mm.fiber.service.contract.info'
        ].create({
            'phone_number': '654321123',
            'mm_id': '123',
        })
        self.orange_fiber_contract_service_info = self.env[
            'orange.fiber.service.contract.info'
        ].create({
            'suma_id': '123',
        })
        self.xoln_fiber_contract_service_info = self.env[
            'xoln.fiber.service.contract.info'
        ].create({
            'phone_number': '654321123',
            'external_id': '123',
            'project': 'laBorda',
            'id_order': '456',
            'router_product_id': self.router_product.id,
            'router_lot_id': self.router_lot.id,
        })

        self.contract_adsl_args = {
            'name': 'contract w/service technology to adsl',
            'service_technology_id': self.ref(
                'somconnexio.service_technology_adsl'
            ),
            'service_supplier_id': self.ref(
                'somconnexio.service_supplier_jazztel'
            ),
            'partner_id': self.partner.id,
            'service_partner_id': self.partner.id,
            'invoice_partner_id': self.partner.id,
            'bank_id': self.partner.bank_ids[0].id,
            'adsl_service_contract_info_id': (
                self.adsl_contract_service_info.id
            ),
            'contract_line_ids': []
        }
        self.contract_mobile_args = {
            'name': 'contract w/category contract to mobile '
                    'and w/o service technology',
            'service_technology_id': self.ref(
                'somconnexio.service_technology_mobile'
            ),
            'service_supplier_id': self.ref(
                'somconnexio.service_supplier_masmovil'
            ),
            'partner_id': self.partner.id,
            'invoice_partner_id': self.partner.id,
            'bank_id': self.partner.bank_ids[0].id,
            'contract_line_ids': [],
            'mobile_contract_service_info_id': (
                self.mobile_contract_service_info.id
            ),
        }
        self.contract_fiber_args = {
            'name': 'contract w/service technology to fiber',
            'service_technology_id': self.ref(
                'somconnexio.service_technology_fiber'
            ),
            'service_supplier_id': self.ref(
                'somconnexio.service_supplier_vodafone'
            ),
            'vodafone_fiber_service_contract_info_id': (
                self.vodafone_fiber_contract_service_info.id
            ),
            'partner_id': self.partner.id,
            'service_partner_id': self.partner.id,
            'invoice_partner_id': self.partner.id,
            'bank_id': self.partner.bank_ids[0].id,
            'contract_line_ids': []
        }

        self.contract_fiber_xoln_args = {
            'name': 'contract w/service technology to fiber',
            'service_technology_id': self.ref(
                'somconnexio.service_technology_fiber'
            ),
            'service_supplier_id': self.ref(
                'somconnexio.service_supplier_xoln'
            ),
            'xoln_fiber_service_contract_info_id': (
                self.xoln_fiber_contract_service_info.id
            ),
            'partner_id': self.partner.id,
            'service_partner_id': self.partner.id,
            'invoice_partner_id': self.partner.id,
            'bank_id': self.partner.bank_ids[0].id,
            'contract_line_ids': []
        }

        self.contract_fiber_orange_args = {
            'name': 'contract w/service technology to fiber',
            'service_technology_id': self.ref(
                'somconnexio.service_technology_fiber'
            ),
            'service_supplier_id': self.ref(
                'somconnexio.service_supplier_orange'
            ),
            'orange_fiber_service_contract_info_id': (
                self.orange_fiber_contract_service_info.id
            ),
            'partner_id': self.partner.id,
            'service_partner_id': self.partner.id,
            'invoice_partner_id': self.partner.id,
            'bank_id': self.partner.bank_ids[0].id,
            'contract_line_ids': []
        }

        self.contract_router_4G_args = {
            'name': 'contract with router 4G technology',
            'service_technology_id': self.ref(
                'somconnexio.service_technology_4G'
            ),
            'service_supplier_id': self.ref(
                'somconnexio.service_supplier_vodafone'
            ),
            'router_4G_service_contract_info_id': (
                self.router_4G_contract_service_info.id
            ),
            'partner_id': self.partner.id,
            'service_partner_id': self.partner.id,
            'invoice_partner_id': self.partner.id,
            'contract_line_ids': []
        }

        broadband_adsl_product_tmpl_args = {
            'name': 'ADSL 20Mb',
            'type': 'service',
            'categ_id': self.ref('somconnexio.broadband_adsl_service')
        }
        product_adsl_broadband_tmpl = self.env['product.template'].create(
            broadband_adsl_product_tmpl_args
        )
        self.product_broadband_adsl = product_adsl_broadband_tmpl.product_variant_id

        broadband_adsl_oneshot_product_tmpl_args = {
            'name': 'Alta parell existent a terminis',
            'type': 'service',
            'categ_id': self.ref('somconnexio.broadband_oneshot_adsl_service')
        }
        product_adsl_oneshot_tmpl = self.env['product.template'].create(
            broadband_adsl_oneshot_product_tmpl_args
        )
        self.product_broadband_adsl_oneshot = product_adsl_oneshot_tmpl.product_variant_id  # noqa

        broadband_fiber_product_tmpl_args = {
            'name': 'Fiber',
            'type': 'service',
            'categ_id': self.ref('somconnexio.broadband_fiber_service')
        }
        product_broadband_fiber_tmpl = self.env['product.template'].create(
            broadband_fiber_product_tmpl_args
        )
        self.product_broadband_fiber = product_broadband_fiber_tmpl.product_variant_id

        xoln_fiber_product_tmpl_args = {
            'name': 'Fiber',
            'type': 'service',
            'categ_id': self.ref('somconnexio.broadband_fiber_service')
        }
        product_xoln_fiber_tmpl = self.env['product.template'].create(
            xoln_fiber_product_tmpl_args
        )
        self.product_xoln_fiber = product_xoln_fiber_tmpl.product_variant_id

        broadband_oneshot_product_tmpl_args = {
            'name': 'Recollida router',
            'type': 'service',
            'categ_id': self.ref('somconnexio.broadband_oneshot_service')
        }
        product_oneshot_tmpl = self.env['product.template'].create(
            broadband_oneshot_product_tmpl_args
        )
        self.product_broadband_oneshot = product_oneshot_tmpl.product_variant_id

        mobile_product_tmpl_args = {
            'name': 'Sense minutes',
            'type': 'service',
            'categ_id': self.ref('somconnexio.mobile_service')
        }
        product_mobile_tmpl = self.env['product.template'].create(
            mobile_product_tmpl_args
        )
        self.product_mobile = product_mobile_tmpl.product_variant_id

        self.product_wo_fix_fiber = self.browse_ref('somconnexio.SenseFixFibra100Mb')

        mobile_oneshot_product_tmpl_args = {
            'name': '1GB Addicional',
            'type': 'service',
            'categ_id': self.ref('somconnexio.mobile_service')
        }
        product_mobile_oneshot_tmpl = self.env['product.template'].create(
            mobile_oneshot_product_tmpl_args
        )
        self.product_mobile_oneshot = product_mobile_oneshot_tmpl.product_variant_id

        mobile_additional_product_tmpl_args = {
            'name': 'Internacional 100 Min',
            'type': 'service',
            'categ_id': self.ref('somconnexio.mobile_additional_service')
        }
        mobile_additional_product_tmpl = self.env['product.template'].create(
            mobile_additional_product_tmpl_args
        )
        self.product_mobile_additional = (
            mobile_additional_product_tmpl.product_variant_id
        )

        broadband_additional_product_tmpl_args = {
            'name': 'IPv4 Fixa',
            'type': 'service',
            'categ_id': self.ref('somconnexio.broadband_additional_service')
        }
        broadband_additional_product_tmpl = self.env['product.template'].create(
            broadband_additional_product_tmpl_args
        )
        self.product_broadband_additional = (
            broadband_additional_product_tmpl.product_variant_id
        )

        router_4G_tmpl = self.env['product.template'].create({
            'name': 'Router 4G',
            'type': 'service',
            'categ_id': self.ref('somconnexio.broadband_4G_service')
        })
        self.product_router_4G = router_4G_tmpl.product_variant_id

    def test_contract_adsl_wrong_product(self):
        contract_adsl_wrong_product_args = self.contract_adsl_args.copy()
        contract_adsl_wrong_product_args['contract_line_ids'] = [(0, False, {
            "name": "Fiber",
            "product_id": self.product_broadband_fiber.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_adsl_wrong_product_args]
        )

    def test_contract_adsl_wrong_technology(self):
        contract_adsl_wrong_tech_args = self.contract_adsl_args.copy()
        contract_adsl_wrong_tech_args['service_technology_id'] = (
            self.ref("somconnexio.service_technology_fiber")
        )
        contract_adsl_wrong_tech_args['contract_line_ids'] = [(0, False, {
            "name": "ADSL",
            "product_id": self.product_broadband_adsl.id
        }), (0, False, {
            "name": "Alta parell existent a terminis",
            "product_id": self.product_broadband_adsl_oneshot.id
        }), (0, False, {
            "name": "IPv4 Fixa",
            "product_id": self.product_broadband_additional.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_adsl_wrong_tech_args]
        )

    def test_contract_adsl_wrong_supplier(self):
        contract_adsl_wrong_supplier_args = self.contract_adsl_args.copy()
        contract_adsl_wrong_supplier_args['service_supplier_id'] = (
            self.ref("somconnexio.service_supplier_vodafone")
        )
        contract_adsl_wrong_supplier_args['contract_line_ids'] = [(0, False, {
            "name": "ADSL",
            "product_id": self.product_broadband_adsl.id
        }), (0, False, {
            "name": "Alta parell existent a terminis",
            "product_id": self.product_broadband_adsl_oneshot.id
        }), (0, False, {
            "name": "IPv4 Fixa",
            "product_id": self.product_broadband_additional.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_adsl_wrong_supplier_args]
        )

    def test_contract_adsl_allowed_product(self):
        contract_adsl_allowed_product_args = self.contract_adsl_args.copy()
        contract_adsl_allowed_product_args['contract_line_ids'] = [(0, False, {
            "name": "ADSL",
            "product_id": self.product_broadband_adsl.id
        }), (0, False, {
            "name": "Alta parell existent a terminis",
            "product_id": self.product_broadband_adsl_oneshot.id
        }), (0, False, {
            "name": "IPv4 Fixa",
            "product_id": self.product_broadband_additional.id
        })]
        self.assertTrue(
            self.env['contract.contract'].create(contract_adsl_allowed_product_args)
        )

    def test_contract_mobile_wrong_product(self):
        contract_mobile_wrong_product_args = self.contract_mobile_args.copy()
        contract_mobile_wrong_product_args['contract_line_ids'] = [(0, False, {
            "name": "ADSL 20Mb",
            "product_id": self.product_broadband_adsl.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_mobile_wrong_product_args]
        )

    def test_contract_mobile_allowed_product(self):
        contract_mobile_allowed_product_args = self.contract_mobile_args.copy()
        contract_mobile_allowed_product_args['contract_line_ids'] = [(0, False, {
            "name": "Mobile Sense Minuts",
            "product_id": self.product_mobile.id
        }), (0, False, {
            "name": "One Shot Mobile",
            "product_id": self.product_mobile_oneshot.id
        }), (0, False, {
            "name": "Internacional 100 Min",
            "product_id": self.product_mobile_additional.id
        })]
        self.assertTrue(self.env['contract.contract'].create(
            contract_mobile_allowed_product_args
        ))

    def test_contract_mobile_wrong_technology(self):
        contract_mobile_wrong_tech_args = self.contract_mobile_args.copy()
        contract_mobile_wrong_tech_args['service_technology_id'] = (
            self.ref("somconnexio.service_technology_adsl")
        )
        contract_mobile_wrong_tech_args['contract_line_ids'] = [(0, False, {
            "name": "Mobile Sense Minuts",
            "product_id": self.product_mobile.id
        }), (0, False, {
            "name": "One Shot Mobile",
            "product_id": self.product_mobile_oneshot.id
        }), (0, False, {
            "name": "Internacional 100 Min",
            "product_id": self.product_mobile_additional.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_mobile_wrong_tech_args]
        )

    def test_contract_mobile_wrong_supplier(self):
        contract_mobile_wrong_supplier_args = self.contract_mobile_args.copy()
        contract_mobile_wrong_supplier_args['service_supplier_id'] = (
            self.ref("somconnexio.service_supplier_jazztel")
        )
        contract_mobile_wrong_supplier_args['contract_line_ids'] = [(0, False, {
            "name": "Mobile Sense Minuts",
            "product_id": self.product_mobile.id
        }), (0, False, {
            "name": "One Shot Mobile",
            "product_id": self.product_mobile_oneshot.id
        }), (0, False, {
            "name": "Internacional 100 Min",
            "product_id": self.product_mobile_additional.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_mobile_wrong_supplier_args]
        )

    def test_contract_fiber_mm_wrong_tech_product(self):
        contract_fiber_wrong_tech_args = self.contract_fiber_args.copy()
        contract_fiber_wrong_tech_args['service_supplier_id'] = self.ref(
            'somconnexio.service_supplier_jazztel'
        )
        contract_fiber_wrong_tech_args['service_technology_id'] = self.ref(
            'somconnexio.service_technology_adsl'
        )
        contract_fiber_wrong_tech_args['contract_line_ids'] = [(0, False, {
            "name": "Fiber",
            "product_id": self.product_xoln_fiber.id
        }), (0, False, {
            "name": "One Shot Broadband",
            "product_id": self.product_broadband_oneshot.id
        }), (0, False, {
            "name": "IPv4 Fixa",
            "product_id": self.product_broadband_additional.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_fiber_wrong_tech_args]
        )

    def test_contract_fiber_xoln_wrong_tech_product(self):
        contract_fiber_wrong_tech_args = self.contract_fiber_args.copy()
        contract_fiber_wrong_tech_args['service_supplier_id'] = self.ref(
            'somconnexio.service_supplier_xoln'
        )
        contract_fiber_wrong_tech_args['service_technology_id'] = self.ref(
            'somconnexio.service_technology_adsl'
        )
        contract_fiber_wrong_tech_args['contract_line_ids'] = [(0, False, {
            "name": "Fiber",
            "product_id": self.product_broadband_fiber.id
        }), (0, False, {
            "name": "One Shot Broadband",
            "product_id": self.product_broadband_oneshot.id
        }), (0, False, {
            "name": "IPv4 Fixa",
            "product_id": self.product_broadband_additional.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_fiber_wrong_tech_args]
        )

    def test_contract_fiber_mm_allowed_product(self):
        contract_fiber_allowed_product_args = self.contract_fiber_args.copy()
        contract_fiber_allowed_product_args['service_supplier_id'] = self.ref(
            'somconnexio.service_supplier_masmovil'
        )
        contract_fiber_allowed_product_args[
            'mm_fiber_service_contract_info_id'
        ] = self.mm_fiber_contract_service_info.id
        contract_fiber_allowed_product_args['contract_line_ids'] = [(0, False, {
            "name": "Fiber",
            "product_id": self.product_broadband_fiber.id
        }), (0, False, {
            "name": "One Shot Broadband",
            "product_id": self.product_broadband_oneshot.id
        }), (0, False, {
            "name": "IPv4 Fixa",
            "product_id": self.product_broadband_additional.id
        })]
        self.assertTrue(
            self.env['contract.contract'].create(contract_fiber_allowed_product_args)
        )

    def test_contract_fiber_xoln_allowed_product(self):
        contract_fiber_allowed_product_args = self.contract_fiber_args.copy()
        contract_fiber_allowed_product_args['service_supplier_id'] = self.ref(
            'somconnexio.service_supplier_xoln'
        )
        contract_fiber_allowed_product_args[
            'xoln_fiber_service_contract_info_id'
        ] = self.xoln_fiber_contract_service_info.id
        contract_fiber_allowed_product_args['contract_line_ids'] = [(0, False, {
            "name": "Fiber",
            "product_id": self.product_xoln_fiber.id
        }), (0, False, {
            "name": "One Shot Broadband",
            "product_id": self.product_broadband_oneshot.id
        }), (0, False, {
            "name": "IPv4 Fixa",
            "product_id": self.product_broadband_additional.id
        })]
        self.assertTrue(
            self.env['contract.contract'].create(contract_fiber_allowed_product_args)
        )

    def test_contract_fiber_mm_wrong_product(self):
        contract_fiber_wrong_product_args = self.contract_fiber_args.copy()
        contract_fiber_wrong_product_args['service_supplier_id'] = self.ref(
            'somconnexio.service_supplier_masmovil'
        )
        contract_fiber_wrong_product_args['contract_line_ids'] = [(0, False, {
            "name": "ADSL 20Mb",
            "product_id": self.product_broadband_adsl.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_fiber_wrong_product_args]
        )

    def test_contract_fiber_xoln_wrong_product(self):
        contract_fiber_wrong_product_args = self.contract_fiber_xoln_args.copy()
        contract_fiber_wrong_product_args['service_supplier_id'] = self.ref(
            'somconnexio.service_supplier_xoln'
        )
        contract_fiber_wrong_product_args['contract_line_ids'] = [(0, False, {
            "name": "ADSL 20Mb",
            "product_id": self.product_broadband_adsl.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_fiber_wrong_product_args]
        )

    def test_contract_fiber_vodafone_wrong_tech_product(self):
        contract_fiber_wrong_tech_args = self.contract_fiber_args.copy()
        contract_fiber_wrong_tech_args['service_technology_id'] = self.ref(
            'somconnexio.service_technology_adsl'
        )
        contract_fiber_wrong_tech_args['service_supplier_id'] = self.ref(
            'somconnexio.service_supplier_vodafone'
        )
        contract_fiber_wrong_tech_args['contract_line_ids'] = [(0, False, {
            "name": "Fiber",
            "product_id": self.product_broadband_fiber.id
        }), (0, False, {
            "name": "One Shot Broadband",
            "product_id": self.product_broadband_oneshot.id
        }), (0, False, {
            "name": "IPv4 Fixa",
            "product_id": self.product_broadband_additional.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_fiber_wrong_tech_args]
        )

    def test_contract_fiber_wrong_supplier(self):
        contract_fiber_wrong_supplier_args = self.contract_fiber_args.copy()
        contract_fiber_wrong_supplier_args['service_supplier_id'] = self.ref(
            'somconnexio.service_supplier_masmovil'
        )
        contract_fiber_wrong_supplier_args['contract_line_ids'] = [(0, False, {
            "name": "Fiber",
            "product_id": self.product_broadband_fiber.id
        }), (0, False, {
            "name": "One Shot Broadband",
            "product_id": self.product_broadband_oneshot.id
        }), (0, False, {
            "name": "IPv4 Fixa",
            "product_id": self.product_broadband_additional.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_fiber_wrong_supplier_args]
        )

    def test_contract_fiber_vodafone_allowed_product(self):
        contract_fiber_allowed_product_args = self.contract_fiber_args.copy()
        contract_fiber_allowed_product_args['service_supplier_id'] = self.ref(
            'somconnexio.service_supplier_vodafone'
        )
        contract_fiber_allowed_product_args['contract_line_ids'] = [(0, False, {
            "name": "Fiber",
            "product_id": self.product_broadband_fiber.id
        }), (0, False, {
            "name": "One Shot Broadband",
            "product_id": self.product_broadband_oneshot.id
        }), (0, False, {
            "name": "IPv4 Fixa",
            "product_id": self.product_broadband_additional.id
        })]
        self.assertTrue(
            self.env['contract.contract'].create(contract_fiber_allowed_product_args)
        )

    def test_contract_fiber_vodafone_wrong_product(self):
        contract_fiber_wrong_product_args = self.contract_fiber_args.copy()
        contract_fiber_wrong_product_args['service_supplier_id'] = self.ref(
            'somconnexio.service_supplier_vodafone'
        )
        contract_fiber_wrong_product_args['contract_line_ids'] = [(0, False, {
            "name": "ADSL 20Mb",
            "product_id": self.product_broadband_adsl.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_fiber_wrong_product_args]
        )

    def test_contract_router_4G_allowed_product(self):
        contract_router_4G_allowed_product_args = self.contract_router_4G_args.copy()
        contract_router_4G_allowed_product_args.update({
            'service_supplier_id': self.ref('somconnexio.service_supplier_vodafone'),
            'contract_line_ids': [(0, False, {
                "name": "Router4G",
                "product_id": self.product_router_4G.id,
                }
            )]
        })
        self.assertTrue(
            self.env['contract.contract'].create(
                contract_router_4G_allowed_product_args)
        )

    def test_contract_router_4G_wrong_product(self):
        contract_router_4G_allowed_product_args = self.contract_router_4G_args.copy()
        contract_router_4G_allowed_product_args.update({
            'service_supplier_id': self.ref('somconnexio.service_supplier_masmovil'),
            'contract_line_ids': [(0, False, {
                "name": "Router4G",
                "product_id": self.product_router_4G.id,
                }
            )]
        })
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_router_4G_allowed_product_args]
        )

    def test_contract_fiber_orange_allowed_product(self):
        contract_fiber_allowed_product_args = self.contract_fiber_orange_args.copy()
        contract_fiber_allowed_product_args['contract_line_ids'] = [(0, False, {
            "name": "Fiber",
            "product_id": self.product_wo_fix_fiber.id
        }), (0, False, {
            "name": "One Shot Broadband",
            "product_id": self.product_broadband_oneshot.id
        }), (0, False, {
            "name": "IPv4 Fixa",
            "product_id": self.product_broadband_additional.id
        })]
        self.assertTrue(
            self.env['contract.contract'].create(contract_fiber_allowed_product_args)
        )

    def test_contract_fiber_orange_wrong_product(self):
        contract_fiber_wrong_product_args = self.contract_fiber_orange_args.copy()
        contract_fiber_wrong_product_args['contract_line_ids'] = [(0, False, {
            "name": "ADSL 20Mb",
            "product_id": self.product_broadband_adsl.id
        })]
        self.assertRaises(
            ValidationError,
            self.env['contract.contract'].create,
            [contract_fiber_wrong_product_args]
        )

    def test_contract_router_4G_with_fix_ip(self):
        contract_router_4G_allowed_product_args = self.contract_router_4G_args.copy()
        contract_router_4G_allowed_product_args.update({
            'service_supplier_id': self.ref('somconnexio.service_supplier_vodafone'),
            'contract_line_ids': [(0, False, {
                "name": "Router4G",
                "product_id": self.product_router_4G.id,
            }), (0, False, {
                "name": "IPv4 fixa",
                "product_id": self.product_broadband_additional.id,
            })]
        })
        self.assertTrue(
            self.env['contract.contract'].create(
                contract_router_4G_allowed_product_args)
        )
