"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedshiftData = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [redshift-data](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshiftdataapi.html).
 *
 * @experimental
 */
class RedshiftData extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [redshift-data](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshiftdataapi.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'redshift-data';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "CancelStatement",
                "ExecuteStatement"
            ],
            "Read": [
                "DescribeStatement",
                "DescribeTable",
                "GetStatementResult",
                "ListDatabases",
                "ListSchemas"
            ],
            "List": [
                "ListStatements",
                "ListTables"
            ]
        };
    }
    /**
     * (experimental) Grants permission to cancel a running query.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStatementOwnerIamUserid()
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_CancelStatement.html
     *
     * @experimental
     */
    toCancelStatement() {
        return this.to('CancelStatement');
    }
    /**
     * (experimental) Grants permission to retrieve detailed information about a statement execution.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifStatementOwnerIamUserid()
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_DescribeStatement.html
     *
     * @experimental
     */
    toDescribeStatement() {
        return this.to('DescribeStatement');
    }
    /**
     * (experimental) Grants permission to retrieve metadata about a particular table.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_DescribeTable.html
     *
     * @experimental
     */
    toDescribeTable() {
        return this.to('DescribeTable');
    }
    /**
     * (experimental) Grants permission to execute a query.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ExecuteStatement.html
     *
     * @experimental
     */
    toExecuteStatement() {
        return this.to('ExecuteStatement');
    }
    /**
     * (experimental) Grants permission to fetch the result of a query.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifStatementOwnerIamUserid()
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_GetStatementResult.html
     *
     * @experimental
     */
    toGetStatementResult() {
        return this.to('GetStatementResult');
    }
    /**
     * (experimental) Grants permission to list databases for a given cluster.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListDatabases.html
     *
     * @experimental
     */
    toListDatabases() {
        return this.to('ListDatabases');
    }
    /**
     * (experimental) Grants permission to list schemas for a given cluster.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListSchemas.html
     *
     * @experimental
     */
    toListSchemas() {
        return this.to('ListSchemas');
    }
    /**
     * (experimental) Grants permission to list queries for a given principal.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifStatementOwnerIamUserid()
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListStatements.html
     *
     * @experimental
     */
    toListStatements() {
        return this.to('ListStatements');
    }
    /**
     * (experimental) Grants permission to list tables for a given cluster.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListTables.html
     *
     * @experimental
     */
    toListTables() {
        return this.to('ListTables');
    }
    /**
     * (experimental) Filters access by statement owner iam userid.
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-policy-resources.conditions
     *
     * Applies to actions:
     * - .toCancelStatement()
     * - .toDescribeStatement()
     * - .toGetStatementResult()
     * - .toListStatements()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifStatementOwnerIamUserid(value, operator) {
        return this.if(`statement-owner-iam-userid`, value, operator || 'StringLike');
    }
}
exports.RedshiftData = RedshiftData;
_a = JSII_RTTI_SYMBOL_1;
RedshiftData[_a] = { fqn: "cdk-iam-floyd.RedshiftData", version: "0.145.0" };
//# sourceMappingURL=data:application/json;base64,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