import { Test } from 'nodeunit';
declare const _default: {
    'default bucket'(test: Test): void;
    'CFN properties are type-validated during resolution'(test: Test): void;
    'bucket without encryption'(test: Test): void;
    'bucket with managed encryption'(test: Test): void;
    'valid bucket names'(test: Test): void;
    'bucket validation skips tokenized values'(test: Test): void;
    'fails with message on invalid bucket names'(test: Test): void;
    'fails if bucket name has less than 3 or more than 63 characters'(test: Test): void;
    'fails if bucket name has invalid characters'(test: Test): void;
    'fails if bucket name does not start or end with lowercase character or number'(test: Test): void;
    'fails only if bucket name has the consecutive symbols (..), (.-), (-.)'(test: Test): void;
    'fails only if bucket name resembles IP address'(test: Test): void;
    'fails if encryption key is used with managed encryption'(test: Test): void;
    'fails if encryption key is used with encryption set to unencrypted'(test: Test): void;
    'encryptionKey can specify kms key'(test: Test): void;
    'bucket with versioning turned on'(test: Test): void;
    'bucket with block public access set to BlockAll'(test: Test): void;
    'bucket with block public access set to BlockAcls'(test: Test): void;
    'bucket with custom block public access setting'(test: Test): void;
    'bucket with custom canned access control'(test: Test): void;
    'permissions': {
        'addPermission creates a bucket policy'(test: Test): void;
        'forBucket returns a permission statement associated with the bucket\'s ARN'(test: Test): void;
        'arnForObjects returns a permission statement associated with objects in the bucket'(test: Test): void;
        'arnForObjects accepts multiple arguments and FnConcats them'(test: Test): void;
    };
    'removal policy can be used to specify behavior upon delete'(test: Test): void;
    'import/export': {
        'static import(ref) allows importing an external/existing bucket'(test: Test): void;
        'import can also be used to import arbitrary ARNs'(test: Test): void;
    };
    'grantRead'(test: Test): void;
    'grantReadWrite': {
        'can be used to grant reciprocal permissions to an identity'(test: Test): void;
        'grant permissions to non-identity principal'(test: Test): void;
        'if an encryption key is included, encrypt/decrypt permissions are also added both ways'(test: Test): void;
    };
    'more grants'(test: Test): void;
    'cross-stack permissions': {
        'in the same account and region'(test: Test): void;
        'in different accounts'(test: Test): void;
        'in different accounts, with a KMS Key'(test: Test): void;
    };
    'urlForObject returns a token with the S3 URL of the token'(test: Test): void;
    'grantPublicAccess': {
        'by default, grants s3:GetObject to all objects'(test: Test): void;
        '"keyPrefix" can be used to only grant access to certain objects'(test: Test): void;
        '"allowedActions" can be used to specify actions explicitly'(test: Test): void;
        'returns the PolicyStatement which can be then customized'(test: Test): void;
        'throws when blockPublicPolicy is set to true'(test: Test): void;
    };
    'website configuration': {
        'only index doc'(test: Test): void;
        'fails if only error doc is specified'(test: Test): void;
        'error and index docs'(test: Test): void;
        'exports the WebsiteURL'(test: Test): void;
        'adds RedirectAllRequestsTo property'(test: Test): void;
        'fails if websiteRedirect and websiteIndex and websiteError are specified'(test: Test): void;
        'fails if websiteRedirect and websiteRoutingRules are specified'(test: Test): void;
        'adds RedirectRules property'(test: Test): void;
        'fails if routingRule condition object is empty'(test: Test): void;
    };
    'Bucket.fromBucketArn'(test: Test): void;
    'Bucket.fromBucketName'(test: Test): void;
    'if a kms key is specified, it implies bucket is encrypted with kms (dah)'(test: Test): void;
};
export = _default;
