from hazelcast.serialization.bits import *
from hazelcast.protocol.client_message import ClientMessage
from hazelcast.protocol.codec.transaction_message_type import *

REQUEST_TYPE = TRANSACTION_COMMIT
RESPONSE_TYPE = 100
RETRYABLE = False


def calculate_size(transaction_id, thread_id):
    """ Calculates the request payload size"""
    data_size = 0
    data_size += calculate_size_str(transaction_id)
    data_size += LONG_SIZE_IN_BYTES
    return data_size


def encode_request(transaction_id, thread_id):
    """ Encode request into client_message"""
    client_message = ClientMessage(payload_size=calculate_size(transaction_id, thread_id))
    client_message.set_message_type(REQUEST_TYPE)
    client_message.set_retryable(RETRYABLE)
    client_message.append_str(transaction_id)
    client_message.append_long(thread_id)
    client_message.update_frame_length()
    return client_message


# Empty decode_response(client_message), this message has no parameters to decode
