# HEADER:
# - Module Name: sets.py
# - Written by: Isaac N. Erb.
# - Created: 2023-??-??.
# - Last Edited*: 2023-Oct-14.
#
#       * (Read: "Last time the author bothered to update this.") 

# PURPOSE: 
# - This module contains a set of lists of unicode character-
#   positions, to be called upon by Python-scripts for FontForge.

# All positions of ASCII-subscripts, including those custom.
all_ascii_inferiors = [
    7522,
    7523,
    7524,
    7525,
    8320, 
    8321, 
    8322, 
    8323, 
    8324, 
    8325, 
    8326, 
    8327, 
    8328, 
    8329, 
    8330, 
    8331, 
    8332, 
    8333, 
    8334,
    8336, 
    8337, 
    8338, 
    8339, 
    8341, 
    8342, 
    8343, 
    8344, 
    8345, 
    8346, 
    8347, 
    8348,
    57345,
    57346,
    57348,
    57350,
    57352,
    57354,
    57356,
    57358,
    57360,
    57362,
    57364,
    57366,
    57368,
    57370,
    57372,
    57374,
    57376,
    57378,
    57379,
    57380,
    57382,
    57383,
    57384,
    57386,
    57387,
    57388,
    57389,
    57390,
    57391,
    57392,
    57393,
    57394,
    57395,
    57396,
    57398,
    57399,
    57401,
    57402,
    57403,
    57404,
    57405,
    57407,
    57409,
    57411,
    57413,
    57415,
    57417,
    57419,
    57421,
    57423,
    57424,
    57425,
    57426,
    57427,
    57428,
    57430,
    57431,
    57432,
    57433,
    57435,
    57437,
    57439,
    57441]

# Only the subscripts present in unicode.
unicode_ascii_inferiors = [
    7522,
    7523,
    7524,
    7525,
    8320,
    8321,
    8322,
    8323,
    8324,
    8325,
    8326,
    8327,
    8328,
    8329,
    8330,
    8331,
    8332,
    8333,
    8334,
    8336,
    8337,
    8338,
    8339,
    8341,
    8342,
    8343,
    8344,
    8345,
    8346,
    8347,
    8348]

# All positions of ascii-superscripts, including custom ones.
all_ascii_superscripts = [
    178,
    179,
    185,
    688,
    690,
    691,
    695,
    696,
    737,
    738,
    739,
    7468,
    7470,
    7472,
    7473,
    7475,
    7476,
    7477,
    7478,
    7479,
    7480,
    7481,
    7482,
    7484,
    7486,
    7487,
    7488,
    7489, 
    7490, 
    7491,
    7495, 
    7496, 
    7497,
    7501,
    7503,
    7504,
    7506,
    7510, 
    7511, 
    7512,
    7515,
    7580,
    7584,
    7611,
    8304,
    8305,
    8308, 
    8309, 
    8310, 
    8311, 
    8312, 
    8313, 
    8314, 
    8315, 
    8316, 
    8317, 
    8318, 
    8319,
    11389,
    42781,
    57344, 
    57347, 
    57349, 
    57351, 
    57353, 
    57355, 
    57357, 
    57359, 
    57361, 
    57363, 
    57365, 
    57367, 
    57369, 
    57371, 
    57373, 
    57375, 
    57377, 
    57381, 
    57385, 
    57397, 
    57400, 
    57406, 
    57408, 
    57410, 
    57412, 
    57414, 
    57416, 
    57418, 
    57420, 
    57422, 
    57429, 
    57434, 
    57436, 
    57438, 
    57440]

# Superscripts of ASCII appearing in unicode.
unicode_ascii_superscripts = [
    178,
    179,
    185,
    688,
    690,
    691,
    695,
    696,
    737,
    738,
    739,
    7468,
    7470,
    7472,
    7473,
    7475,
    7476,
    7477,
    7478,
    7479,
    7480,
    7481,
    7482,
    7484,
    7486,
    7487,
    7488,
    7489,
    7490,
    7491,
    7495,
    7496,
    7497,
    7501,
    7503,
    7504,
    7506,
    7510,
    7511,
    7512,
    7515,
    7580,
    7584,
    7611,
    8304,
    8305,
    8308,
    8309,
    8310,
    8311,
    8312,
    8313,
    8314,
    8315,
    8316,
    8317,
    8318,
    8319,
    11389,
    42781]


# My custom subscript-positions.
privuse_inferiors = [
    57345,
    57346,
    57348,
    57350,
    57352,
    57354,
    57356,
    57358,
    57360,
    57362,
    57364,
    57366,
    57368,
    57370,
    57372,
    57374,
    57376,
    57378,
    57379,
    57380,
    57382,
    57383,
    57384,
    57386,
    57387,
    57388,
    57389,
    57390,
    57391,
    57392,
    57393,
    57394,
    57395,
    57396,
    57398,
    57399,
    57401,
    57402,
    57403,
    57404,
    57405,
    57407,
    57409,
    57411,
    57413,
    57415,
    57417,
    57419,
    57421,
    57423,
    57424,
    57425,
    57426,
    57427,
    57428,
    57430,
    57431,
    57432,
    57433,
    57435,
    57437,
    57439,
    57441]

# My custom superscript-positons.
privuse_superscripts = [
    57344, 
    57347, 
    57349, 
    57351, 
    57353, 
    57355, 
    57357, 
    57359, 
    57361, 
    57363, 
    57365, 
    57367, 
    57369, 
    57371, 
    57373, 
    57375, 
    57377, 
    57381, 
    57385, 
    57397, 
    57400, 
    57406, 
    57408, 
    57410, 
    57412, 
    57414, 
    57416, 
    57418, 
    57420, 
    57422, 
    57429, 
    57434, 
    57436, 
    57438, 
    57440]

# All zero-width characters I know/care about.
all_known_zeroWidths = [
    768,
    769,
    770,
    771,
    772,
    773,
    774,
    775,
    776,
    777,
    778,
    779,
    780,
    781,
    782,
    783,
    784,
    785,
    786,
    787,
    788,
    789,
    790,
    791,
    792,
    793,
    794,
    795,
    796,
    797,
    798,
    799,
    800,
    801,
    802,
    803,
    804,
    805,
    806,
    807,
    808,
    809,
    810,
    811,
    812,
    813,
    814,
    815,
    816,
    817,
    818,
    819,
    820,
    821,
    822,
    823,
    824,
    825,
    826,
    827,
    828,
    829,
    830,
    831,
    832,
    833,
    834,
    835,
    836,
    837,
    838,
    839,
    840,
    841,
    842,
    843,
    844,
    845,
    846,
    847,
    848,
    849,
    850,
    851,
    852,
    853,
    854,
    855,
    856,
    857,
    858,
    859,
    860,
    861,
    862,
    863,
    864,
    865,
    866,
    867,
    868,
    869,
    870,
    871,
    872,
    873,
    874,
    875,
    876,
    877,
    878,
    879,
    1155,
    1156,
    1157,
    1158,
    1159,
    1160,
    1161,
    1425,
    1426,
    1427,
    1428,
    1429,
    1430,
    1431,
    1432,
    1433,
    1434,
    1435,
    1436,
    1437,
    1438,
    1439,
    1440,
    1441,
    1442,
    1443,
    1444,
    1445,
    1446,
    1447,
    1448,
    1449,
    1450,
    1451,
    1452,
    1453,
    1454,
    1455,
    1456,
    1457,
    1458,
    1459,
    1460,
    1461,
    1462,
    1463,
    1464,
    1465,
    1466,
    1467,
    1468,
    1469,
    1471,
    1473,
    1474,
    1476,
    1477,
    1479,
    7616,
    7617,
    7618,
    7619,
    7620,
    7621,
    7622,
    7623,
    7624,
    7625,
    7626,
    7627,
    7628,
    7629,
    7630,
    7631,
    7632,
    7633,
    7634,
    7635,
    7636,
    7637,
    7638,
    7639,
    7640,
    7641,
    7642,
    7643,
    7644,
    7645,
    7646,
    7647,
    7648,
    7649,
    7650,
    7651,
    7652,
    7653,
    7654,
    7655,
    7656,
    7657,
    7658,
    7659,
    7660,
    7661,
    7662,
    7663,
    7664,
    7665,
    7666,
    7667,
    7668,
    7669,
    7670,
    7671,
    7672,
    7673,
    7674,
    7675,
    7676,
    7677,
    7678,
    7679,
    8203,
    8204,
    8205,
    8400,
    8401,
    8402,
    8403,
    8404,
    8405,
    8406,
    8407,
    8408,
    8409,
    8410,
    8411,
    8412,
    8413,
    8414,
    8415,
    8416,
    8417,
    8418,
    8419,
    8420,
    8421,
    8422,
    8423,
    8424,
    8425,
    8426,
    8427,
    8428,
    8429,
    8430,
    8431,
    8432,
    8433,
    8434,
    8435,
    8436,
    8437,
    8438,
    8439,
    8440,
    8441,
    8442,
    8443,
    8444,
    8445,
    8446,
    8447,
    11744,
    11745,
    11746,
    11747,
    11748,
    11749,
    11750,
    11751,
    11752,
    11753,
    11754,
    11755,
    11756,
    11757,
    11758,
    11759,
    11760,
    11761,
    11762,
    11763,
    11764,
    11765,
    11766,
    11767,
    11768,
    11769,
    11770,
    11771,
    11772,
    11773,
    11774,
    11775,
    61424,
    61425,
    61426,
    61427,
    61428,
    61429,
    61430,
    61431,
    61432,
    61433,
    61434,
    61435,
    61436,
    61437,
    61438,
    61439]