#pragma once

// @generated by aten/src/ATen/gen.py

#include "ATen/Type.h"
#include "ATen/Context.h"
#include "ATen/TensorMethods.h"
#include "ATen/CheckGenerator.h"

#ifdef _MSC_VER
#ifdef Type
#undef Type
#endif
#endif

namespace at {

struct CUDAFloatType final : public Type {
  explicit CUDAFloatType(Context* context);
  virtual ScalarType scalarType() const override;
  virtual Backend backend() const override;
  virtual bool is_cuda() const override;
  virtual bool is_sparse() const override;
  virtual bool is_distributed() const override;
  virtual std::unique_ptr<Storage> storage() const override;
  virtual std::unique_ptr<Storage> storage(size_t size) const override;
  virtual std::unique_ptr<Storage> storageFromBlob(void * data, int64_t size, const std::function<void(void*)> & deleter) const override;
  virtual std::unique_ptr<Storage> storageWithAllocator(int64_t size, Allocator* allocator) const override;
  virtual std::unique_ptr<Generator> generator() const override;
  virtual const char * toString() const override;
  virtual size_t elementSizeInBytes() const override;
  virtual TypeID ID() const override;
  static const char * typeString();
  virtual std::unique_ptr<Storage> unsafeStorageFromTH(void * th_pointer, bool retain) const override;
  virtual Tensor unsafeTensorFromTH(void * th_pointer, bool retain) const override;

  // example
  // virtual Tensor * add(Tensor & a, Tensor & b) override;

  virtual Tensor & s_copy_(Tensor & self, const Tensor & src, bool non_blocking) const override;
  virtual Tensor & _s_copy_from(const Tensor & self, Tensor & dst, bool non_blocking) const override;
  virtual int64_t storage_offset(const Tensor & self) const override;
  virtual Tensor & resize_(Tensor & self, IntList size) const override;
  virtual Tensor & set_(Tensor & self, Storage & source) const override;
  virtual Tensor & set_(Tensor & self, Storage & source, int64_t storage_offset, IntList size, IntList stride) const override;
  virtual Tensor & set_(Tensor & self, const Tensor & source) const override;
  virtual Tensor & set_(Tensor & self) const override;
  virtual Tensor & _fill_(Tensor & self, Scalar value) const override;
  virtual Tensor & _fill_(Tensor & self, const Tensor & value) const override;
  virtual bool is_contiguous(const Tensor & self) const override;
  virtual bool is_set_to(const Tensor & self, const Tensor & tensor) const override;
  virtual Tensor & s_masked_fill_(Tensor & self, const Tensor & mask, Scalar value) const override;
  virtual Tensor & s_masked_fill_(Tensor & self, const Tensor & mask, const Tensor & value) const override;
  virtual Tensor & s_masked_scatter_(Tensor & self, const Tensor & mask, const Tensor & source) const override;
  virtual Tensor & s_masked_select_out(Tensor & result, const Tensor & self, const Tensor & mask) const override;
  virtual Tensor s_masked_select(const Tensor & self, const Tensor & mask) const override;
  virtual Tensor & nonzero_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor nonzero(const Tensor & self) const override;
  virtual Tensor contiguous(const Tensor & self) const override;
  virtual Tensor th_clone(const Tensor & self) const override;
  virtual Tensor view(const Tensor & self, IntList size) const override;
  virtual Tensor & th_resize_as_(Tensor & self, const Tensor & the_template) const override;
  virtual Tensor & index_select_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const override;
  virtual Tensor index_select(const Tensor & self, int64_t dim, const Tensor & index) const override;
  virtual Tensor & _indexCopy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  virtual Tensor & take_out(Tensor & result, const Tensor & self, const Tensor & index) const override;
  virtual Tensor take(const Tensor & self, const Tensor & index) const override;
  virtual Tensor & put_(Tensor & self, const Tensor & index, const Tensor & source, bool accumulate) const override;
  virtual Tensor & index_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  virtual Tensor & index_fill_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  virtual Tensor & index_fill_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & value) const override;
  virtual Tensor unfold(const Tensor & self, int64_t dimension, int64_t size, int64_t step) const override;
  virtual Tensor & _range_out(Tensor & result, Scalar start, Scalar end, Scalar step) const override;
  virtual Tensor _range(Scalar start, Scalar end, Scalar step) const override;
  virtual Tensor & _arange_out(Tensor & result, Scalar start, Scalar end, Scalar step) const override;
  virtual Tensor _arange(Scalar start, Scalar end, Scalar step) const override;
  virtual Tensor & _arange_out(Tensor & result, Scalar end) const override;
  virtual Tensor _arange(Scalar end) const override;
  virtual Tensor & scatter_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  virtual Tensor & scatter_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  virtual Tensor & scatter_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  virtual Tensor & gather_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const override;
  virtual Tensor gather(const Tensor & self, int64_t dim, const Tensor & index) const override;
  virtual void* data_ptr(const Tensor & self) const override;
  virtual bool equal(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __and___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __and__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___and___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___and__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __iand__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___iand__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & __or___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __or__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___or___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___or__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __ior__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___ior__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & __xor___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __xor__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___xor___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___xor__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __ixor__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___ixor__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & __lshift___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __lshift__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___lshift___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___lshift__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __ilshift__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___ilshift__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & __rshift___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __rshift__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___rshift___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___rshift__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __irshift__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___irshift__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & lt_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor lt(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_lt_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_lt(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & lt_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_lt_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & gt_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor gt(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_gt_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_gt(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & gt_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_gt_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & le_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor le(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_le_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_le(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & le_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_le_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & ge_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor ge(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_ge_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_ge(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & ge_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_ge_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & eq_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor eq(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_eq_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_eq(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & eq_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_eq_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & ne_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor ne(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_ne_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_ne(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & ne_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_ne_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & s_min_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_min(const Tensor & self, const Tensor & other) const override;
  virtual Tensor min(const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> _th_min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> _th_min(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor & s_max_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_max(const Tensor & self, const Tensor & other) const override;
  virtual Tensor max(const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> _th_max_out(Tensor & max, Tensor & max_indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> _th_max(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor &,Tensor &> _th_mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> _th_mode(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor median(const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> _th_median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> _th_median(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool descending) const override;
  virtual std::tuple<Tensor,Tensor> sort(const Tensor & self, int64_t dim, bool descending) const override;
  virtual std::tuple<Tensor &,Tensor &> topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const override;
  virtual std::tuple<Tensor,Tensor> topk(const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const override;
  virtual int64_t _th_get_device(const Tensor & self) const override;
  virtual Tensor & _abs_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _abs(const Tensor & self) const override;
  virtual Tensor & sigmoid_(Tensor & self) const override;
  virtual Tensor & sigmoid_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor sigmoid(const Tensor & self) const override;
  virtual Tensor & _log_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _log(const Tensor & self) const override;
  virtual Tensor & _log10_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _log10(const Tensor & self) const override;
  virtual Tensor & _log1p_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _log1p(const Tensor & self) const override;
  virtual Tensor & _log2_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _log2(const Tensor & self) const override;
  virtual Tensor & lgamma_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor lgamma(const Tensor & self) const override;
  virtual Tensor & lgamma_(Tensor & self) const override;
  virtual Tensor & digamma_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor digamma(const Tensor & self) const override;
  virtual Tensor & digamma_(Tensor & self) const override;
  virtual Tensor & polygamma_out(Tensor & result, int64_t n, const Tensor & self) const override;
  virtual Tensor polygamma(int64_t n, const Tensor & self) const override;
  virtual Tensor & polygamma_(Tensor & self, int64_t n) const override;
  virtual Tensor & _exp_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _exp(const Tensor & self) const override;
  virtual Tensor & _expm1_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _expm1(const Tensor & self) const override;
  virtual Tensor & _cos_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _cos(const Tensor & self) const override;
  virtual Tensor & _acos_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _acos(const Tensor & self) const override;
  virtual Tensor & _cosh_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _cosh(const Tensor & self) const override;
  virtual Tensor & _sin_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _sin(const Tensor & self) const override;
  virtual Tensor & _asin_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _asin(const Tensor & self) const override;
  virtual Tensor & _sinh_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _sinh(const Tensor & self) const override;
  virtual Tensor & _tan_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _tan(const Tensor & self) const override;
  virtual Tensor & _atan_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _atan(const Tensor & self) const override;
  virtual Tensor & _th_tanh_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _th_tanh(const Tensor & self) const override;
  virtual Tensor & _erf_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _erf(const Tensor & self) const override;
  virtual Tensor & erfinv_(Tensor & self) const override;
  virtual Tensor & erfinv_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor erfinv(const Tensor & self) const override;
  virtual Tensor & _sqrt_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _sqrt(const Tensor & self) const override;
  virtual Tensor & _rsqrt_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _rsqrt(const Tensor & self) const override;
  virtual Tensor & _ceil_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _ceil(const Tensor & self) const override;
  virtual Tensor & _floor_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _floor(const Tensor & self) const override;
  virtual Tensor & _round_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _round(const Tensor & self) const override;
  virtual Tensor & _trunc_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _trunc(const Tensor & self) const override;
  virtual Tensor & frac_(Tensor & self) const override;
  virtual Tensor & frac_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor frac(const Tensor & self) const override;
  virtual Tensor var(const Tensor & self, bool unbiased) const override;
  virtual Tensor & _th_var_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  virtual Tensor _th_var(const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  virtual Tensor std(const Tensor & self, bool unbiased) const override;
  virtual Tensor & _th_std_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  virtual Tensor _th_std(const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  virtual Tensor th_norm(const Tensor & self, Scalar p) const override;
  virtual Tensor & _th_norm_out(Tensor & result, const Tensor & self, Scalar p, int64_t dim, bool keepdim) const override;
  virtual Tensor _th_norm(const Tensor & self, Scalar p, int64_t dim, bool keepdim) const override;
  virtual Tensor & renorm_out(Tensor & result, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  virtual Tensor renorm(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  virtual Tensor & renorm_(Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  virtual Tensor s_dist(const Tensor & self, const Tensor & other, Scalar p) const override;
  virtual Tensor & reciprocal_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor reciprocal(const Tensor & self) const override;
  virtual Tensor & reciprocal_(Tensor & self) const override;
  virtual Tensor & neg_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor neg(const Tensor & self) const override;
  virtual Tensor & neg_(Tensor & self) const override;
  virtual Tensor & s_atan2_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_atan2(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & s_atan2_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & th_pow_out(Tensor & result, const Tensor & self, Scalar exponent) const override;
  virtual Tensor th_pow(const Tensor & self, Scalar exponent) const override;
  virtual Tensor & s_pow_out(Tensor & result, const Tensor & self, const Tensor & exponent) const override;
  virtual Tensor s_pow(const Tensor & self, const Tensor & exponent) const override;
  virtual Tensor & pow_out(Tensor & result, Scalar base, const Tensor & self) const override;
  virtual Tensor pow(Scalar base, const Tensor & self) const override;
  virtual Tensor & pow_(Tensor & self, Scalar exponent) const override;
  virtual Tensor & s_pow_(Tensor & self, const Tensor & exponent) const override;
  virtual Tensor & s_lerp_out(Tensor & result, const Tensor & self, const Tensor & end, Scalar weight) const override;
  virtual Tensor s_lerp(const Tensor & self, const Tensor & end, Scalar weight) const override;
  virtual Tensor & s_lerp_(Tensor & self, const Tensor & end, Scalar weight) const override;
  virtual Tensor & _linspace_out(Tensor & result, Scalar start, Scalar end, int64_t steps) const override;
  virtual Tensor _linspace(Scalar start, Scalar end, int64_t steps) const override;
  virtual Tensor & _logspace_out(Tensor & result, Scalar start, Scalar end, int64_t steps) const override;
  virtual Tensor _logspace(Scalar start, Scalar end, int64_t steps) const override;
  virtual Tensor & th_zero_(Tensor & self) const override;
  virtual Tensor _sumall(const Tensor & self) const override;
  virtual Tensor & _th_sum_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor _th_sum(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor _prodall(const Tensor & self) const override;
  virtual Tensor & _th_prod_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor _th_prod(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor & _cumsum_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  virtual Tensor _cumsum(const Tensor & self, int64_t dim) const override;
  virtual Tensor & _cumprod_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  virtual Tensor _cumprod(const Tensor & self, int64_t dim) const override;
  virtual Tensor & sign_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor sign(const Tensor & self) const override;
  virtual Tensor & sign_(Tensor & self) const override;
  virtual Tensor trace(const Tensor & self) const override;
  virtual Tensor & s_th_add_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor s_th_add(const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & add_out(Tensor & result, const Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor add(const Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor & s_th_add_(Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & add_(Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor & s_th_sub_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor s_th_sub(const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & sub_out(Tensor & result, const Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor sub(const Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor & s_th_sub_(Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & sub_(Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor & th_mul_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor th_mul(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_th_mul_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_th_mul(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & th_mul_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_th_mul_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & th_div_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor th_div(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_div_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_div(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & th_div_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_div_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & fmod_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor fmod(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_fmod_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_fmod(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & fmod_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_fmod_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & remainder_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor remainder(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_remainder_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_remainder(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & remainder_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_remainder_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & clamp_out(Tensor & result, const Tensor & self, Scalar min, Scalar max) const override;
  virtual Tensor clamp(const Tensor & self, Scalar min, Scalar max) const override;
  virtual Tensor & clamp_(Tensor & self, Scalar min, Scalar max) const override;
  virtual Tensor & clamp_min_out(Tensor & result, const Tensor & self, Scalar min) const override;
  virtual Tensor clamp_min(const Tensor & self, Scalar min) const override;
  virtual Tensor & clamp_min_(Tensor & self, Scalar min) const override;
  virtual Tensor & clamp_max_out(Tensor & result, const Tensor & self, Scalar max) const override;
  virtual Tensor clamp_max(const Tensor & self, Scalar max) const override;
  virtual Tensor & clamp_max_(Tensor & self, Scalar max) const override;
  virtual Tensor _dot(const Tensor & self, const Tensor & tensor) const override;
  virtual Tensor & tril_out(Tensor & result, const Tensor & self, int64_t diagonal) const override;
  virtual Tensor tril(const Tensor & self, int64_t diagonal) const override;
  virtual Tensor & tril_(Tensor & self, int64_t diagonal) const override;
  virtual Tensor & triu_out(Tensor & result, const Tensor & self, int64_t diagonal) const override;
  virtual Tensor triu(const Tensor & self, int64_t diagonal) const override;
  virtual Tensor & triu_(Tensor & self, int64_t diagonal) const override;
  virtual Tensor & cross_out(Tensor & result, const Tensor & self, const Tensor & other, int64_t dim) const override;
  virtual Tensor cross(const Tensor & self, const Tensor & other, int64_t dim) const override;
  virtual Tensor & diag_out(Tensor & result, const Tensor & self, int64_t diagonal) const override;
  virtual Tensor diag(const Tensor & self, int64_t diagonal) const override;
  virtual Tensor & s_th_addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_th_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & th_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s__addmv_out(Tensor & result, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  virtual Tensor s__addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  virtual Tensor & _addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s__addr_out(Tensor & result, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s__addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & _addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & _ger_out(Tensor & result, const Tensor & self, const Tensor & vec2) const override;
  virtual Tensor _ger(const Tensor & self, const Tensor & vec2) const override;
  virtual Tensor & _mv_out(Tensor & result, const Tensor & self, const Tensor & vec) const override;
  virtual Tensor _mv(const Tensor & self, const Tensor & vec) const override;
  virtual Tensor & _mm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const override;
  virtual Tensor _mm(const Tensor & self, const Tensor & mat2) const override;
  virtual Tensor & bmm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const override;
  virtual Tensor bmm(const Tensor & self, const Tensor & mat2) const override;
  virtual Tensor & s_addbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & addbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s_baddbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & baddbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s_addcmul_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor s_addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor & s_addcmul_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor & s_addcdiv_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor s_addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor & s_addcdiv_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual std::tuple<Tensor &,Tensor &> _gesv_single_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A) const override;
  virtual std::tuple<Tensor,Tensor> _gesv_single(const Tensor & self, const Tensor & A) const override;
  virtual std::tuple<Tensor &,Tensor &> gels_out(Tensor & res1, Tensor & res2, const Tensor & self, const Tensor & A) const override;
  virtual std::tuple<Tensor,Tensor> gels(const Tensor & self, const Tensor & A) const override;
  virtual std::tuple<Tensor &,Tensor &> trtrs_out(Tensor & res1, Tensor & res2, const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) const override;
  virtual std::tuple<Tensor,Tensor> trtrs(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) const override;
  virtual std::tuple<Tensor &,Tensor &> symeig_out(Tensor & res1, Tensor & res2, const Tensor & self, bool eigenvectors, bool upper) const override;
  virtual std::tuple<Tensor,Tensor> symeig(const Tensor & self, bool eigenvectors, bool upper) const override;
  virtual std::tuple<Tensor &,Tensor &> eig_out(Tensor & res1, Tensor & res2, const Tensor & self, bool eigenvectors) const override;
  virtual std::tuple<Tensor,Tensor> eig(const Tensor & self, bool eigenvectors) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> svd_out(Tensor & res1, Tensor & res2, Tensor & res3, const Tensor & self, bool some) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> svd(const Tensor & self, bool some) const override;
  virtual Tensor & inverse_out(Tensor & output, const Tensor & self) const override;
  virtual Tensor inverse(const Tensor & self) const override;
  virtual Tensor & potrf_out(Tensor & output, const Tensor & self, bool upper) const override;
  virtual Tensor potrf(const Tensor & self, bool upper) const override;
  virtual Tensor & potrs_out(Tensor & result, const Tensor & self, const Tensor & input2, bool upper) const override;
  virtual Tensor potrs(const Tensor & self, const Tensor & input2, bool upper) const override;
  virtual Tensor & potri_out(Tensor & output, const Tensor & self, bool upper) const override;
  virtual Tensor potri(const Tensor & self, bool upper) const override;
  virtual std::tuple<Tensor &,Tensor &> qr_out(Tensor & res1, Tensor & res2, const Tensor & self) const override;
  virtual std::tuple<Tensor,Tensor> qr(const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> geqrf_out(Tensor & res1, Tensor & res2, const Tensor & self) const override;
  virtual std::tuple<Tensor,Tensor> geqrf(const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> btrifact_out(Tensor & result, Tensor & pivots, const Tensor & self, bool pivot) const override;
  virtual std::tuple<Tensor,Tensor> btrifact(const Tensor & self, bool pivot) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> btrifact_with_info_out(Tensor & result, Tensor & pivots, Tensor & info, const Tensor & self, bool pivot) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> btrifact_with_info(const Tensor & self, bool pivot) const override;
  virtual Tensor & btrisolve_out(Tensor & result, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const override;
  virtual Tensor btrisolve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const override;
  virtual Tensor & random_(Tensor & self, int64_t from, int64_t to, Generator * generator) const override;
  virtual Tensor & random_(Tensor & self, int64_t to, Generator * generator) const override;
  virtual Tensor & random_(Tensor & self, Generator * generator) const override;
  virtual Tensor & multinomial_out(Tensor & result, const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const override;
  virtual Tensor multinomial(const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const override;
  virtual Tensor & uniform_(Tensor & self, double from, double to, Generator * generator) const override;
  virtual Tensor & normal_out(Tensor & output, const Tensor & mean, double std, Generator * generator) const override;
  virtual Tensor normal(const Tensor & mean, double std, Generator * generator) const override;
  virtual Tensor & normal_out(Tensor & output, double mean, const Tensor & std, Generator * generator) const override;
  virtual Tensor normal(double mean, const Tensor & std, Generator * generator) const override;
  virtual Tensor & normal_out(Tensor & output, const Tensor & mean, const Tensor & std, Generator * generator) const override;
  virtual Tensor normal(const Tensor & mean, const Tensor & std, Generator * generator) const override;
  virtual Tensor & normal_(Tensor & self, double mean, double std, Generator * generator) const override;
  virtual Tensor & cauchy_(Tensor & self, double median, double sigma, Generator * generator) const override;
  virtual Tensor & log_normal_(Tensor & self, double mean, double std, Generator * generator) const override;
  virtual Tensor & exponential_(Tensor & self, double lambd, Generator * generator) const override;
  virtual Tensor & geometric_(Tensor & self, double p, Generator * generator) const override;
  virtual Tensor & _bernoulli_(Tensor & self, double p, Generator * generator) const override;
  virtual Tensor & _th_bernoulli_out(Tensor & output, const Tensor & self, Generator * generator) const override;
  virtual Tensor _th_bernoulli(const Tensor & self, Generator * generator) const override;
  virtual Tensor th_tensor(IntList size) const override;
  virtual Tensor th_tensor() const override;
  virtual Tensor tensor(Storage & storage, int64_t storageOffset, IntList size, IntList stride) const override;
  virtual Tensor tensor(IntList size, IntList stride) const override;
  virtual Tensor alias(const Tensor & self) const override;
  virtual Tensor & _copy_ignoring_overlaps_(Tensor & self, const Tensor & src) const override;
  virtual Tensor & as_strided_out(Tensor & result, const Tensor & self, IntList size, IntList stride, int64_t storage_offset) const override;
  virtual Tensor as_strided(const Tensor & self, IntList size, IntList stride, int64_t storage_offset) const override;
  virtual Tensor & as_strided_(Tensor & self, IntList size, IntList stride, int64_t storage_offset) const override;
  virtual Tensor & _cat_out(Tensor & self, TensorList tensors, int64_t dim) const override;
  virtual Tensor _cat(TensorList tensors, int64_t dim) const override;
  virtual Tensor & binary_cross_entropy_forward_out(Tensor & output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  virtual Tensor binary_cross_entropy_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  virtual Tensor & binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  virtual Tensor binary_cross_entropy_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  virtual Tensor & kl_div_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor kl_div_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor & kl_div_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor kl_div_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor & l1_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor l1_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor & l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor & mse_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor mse_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor & mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor mse_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor & multi_margin_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  virtual Tensor multi_margin_loss_forward(const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  virtual Tensor & multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  virtual Tensor multi_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  virtual std::tuple<Tensor &,Tensor &> multilabel_margin_loss_forward_out(Tensor & output, Tensor & is_target, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual std::tuple<Tensor,Tensor> multilabel_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor & multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const override;
  virtual Tensor multilabel_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const override;
  virtual std::tuple<Tensor &,Tensor &> nll_loss_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  virtual std::tuple<Tensor,Tensor> nll_loss_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  virtual Tensor & nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  virtual Tensor nll_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  virtual std::tuple<Tensor &,Tensor &> nll_loss2d_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  virtual std::tuple<Tensor,Tensor> nll_loss2d_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  virtual Tensor & nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  virtual Tensor nll_loss2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  virtual Tensor & smooth_l1_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor smooth_l1_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor & smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor & soft_margin_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor soft_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor & soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  virtual Tensor & elu_forward_out(Tensor & output, const Tensor & self, Scalar alpha, Scalar scale) const override;
  virtual Tensor elu_forward(const Tensor & self, Scalar alpha, Scalar scale) const override;
  virtual Tensor & elu_backward_out(Tensor & grad_input, const Tensor & grad_output, Scalar alpha, Scalar scale, const Tensor & output) const override;
  virtual Tensor elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, const Tensor & output) const override;
  virtual Tensor & elu_forward_(Tensor & self, Scalar alpha, Scalar scale) const override;
  virtual Tensor & glu_forward_out(Tensor & output, const Tensor & self, int64_t dim) const override;
  virtual Tensor glu_forward(const Tensor & self, int64_t dim) const override;
  virtual Tensor & glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, int64_t dim) const override;
  virtual Tensor glu_backward(const Tensor & grad_output, const Tensor & self, int64_t dim) const override;
  virtual Tensor & hardtanh_forward_out(Tensor & output, const Tensor & self, Scalar min_val, Scalar max_val) const override;
  virtual Tensor hardtanh_forward(const Tensor & self, Scalar min_val, Scalar max_val) const override;
  virtual Tensor & hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const override;
  virtual Tensor hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const override;
  virtual Tensor & hardtanh_forward_(Tensor & self, Scalar min_val, Scalar max_val) const override;
  virtual Tensor & leaky_relu_forward_out(Tensor & output, const Tensor & self, Scalar negative_slope) const override;
  virtual Tensor leaky_relu_forward(const Tensor & self, Scalar negative_slope) const override;
  virtual Tensor & leaky_relu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const override;
  virtual Tensor leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const override;
  virtual Tensor & leaky_relu_forward_(Tensor & self, Scalar negative_slope) const override;
  virtual std::tuple<Tensor &,Tensor &> log_sigmoid_forward_out(Tensor & output, Tensor & buffer, const Tensor & self) const override;
  virtual std::tuple<Tensor,Tensor> log_sigmoid_forward(const Tensor & self) const override;
  virtual Tensor & log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const override;
  virtual Tensor log_sigmoid_backward(const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const override;
  virtual Tensor & prelu_forward_out(Tensor & output, const Tensor & self, const Tensor & weight) const override;
  virtual Tensor prelu_forward(const Tensor & self, const Tensor & weight) const override;
  virtual std::tuple<Tensor &,Tensor &> prelu_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight) const override;
  virtual std::tuple<Tensor,Tensor> prelu_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, std::array<bool,2> output_mask) const override;
  virtual Tensor & rrelu_with_noise_forward_out(Tensor & output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  virtual Tensor rrelu_with_noise_forward(const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  virtual Tensor & rrelu_with_noise_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const override;
  virtual Tensor rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const override;
  virtual Tensor & rrelu_with_noise_forward_(Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  virtual Tensor & softplus_forward_out(Tensor & output, const Tensor & self, Scalar beta, Scalar threshold) const override;
  virtual Tensor softplus_forward(const Tensor & self, Scalar beta, Scalar threshold) const override;
  virtual Tensor & softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const override;
  virtual Tensor softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const override;
  virtual Tensor & softshrink_forward_out(Tensor & output, const Tensor & self, Scalar lambd) const override;
  virtual Tensor softshrink_forward(const Tensor & self, Scalar lambd) const override;
  virtual Tensor & softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar lambd) const override;
  virtual Tensor softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd) const override;
  virtual Tensor & threshold_forward_out(Tensor & output, const Tensor & self, Scalar threshold, Scalar value) const override;
  virtual Tensor threshold_forward(const Tensor & self, Scalar threshold, Scalar value) const override;
  virtual Tensor & threshold_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar threshold, Scalar value) const override;
  virtual Tensor threshold_backward(const Tensor & grad_output, const Tensor & self, Scalar threshold, Scalar value) const override;
  virtual Tensor & threshold_forward_(Tensor & self, Scalar threshold, Scalar value) const override;
  virtual Tensor & adaptive_avg_pool2d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const override;
  virtual Tensor adaptive_avg_pool2d_forward(const Tensor & self, IntList output_size) const override;
  virtual Tensor & adaptive_avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self) const override;
  virtual Tensor adaptive_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self) const override;
  virtual Tensor & adaptive_avg_pool3d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const override;
  virtual Tensor adaptive_avg_pool3d_forward(const Tensor & self, IntList output_size) const override;
  virtual Tensor & adaptive_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self) const override;
  virtual Tensor adaptive_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList output_size) const override;
  virtual std::tuple<Tensor,Tensor> adaptive_max_pool2d_forward(const Tensor & self, IntList output_size) const override;
  virtual Tensor & adaptive_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices) const override;
  virtual Tensor adaptive_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices) const override;
  virtual std::tuple<Tensor &,Tensor &> adaptive_max_pool3d_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList output_size) const override;
  virtual std::tuple<Tensor,Tensor> adaptive_max_pool3d_forward(const Tensor & self, IntList output_size) const override;
  virtual Tensor & adaptive_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices) const override;
  virtual Tensor adaptive_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices) const override;
  virtual Tensor & avg_pool2d_forward_out(Tensor & output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor avg_pool2d_forward(const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor & avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor avg_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor & avg_pool3d_forward_out(Tensor & output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor avg_pool3d_forward(const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor & avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual Tensor avg_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  virtual std::tuple<Tensor &,Tensor &> fractional_max_pool2d_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & random_samples) const override;
  virtual std::tuple<Tensor,Tensor> fractional_max_pool2d_forward(const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & random_samples) const override;
  virtual Tensor & fractional_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & indices) const override;
  virtual Tensor fractional_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & indices) const override;
  virtual std::tuple<Tensor &,Tensor &> max_pool2d_with_indices_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  virtual std::tuple<Tensor,Tensor> max_pool2d_with_indices_forward(const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  virtual Tensor & max_pool2d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const override;
  virtual Tensor max_pool2d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const override;
  virtual std::tuple<Tensor &,Tensor &> max_pool3d_with_indices_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  virtual std::tuple<Tensor,Tensor> max_pool3d_with_indices_forward(const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  virtual Tensor & max_pool3d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const override;
  virtual Tensor max_pool3d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const override;
  virtual Tensor & max_unpool2d_forward_out(Tensor & output, const Tensor & self, const Tensor & indices, IntList output_size) const override;
  virtual Tensor max_unpool2d_forward(const Tensor & self, const Tensor & indices, IntList output_size) const override;
  virtual Tensor & max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntList output_size) const override;
  virtual Tensor max_unpool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntList output_size) const override;
  virtual Tensor & max_unpool3d_forward_out(Tensor & output, const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  virtual Tensor max_unpool3d_forward(const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  virtual Tensor & max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  virtual Tensor max_unpool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  virtual Tensor & reflection_pad1d_forward_out(Tensor & output, const Tensor & self, IntList padding) const override;
  virtual Tensor reflection_pad1d_forward(const Tensor & self, IntList padding) const override;
  virtual Tensor & reflection_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  virtual Tensor reflection_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  virtual Tensor & reflection_pad2d_forward_out(Tensor & output, const Tensor & self, IntList padding) const override;
  virtual Tensor reflection_pad2d_forward(const Tensor & self, IntList padding) const override;
  virtual Tensor & reflection_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  virtual Tensor reflection_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  virtual Tensor & replication_pad1d_forward_out(Tensor & output, const Tensor & self, IntList padding) const override;
  virtual Tensor replication_pad1d_forward(const Tensor & self, IntList padding) const override;
  virtual Tensor & replication_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  virtual Tensor replication_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  virtual Tensor & replication_pad2d_forward_out(Tensor & output, const Tensor & self, IntList padding) const override;
  virtual Tensor replication_pad2d_forward(const Tensor & self, IntList padding) const override;
  virtual Tensor & replication_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  virtual Tensor replication_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  virtual Tensor & replication_pad3d_forward_out(Tensor & output, const Tensor & self, IntList padding) const override;
  virtual Tensor replication_pad3d_forward(const Tensor & self, IntList padding) const override;
  virtual Tensor & replication_pad3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  virtual Tensor replication_pad3d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  virtual Tensor & upsample_linear1d_forward_out(Tensor & output, const Tensor & self, IntList output_size, bool align_corners) const override;
  virtual Tensor upsample_linear1d_forward(const Tensor & self, IntList output_size, bool align_corners) const override;
  virtual Tensor & upsample_linear1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const override;
  virtual Tensor upsample_linear1d_backward(const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const override;
  virtual Tensor & upsample_bilinear2d_forward_out(Tensor & output, const Tensor & self, IntList output_size, bool align_corners) const override;
  virtual Tensor upsample_bilinear2d_forward(const Tensor & self, IntList output_size, bool align_corners) const override;
  virtual Tensor & upsample_bilinear2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const override;
  virtual Tensor upsample_bilinear2d_backward(const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const override;
  virtual Tensor & upsample_trilinear3d_forward_out(Tensor & output, const Tensor & self, IntList output_size, bool align_corners) const override;
  virtual Tensor upsample_trilinear3d_forward(const Tensor & self, IntList output_size, bool align_corners) const override;
  virtual Tensor & upsample_trilinear3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const override;
  virtual Tensor upsample_trilinear3d_backward(const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const override;
  virtual Tensor & upsample_nearest1d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const override;
  virtual Tensor upsample_nearest1d_forward(const Tensor & self, IntList output_size) const override;
  virtual Tensor & upsample_nearest1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size) const override;
  virtual Tensor upsample_nearest1d_backward(const Tensor & grad_output, IntList output_size, IntList input_size) const override;
  virtual Tensor & upsample_nearest2d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const override;
  virtual Tensor upsample_nearest2d_forward(const Tensor & self, IntList output_size) const override;
  virtual Tensor & upsample_nearest2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size) const override;
  virtual Tensor upsample_nearest2d_backward(const Tensor & grad_output, IntList output_size, IntList input_size) const override;
  virtual Tensor & upsample_nearest3d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const override;
  virtual Tensor upsample_nearest3d_forward(const Tensor & self, IntList output_size) const override;
  virtual Tensor & upsample_nearest3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size) const override;
  virtual Tensor upsample_nearest3d_backward(const Tensor & grad_output, IntList output_size, IntList input_size) const override;
  virtual Tensor & _sigmoid_forward_out(Tensor & output, const Tensor & self) const override;
  virtual Tensor _sigmoid_forward(const Tensor & self) const override;
  virtual Tensor & _sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const override;
  virtual Tensor _sigmoid_backward(const Tensor & grad_output, const Tensor & output) const override;
  virtual Tensor & _tanh_forward_out(Tensor & output, const Tensor & self) const override;
  virtual Tensor _tanh_forward(const Tensor & self) const override;
  virtual Tensor & _tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const override;
  virtual Tensor _tanh_backward(const Tensor & grad_output, const Tensor & output) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_batch_norm_forward_out(Tensor & output, Tensor & save_mean, Tensor & save_std, const Tensor & self, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_batch_norm_forward(const Tensor & self, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_batch_norm_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, bool training, double eps, const Tensor & save_mean, const Tensor & save_std) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_batch_norm_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, bool training, double eps, const Tensor & save_mean, const Tensor & save_std, std::array<bool,3> output_mask) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose2d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose3d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & finput, const Tensor & fgrad_input) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const override;
  virtual Tensor & thnn_conv_depthwise2d_forward_out(Tensor & output, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  virtual Tensor thnn_conv_depthwise2d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  virtual std::tuple<Tensor &,Tensor &> thnn_conv_depthwise2d_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation) const override;
  virtual std::tuple<Tensor,Tensor> thnn_conv_depthwise2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, std::array<bool,2> output_mask) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated2d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated3d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated3d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const override;
  virtual Tensor _cudnn_rnn_flatten_weight(TensorList weight_arr, int64_t weight_stride0, int64_t input_size, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, bool bidirectional) const override;
  virtual std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _cudnn_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntList batch_sizes, const Tensor & dropout_state) const override;
  virtual std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> _cudnn_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntList batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask) const override;
  virtual Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed) const override;
  virtual Tensor & abs_(Tensor & self) const override;
  virtual Tensor & abs_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & acos_(Tensor & self) const override;
  virtual Tensor & acos_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & asin_(Tensor & self) const override;
  virtual Tensor & asin_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & atan_(Tensor & self) const override;
  virtual Tensor & atan_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor bincount(const Tensor & self, const Tensor & weights, int64_t minlength) const override;
  virtual Tensor & ceil_(Tensor & self) const override;
  virtual Tensor & ceil_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & cos_(Tensor & self) const override;
  virtual Tensor & cos_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & cosh_(Tensor & self) const override;
  virtual Tensor & cosh_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor cudnn_affine_grid_generator(const Tensor & theta, int64_t N, int64_t C, int64_t H, int64_t W) const override;
  virtual Tensor cudnn_affine_grid_generator_backward(const Tensor & grad, int64_t N, int64_t C, int64_t H, int64_t W) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon) const override;
  virtual Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  virtual Tensor cudnn_convolution_backward_input(IntList self_size, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const override;
  virtual Tensor cudnn_convolution_backward_bias(const Tensor & grad_output) const override;
  virtual Tensor cudnn_convolution_backward_weight(IntList weight_size, const Tensor & grad_output, const Tensor & self, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  virtual Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntList padding, IntList output_padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  virtual std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList output_padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const override;
  virtual Tensor cudnn_convolution_transpose_backward_bias(const Tensor & grad_output) const override;
  virtual Tensor cudnn_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  virtual Tensor cudnn_convolution_transpose_backward_weight(IntList weight_size, const Tensor & grad_output, const Tensor & self, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  virtual Tensor cudnn_grid_sampler(const Tensor & self, const Tensor & grid) const override;
  virtual std::tuple<Tensor,Tensor> cudnn_grid_sampler_backward(const Tensor & self, const Tensor & grid, const Tensor & grad_output) const override;
  virtual Tensor embedding_dense_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq) const override;
  virtual Tensor & embedding_renorm_(Tensor & self, const Tensor & indices, double max_norm, double norm_type) const override;
  virtual std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq, int64_t mode, bool sparse) const override;
  virtual Tensor _embedding_bag_dense_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode) const override;
  virtual Tensor & erf_(Tensor & self) const override;
  virtual Tensor & erf_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & exp_(Tensor & self) const override;
  virtual Tensor & exp_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & expm1_(Tensor & self) const override;
  virtual Tensor & expm1_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & eye_out(Tensor & result, int64_t n) const override;
  virtual Tensor & eye_out(Tensor & result, int64_t n, int64_t m) const override;
  virtual Tensor & floor_(Tensor & self) const override;
  virtual Tensor & floor_out(Tensor & result, const Tensor & self) const override;
  virtual std::tuple<Tensor,Tensor> _gesv_helper(const Tensor & self, const Tensor & A) const override;
  virtual Tensor _fft_with_size(const Tensor & self, int64_t signal_ndim, bool complex_input, bool complex_output, bool inverse, IntList checked_signal_sizes, bool normalized, bool onesided, IntList output_sizes) const override;
  virtual Tensor & log_(Tensor & self) const override;
  virtual Tensor & log_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & log10_(Tensor & self) const override;
  virtual Tensor & log10_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & log1p_(Tensor & self) const override;
  virtual Tensor & log1p_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & log2_(Tensor & self) const override;
  virtual Tensor & log2_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor log_softmax(const Tensor & self, int64_t dim) const override;
  virtual Tensor log_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self) const override;
  virtual Tensor & randperm_out(Tensor & result, int64_t n, Generator * generator) const override;
  virtual std::tuple<Tensor,Tensor> RoiPooling2d_forward(const Tensor & input, const Tensor & rois, int64_t pooledHeight, int64_t pooledWidth, double spatialScale) const override;
  virtual Tensor RoiPooling2d_backward(const Tensor & input, const Tensor & rois, int64_t pooledHeight, int64_t pooledWidth, double spatialScale, const Tensor & gradOutput, const Tensor & argmaxes) const override;
  virtual Tensor & round_(Tensor & self) const override;
  virtual Tensor & round_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor hardshrink(const Tensor & self, Scalar lambd) const override;
  virtual Tensor hardshrink_backward(const Tensor & grad_out, const Tensor & self, Scalar lambd) const override;
  virtual Tensor & rsqrt_(Tensor & self) const override;
  virtual Tensor & rsqrt_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & sin_(Tensor & self) const override;
  virtual Tensor & sin_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & sinh_(Tensor & self) const override;
  virtual Tensor & sinh_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor softmax(const Tensor & self, int64_t dim) const override;
  virtual Tensor softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self) const override;
  virtual Tensor & sspaddmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor _sum(const Tensor & self) const override;
  virtual Tensor & _sum_cuda_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor & sqrt_(Tensor & self) const override;
  virtual Tensor & sqrt_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor _prod(const Tensor & self) const override;
  virtual Tensor & _prod_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor & tan_(Tensor & self) const override;
  virtual Tensor & tan_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor & tanh_(Tensor & self) const override;
  virtual Tensor & tanh_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor flip(const Tensor & self, IntList dims) const override;
  virtual Tensor & trunc_(Tensor & self) const override;
  virtual Tensor & trunc_out(Tensor & result, const Tensor & self) const override;
  virtual std::tuple<Tensor,Tensor> _unique(const Tensor & self, bool sorted, bool return_inverse) const override;
  virtual Tensor _s_where(const Tensor & condition, const Tensor & self, const Tensor & other) const override;
  virtual Tensor _standard_gamma_grad(const Tensor & self, const Tensor & output) const override;
  virtual Tensor _standard_gamma(const Tensor & self, Generator * generator) const override;
  virtual Tensor poisson(const Tensor & self, Generator * generator) const override;
  virtual Tensor native_norm(const Tensor & self, Scalar p) const override;
  virtual Tensor native_clone(const Tensor & self) const override;
  virtual Tensor & native_resize_as_(Tensor & self, const Tensor & the_template) const override;
  virtual Tensor & native_pow_out(Tensor & result, const Tensor & self, Scalar exponent) const override;
  virtual Tensor native_pow(const Tensor & self, Scalar exponent) const override;
  virtual Tensor & native_zero_(Tensor & self) const override;
  virtual Tensor & s_native_add_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & native_add_out(Tensor & result, const Tensor & self, SparseTensorRef other, Scalar alpha) const override;
  virtual Tensor s_native_add(const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor native_add(const Tensor & self, SparseTensorRef other, Scalar alpha) const override;
  virtual Tensor & s_native_add_(Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & native_add_(Tensor & self, SparseTensorRef other, Scalar alpha) const override;
  virtual Tensor & s_native_sub_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor s_native_sub(const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & s_native_sub_(Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & s_native_mul_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_native_mul(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & s_native_mul_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & native_mul_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor native_mul(const Tensor & self, Scalar other) const override;
  virtual Tensor & native_mul_(Tensor & self, Scalar other) const override;
  virtual Tensor & native_div_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor native_div(const Tensor & self, Scalar other) const override;
  virtual Tensor & native_div_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_native_addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_native_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s_native_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor native_tensor() const override;
  virtual Tensor native_tensor(IntList size) const override;
  virtual Tensor native_sparse_coo_tensor(const Tensor & indices, const Tensor & values) const override;
  virtual Tensor native_sparse_coo_tensor(const Tensor & indices, const Tensor & values, IntList size) const override;
  virtual Tensor _native_sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntList size) const override;
  virtual Tensor & sparse_raw_resize_(Tensor & self, IntList size, int64_t sparseDims, int64_t denseDims) const override;
  virtual Tensor _sparse_mask(const Tensor & self, SparseTensorRef mask) const override;
  virtual Tensor to_dense(const Tensor & self) const override;
  virtual int64_t _sparseDims(const Tensor & self) const override;
  virtual int64_t _denseDims(const Tensor & self) const override;
  virtual int64_t _nnz(const Tensor & self) const override;
  virtual Tensor coalesce(const Tensor & self) const override;
  virtual bool is_coalesced(const Tensor & self) const override;
  virtual Tensor _indices(const Tensor & self) const override;
  virtual Tensor _values(const Tensor & self) const override;
  virtual Tensor & hspmm_out(Tensor & result, const Tensor & mat1, const Tensor & mat2) const override;
  virtual Tensor hspmm(const Tensor & mat1, const Tensor & mat2) const override;
  virtual Tensor & raw_copy_sparse_(Tensor & self, const Tensor & src) const override;
  virtual int64_t native_get_device(const Tensor & self) const override;
};

} // namespace at
