#pragma once

// @generated by aten/src/ATen/gen.py

#include <ATen/ScalarType.h>
#include <ATen/TensorOperators.h>
#include <ATen/TensorMethods.h>
#include <ATen/TensorOptions.h>

#include <array>
#include <functional>
#include <string>
#include <tuple>
#include <vector>

namespace at {
struct Generator;
class Scalar;
struct Tensor;
struct Type;
} // namespace at

namespace at {
namespace native {

inline Tensor from_blob(
    void* data,
    IntList sizes,
    const std::function<void(void*)>& deleter,
    const TensorOptions& options = {}) {
  return options.type().tensorFromBlob(data, sizes, deleter);
}

inline Tensor from_blob(
    void* data,
    IntList sizes,
    const TensorOptions& options = {}) {
  return native::from_blob(data, sizes, [](void*) {}, options);
}

// These functions are defined in native/TensorFactories.cpp.
#define TENSOR(T, S, _1)                                               \
  Tensor tensor(ArrayRef<T> values, const TensorOptions& options);     \
  inline Tensor tensor(                                                \
      std::initializer_list<T> values, const TensorOptions& options) { \
    return native::tensor(ArrayRef<T>(values), options);               \
  }                                                                    \
  inline Tensor tensor(T value, const TensorOptions& options) {        \
    return native::tensor(ArrayRef<T>(value), options);                \
  }                                                                    \
  inline Tensor tensor(ArrayRef<T> values) {                           \
    return native::tensor(std::move(values), at::dtype(k##S));         \
  }                                                                    \
  inline Tensor tensor(std::initializer_list<T> values) {              \
    return native::tensor(ArrayRef<T>(values));                        \
  }                                                                    \
  inline Tensor tensor(T value) {                                      \
    return native::tensor(ArrayRef<T>(value));                         \
  }
AT_FORALL_SCALAR_TYPES_EXCEPT_HALF(TENSOR)
#undef TENSOR

Tensor _cast_Byte(const Tensor & self, bool non_blocking=false);
Tensor _cast_Char(const Tensor & self, bool non_blocking=false);
Tensor _cast_Double(const Tensor & self, bool non_blocking=false);
Tensor _cast_Float(const Tensor & self, bool non_blocking=false);
Tensor _cast_Int(const Tensor & self, bool non_blocking=false);
Tensor _cast_Long(const Tensor & self, bool non_blocking=false);
Tensor _cast_Short(const Tensor & self, bool non_blocking=false);
Tensor _cast_Half(const Tensor & self, bool non_blocking=false);
Tensor _cudnn_rnn_flatten_weight(TensorList weight_arr, int64_t weight_stride0, int64_t input_size, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, bool bidirectional);
std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _cudnn_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntList batch_sizes, const Tensor & dropout_state);
std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> _cudnn_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntList batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask);
Tensor _cudnn_init_dropout_state(const Type & self_ty, double dropout, bool train, int64_t dropout_seed);
Tensor abs(const Tensor & self);
Tensor & _abs__cpu(Tensor & self);
Tensor & _abs__cuda(Tensor & self);
Tensor & _abs_out_cpu(Tensor & result, const Tensor & self);
Tensor & _abs_out_cuda(Tensor & result, const Tensor & self);
Tensor acos(const Tensor & self);
Tensor & _acos__cpu(Tensor & self);
Tensor & _acos__cuda(Tensor & self);
Tensor & _acos_out_cpu(Tensor & result, const Tensor & self);
Tensor & _acos_out_cuda(Tensor & result, const Tensor & self);
Tensor avg_pool1d(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, bool ceil_mode=false, bool count_include_pad=true);
Tensor adaptive_avg_pool1d(const Tensor & self, IntList output_size);
std::tuple<Tensor,Tensor> adaptive_max_pool1d(const Tensor & self, IntList output_size);
bool allclose(const Tensor & self, const Tensor & other, double rtol=1e-05, double atol=1e-08, bool equal_nan=false);
Tensor addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
Tensor & addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
Tensor & addmv_out(Tensor & result, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
Tensor addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
Tensor & addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
Tensor & addr_out(Tensor & result, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
Tensor all(const Tensor & self, int64_t dim, bool keepdim=false);
Tensor & all_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false);
Tensor any(const Tensor & self, int64_t dim, bool keepdim=false);
Tensor & any_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false);
Tensor arange(Scalar start, Scalar end, const TensorOptions & options={});
Tensor arange(Scalar start, Scalar end, Scalar step, const TensorOptions & options={});
Tensor & arange_out(Tensor & result, Scalar start, Scalar end);
Tensor & arange_out(Tensor & result, Scalar start, Scalar end, Scalar step);
Tensor arange(Scalar end, const TensorOptions & options={});
Tensor & arange_out(Tensor & result, Scalar end);
Tensor _dim_arange(const Tensor & like, int64_t dim);
Tensor argmax(const Tensor & self, int64_t dim, bool keepdim=false);
Tensor argmax(const Tensor & self);
Tensor _argmax(const Tensor & self, int64_t dim, bool keepdim=false);
Tensor argmin(const Tensor & self, int64_t dim, bool keepdim=false);
Tensor argmin(const Tensor & self);
Tensor _argmin(const Tensor & self, int64_t dim, bool keepdim=false);
Tensor as_strided(const Tensor & self, IntList size, IntList stride);
Tensor & as_strided_(Tensor & self, IntList size, IntList stride);
Tensor asin(const Tensor & self);
Tensor & _asin__cpu(Tensor & self);
Tensor & _asin__cuda(Tensor & self);
Tensor & _asin_out_cpu(Tensor & result, const Tensor & self);
Tensor & _asin_out_cuda(Tensor & result, const Tensor & self);
Tensor atan(const Tensor & self);
Tensor & _atan__cpu(Tensor & self);
Tensor & _atan__cuda(Tensor & self);
Tensor & _atan_out_cpu(Tensor & result, const Tensor & self);
Tensor & _atan_out_cuda(Tensor & result, const Tensor & self);
Tensor bartlett_window(int64_t window_length, const TensorOptions & options={});
Tensor bartlett_window(int64_t window_length, bool periodic, const TensorOptions & options={});
Tensor batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled);
Tensor bernoulli(const Tensor & self, const Tensor & p, Generator * generator=nullptr);
Tensor bernoulli(const Tensor & self, double p, Generator * generator=nullptr);
Tensor bernoulli(const Tensor & self);
Tensor & bernoulli_(Tensor & self, const Tensor & p, Generator * generator=nullptr);
Tensor & bernoulli_(Tensor & self, double p, Generator * generator=nullptr);
Tensor & bernoulli_(Tensor & self);
Tensor bilinear(const Tensor & input1, const Tensor & input2, const Tensor & weight, const Tensor & bias);
Tensor _bincount_cpu(const Tensor & self, const Tensor & weights={}, int64_t minlength=0);
Tensor _bincount_cuda(const Tensor & self, const Tensor & weights={}, int64_t minlength=0);
Tensor blackman_window(int64_t window_length, const TensorOptions & options={});
Tensor blackman_window(int64_t window_length, bool periodic, const TensorOptions & options={});
Tensor cat(TensorList tensors, int64_t dim=0);
Tensor & cat_out(Tensor & result, TensorList tensors, int64_t dim=0);
Tensor ceil(const Tensor & self);
Tensor & _ceil__cpu(Tensor & self);
Tensor & _ceil__cuda(Tensor & self);
Tensor & _ceil_out_cpu(Tensor & result, const Tensor & self);
Tensor & _ceil_out_cuda(Tensor & result, const Tensor & self);
std::vector<Tensor> chunk(const Tensor & self, int64_t chunks, int64_t dim=0);
bool cudnn_is_acceptable(const Tensor & self);
Tensor convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntList stride, IntList padding, IntList dilation, bool transposed, IntList output_padding, int64_t groups);
Tensor _convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntList stride, IntList padding, IntList dilation, bool transposed, IntList output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled);
Tensor _convolution_nogroup(const Tensor & input, const Tensor & weight, const Tensor & bias, IntList stride, IntList padding, IntList dilation, bool transposed, IntList output_padding);
std::tuple<Tensor,Tensor,Tensor> _convolution_double_backward(const Tensor & ggI, const Tensor & ggW, const Tensor & ggb, const Tensor & gO, const Tensor & weight, const Tensor & self, IntList stride, IntList padding, IntList dilation, bool transposed, IntList output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, std::array<bool,3> output_mask);
Tensor conv1d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList dilation=1, int64_t groups=1);
Tensor conv2d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList dilation=1, int64_t groups=1);
Tensor conv3d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList dilation=1, int64_t groups=1);
Tensor conv_tbc(const Tensor & self, const Tensor & weight, const Tensor & bias, int64_t pad);
std::tuple<Tensor,Tensor,Tensor> conv_tbc_backward(const Tensor & self, const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t pad);
Tensor conv_transpose1d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList output_padding=0, int64_t groups=1, IntList dilation=1);
Tensor conv_transpose2d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList output_padding=0, int64_t groups=1, IntList dilation=1);
Tensor conv_transpose3d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList output_padding=0, int64_t groups=1, IntList dilation=1);
Tensor cos(const Tensor & self);
Tensor & _cos__cpu(Tensor & self);
Tensor & _cos__cuda(Tensor & self);
Tensor & _cos_out_cpu(Tensor & result, const Tensor & self);
Tensor & _cos_out_cuda(Tensor & result, const Tensor & self);
Tensor cosh(const Tensor & self);
Tensor & _cosh__cpu(Tensor & self);
Tensor & _cosh__cuda(Tensor & self);
Tensor & _cosh_out_cpu(Tensor & result, const Tensor & self);
Tensor & _cosh_out_cuda(Tensor & result, const Tensor & self);
Tensor cosine_embedding_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin=0.0, int64_t reduction=Reduction::ElementwiseMean);
Tensor cudnn_affine_grid_generator_forward(const Tensor & theta, int64_t N, int64_t C, int64_t H, int64_t W);
Tensor cudnn_affine_grid_generator_backward(const Tensor & grad, int64_t N, int64_t C, int64_t H, int64_t W);
std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon);
std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon);
Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic);
Tensor cudnn_convolution_backward_input(IntList self_size, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic);
std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
Tensor cudnn_convolution_backward_bias(const Tensor & grad_output);
Tensor cudnn_convolution_backward_weight(IntList weight_size, const Tensor & grad_output, const Tensor & self, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic);
Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntList padding, IntList output_padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic);
std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList output_padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
Tensor cudnn_convolution_backward_bias(const Tensor & grad_output);
Tensor cudnn_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic);
Tensor cudnn_convolution_transpose_backward_weight(IntList weight_size, const Tensor & grad_output, const Tensor & self, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic);
Tensor cudnn_grid_sampler_forward(const Tensor & self, const Tensor & grid);
std::tuple<Tensor,Tensor> cudnn_grid_sampler_backward(const Tensor & self, const Tensor & grid, const Tensor & grad_output);
Tensor cumsum(const Tensor & self, int64_t dim, ScalarType dtype);
Tensor cumsum(const Tensor & self, int64_t dim);
Tensor & cumsum_out(Tensor & result, const Tensor & self, int64_t dim, ScalarType dtype);
Tensor & cumsum_out(Tensor & result, const Tensor & self, int64_t dim);
Tensor cumprod(const Tensor & self, int64_t dim, ScalarType dtype);
Tensor cumprod(const Tensor & self, int64_t dim);
Tensor & cumprod_out(Tensor & result, const Tensor & self, int64_t dim, ScalarType dtype);
Tensor & cumprod_out(Tensor & result, const Tensor & self, int64_t dim);
Tensor det(const Tensor & self);
Tensor diagflat(const Tensor & self, int64_t offset=0);
Tensor diagonal(const Tensor & self, int64_t offset=0, int64_t dim1=0, int64_t dim2=1);
Tensor dot(const Tensor & self, const Tensor & tensor);
Tensor & dot_out(Tensor & result, const Tensor & self, const Tensor & tensor);
Tensor einsum(std::string equation, TensorList tensors);
Tensor embedding(const Tensor & weight, const Tensor & indices, int64_t padding_idx=-1, bool scale_grad_by_freq=false, bool sparse=false);
Tensor embedding_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq, bool sparse);
Tensor embedding_dense_backward_cpu(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
Tensor embedding_dense_backward_cuda(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
Tensor & embedding_renorm_cpu_(Tensor & self, const Tensor & indices, double max_norm, double norm_type);
Tensor & embedding_renorm_cuda_(Tensor & self, const Tensor & indices, double max_norm, double norm_type);
Tensor embedding_sparse_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
std::tuple<Tensor,Tensor,Tensor,Tensor> embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false);
std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag_cpu(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false);
std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag_cuda(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false);
Tensor _embedding_bag_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, bool sparse);
Tensor _embedding_bag_sparse_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, int64_t num_weights, bool scale_grad_by_freq, int64_t mode);
Tensor _embedding_bag_dense_backward_cpu(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode);
Tensor _embedding_bag_dense_backward_cuda(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode);
Tensor empty(IntList size, const TensorOptions & options={});
Tensor & empty_out(Tensor & result, IntList size);
Tensor empty_like(const Tensor & self);
Tensor empty_like(const Tensor & self, const TensorOptions & options);
Tensor erf(const Tensor & self);
Tensor & _erf__cpu(Tensor & self);
Tensor & _erf__cuda(Tensor & self);
Tensor & _erf_out_cpu(Tensor & result, const Tensor & self);
Tensor & _erf_out_cuda(Tensor & result, const Tensor & self);
Tensor exp(const Tensor & self);
Tensor & _exp__cpu(Tensor & self);
Tensor & _exp__cuda(Tensor & self);
Tensor & _exp_out_cpu(Tensor & result, const Tensor & self);
Tensor & _exp_out_cuda(Tensor & result, const Tensor & self);
Tensor expm1(const Tensor & self);
Tensor & _expm1__cpu(Tensor & self);
Tensor & _expm1__cuda(Tensor & self);
Tensor & _expm1_out_cpu(Tensor & result, const Tensor & self);
Tensor & _expm1_out_cuda(Tensor & result, const Tensor & self);
Tensor expand(const Tensor & self, IntList size, bool implicit=false);
Tensor expand_as(const Tensor & self, const Tensor & other);
Tensor eye(int64_t n, const TensorOptions & options={});
Tensor eye(int64_t n, int64_t m, const TensorOptions & options={});
Tensor & eye_out_cpu(Tensor & result, int64_t n);
Tensor & eye_out_cuda(Tensor & result, int64_t n);
Tensor & eye_out_cpu(Tensor & result, int64_t n, int64_t m);
Tensor & eye_out_cuda(Tensor & result, int64_t n, int64_t m);
Tensor flatten(const Tensor & self, int64_t start_dim=0, int64_t end_dim=-1);
Tensor & fill_(Tensor & self, Scalar value);
Tensor & fill_(Tensor & self, const Tensor & value);
Tensor floor(const Tensor & self);
Tensor & _floor__cpu(Tensor & self);
Tensor & _floor__cuda(Tensor & self);
Tensor & _floor_out_cpu(Tensor & result, const Tensor & self);
Tensor & _floor_out_cuda(Tensor & result, const Tensor & self);
Tensor full(IntList size, Scalar fill_value, const TensorOptions & options={});
Tensor & full_out(Tensor & result, IntList size, Scalar fill_value);
Tensor full_like(const Tensor & self, Scalar fill_value);
Tensor full_like(const Tensor & self, Scalar fill_value, const TensorOptions & options);
Tensor hann_window(int64_t window_length, const TensorOptions & options={});
Tensor hann_window(int64_t window_length, bool periodic, const TensorOptions & options={});
Tensor hamming_window(int64_t window_length, const TensorOptions & options={});
Tensor hamming_window(int64_t window_length, bool periodic, const TensorOptions & options={});
Tensor hamming_window(int64_t window_length, bool periodic, double alpha, const TensorOptions & options={});
Tensor hamming_window(int64_t window_length, bool periodic, double alpha, double beta, const TensorOptions & options={});
Tensor hinge_embedding_loss(const Tensor & self, const Tensor & target, double margin=1.0, int64_t reduction=Reduction::ElementwiseMean);
Tensor ger(const Tensor & self, const Tensor & vec2);
Tensor & ger_out(Tensor & result, const Tensor & self, const Tensor & vec2);
std::tuple<Tensor,Tensor> gesv(const Tensor & self, const Tensor & A);
std::tuple<Tensor &,Tensor &> gesv_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A);
std::tuple<Tensor,Tensor> _gesv_helper_cpu(const Tensor & self, const Tensor & A);
std::tuple<Tensor,Tensor> _gesv_helper_cuda(const Tensor & self, const Tensor & A);
Tensor group_norm(const Tensor & input, int64_t num_groups, const Tensor & weight={}, const Tensor & bias={}, double eps=1e-05, bool cudnn_enabled=true);
Tensor fft(const Tensor & self, int64_t signal_ndim, bool normalized=false);
Tensor ifft(const Tensor & self, int64_t signal_ndim, bool normalized=false);
Tensor rfft(const Tensor & self, int64_t signal_ndim, bool normalized=false, bool onesided=true);
Tensor irfft(const Tensor & self, int64_t signal_ndim, bool normalized=false, bool onesided=true, IntList signal_sizes={});
Tensor _fft_mkl(const Tensor & self, int64_t signal_ndim, bool complex_input, bool complex_output, bool inverse, IntList checked_signal_sizes, bool normalized, bool onesided, IntList output_sizes);
Tensor _fft_cufft(const Tensor & self, int64_t signal_ndim, bool complex_input, bool complex_output, bool inverse, IntList checked_signal_sizes, bool normalized, bool onesided, IntList output_sizes);
int64_t _cufft_get_plan_cache_size();
int64_t _cufft_get_plan_cache_max_size();
void _cufft_set_plan_cache_max_size(int64_t max_size);
void _cufft_clear_plan_cache();
Tensor index(const Tensor & self, TensorList indices);
Tensor & index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
Tensor index_put(const Tensor & self, TensorList indices, const Tensor & values);
Tensor & index_put_(Tensor & self, TensorList indices, const Tensor & values);
Tensor isclose(const Tensor & self, const Tensor & other, double rtol=1e-05, double atol=1e-08, bool equal_nan=false);
bool is_cuda(const Tensor & self);
bool is_distributed(const Tensor & self);
bool is_floating_point(const Tensor & self);
bool is_nonzero(const Tensor & self);
bool is_same_size(const Tensor & self, const Tensor & other);
bool is_signed(const Tensor & self);
bool is_sparse(const Tensor & self);
std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false);
std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false);
Tensor layer_norm(const Tensor & input, IntList normalized_shape, const Tensor & weight={}, const Tensor & bias={}, double eps=1e-05, bool cudnn_enable=true);
Tensor linspace(Scalar start, Scalar end, const TensorOptions & options={});
Tensor linspace(Scalar start, Scalar end, int64_t steps, const TensorOptions & options={});
Tensor & linspace_out(Tensor & result, Scalar start, Scalar end);
Tensor & linspace_out(Tensor & result, Scalar start, Scalar end, int64_t steps);
Tensor log(const Tensor & self);
Tensor & _log__cpu(Tensor & self);
Tensor & _log__cuda(Tensor & self);
Tensor & _log_out_cpu(Tensor & result, const Tensor & self);
Tensor & _log_out_cuda(Tensor & result, const Tensor & self);
Tensor log10(const Tensor & self);
Tensor & _log10__cpu(Tensor & self);
Tensor & _log10__cuda(Tensor & self);
Tensor & _log10_out_cpu(Tensor & result, const Tensor & self);
Tensor & _log10_out_cuda(Tensor & result, const Tensor & self);
Tensor log1p(const Tensor & self);
Tensor & _log1p__cpu(Tensor & self);
Tensor & _log1p__cuda(Tensor & self);
Tensor & log1p_sparse_(Tensor & self);
Tensor & _log1p_out_cpu(Tensor & result, const Tensor & self);
Tensor & _log1p_out_cuda(Tensor & result, const Tensor & self);
Tensor & log1p_out_sparse(Tensor & result, const Tensor & self);
Tensor log2(const Tensor & self);
Tensor & _log2__cpu(Tensor & self);
Tensor & _log2__cuda(Tensor & self);
Tensor & _log2_out_cpu(Tensor & result, const Tensor & self);
Tensor & _log2_out_cuda(Tensor & result, const Tensor & self);
Tensor logdet(const Tensor & self);
Tensor logspace(Scalar start, Scalar end, const TensorOptions & options={});
Tensor logspace(Scalar start, Scalar end, int64_t steps, const TensorOptions & options={});
Tensor & logspace_out(Tensor & result, Scalar start, Scalar end);
Tensor & logspace_out(Tensor & result, Scalar start, Scalar end, int64_t steps);
Tensor log_softmax_cpu(const Tensor & self, int64_t dim);
Tensor log_softmax_cuda(const Tensor & self, int64_t dim);
Tensor log_softmax_backward_cpu(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
Tensor log_softmax_backward_cuda(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
Tensor logsumexp(const Tensor & self, int64_t dim, bool keepdim=false);
Tensor & logsumexp_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false);
Tensor margin_ranking_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin=0.0, int64_t reduction=Reduction::ElementwiseMean);
Tensor matmul(const Tensor & self, const Tensor & other);
Tensor & matmul_out(Tensor & result, const Tensor & self, const Tensor & other);
std::tuple<Tensor,Tensor> max(const Tensor & self, int64_t dim, bool keepdim=false);
std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_values, const Tensor & self, int64_t dim, bool keepdim=false);
Tensor max_values(const Tensor & self, int64_t dim, bool keepdim=false);
std::tuple<Tensor,Tensor> max_pool1d_with_indices(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, IntList dilation=1, bool ceil_mode=false);
Tensor max_pool1d(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, IntList dilation=1, bool ceil_mode=false);
Tensor max_pool2d(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, IntList dilation=1, bool ceil_mode=false);
Tensor max_pool3d(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, IntList dilation=1, bool ceil_mode=false);
Tensor mean(const Tensor & self, ScalarType dtype);
Tensor mean(const Tensor & self);
Tensor mean(const Tensor & self, int64_t dim, bool keepdim, ScalarType dtype);
Tensor mean(const Tensor & self, int64_t dim, bool keepdim=false);
Tensor mean(const Tensor & self, int64_t dim, ScalarType dtype);
Tensor & mean_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim, ScalarType dtype);
Tensor & mean_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false);
Tensor & mean_out(Tensor & result, const Tensor & self, int64_t dim, ScalarType dtype);
std::tuple<Tensor,Tensor> median(const Tensor & self, int64_t dim, bool keepdim=false);
std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim=false);
std::tuple<Tensor,Tensor> min(const Tensor & self, int64_t dim, bool keepdim=false);
std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim=false);
Tensor min_values(const Tensor & self, int64_t dim, bool keepdim=false);
Tensor mkldnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntList padding, IntList stride, IntList dilation);
Tensor mkldnn_convolution_backward_input(IntList self_size, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, bool bias_defined);
std::tuple<Tensor,Tensor> mkldnn_convolution_backward_weights(IntList weight_size, const Tensor & grad_output, const Tensor & self, IntList padding, IntList stride, IntList dilation, bool bias_defined);
std::tuple<Tensor,Tensor,Tensor> mkldnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, std::array<bool,3> output_mask);
Tensor mm(const Tensor & self, const Tensor & mat2);
Tensor & mm_out(Tensor & result, const Tensor & self, const Tensor & mat2);
std::tuple<Tensor,Tensor> mode(const Tensor & self, int64_t dim=-1, bool keepdim=false);
std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool keepdim=false);
Tensor mv(const Tensor & self, const Tensor & vec);
Tensor & mv_out(Tensor & result, const Tensor & self, const Tensor & vec);
Tensor narrow(const Tensor & self, int64_t dim, int64_t start, int64_t length);
Tensor ones(IntList size, const TensorOptions & options={});
Tensor & ones_out(Tensor & result, IntList size);
Tensor ones_like(const Tensor & self);
Tensor ones_like(const Tensor & self, const TensorOptions & options);
Tensor pairwise_distance(const Tensor & x1, const Tensor & x2, double p=2, double eps=1e-06, bool keepdim=false);
Tensor permute(const Tensor & self, IntList dims);
Tensor pin_memory(const Tensor & self);
Tensor pinverse(const Tensor & self, double rcond=1e-15);
Tensor rand(IntList size, const TensorOptions & options={});
Tensor rand(IntList size, Generator * generator, const TensorOptions & options={});
Tensor & rand_out(Tensor & result, IntList size);
Tensor & rand_out(Tensor & result, IntList size, Generator * generator);
Tensor rand_like(const Tensor & self);
Tensor rand_like(const Tensor & self, const TensorOptions & options);
Tensor randint(int64_t high, IntList size, const TensorOptions & options={});
Tensor randint(int64_t high, IntList size, Generator * generator, const TensorOptions & options={});
Tensor randint(int64_t low, int64_t high, IntList size, const TensorOptions & options={});
Tensor randint(int64_t low, int64_t high, IntList size, Generator * generator, const TensorOptions & options={});
Tensor & randint_out(Tensor & result, int64_t high, IntList size);
Tensor & randint_out(Tensor & result, int64_t high, IntList size, Generator * generator);
Tensor & randint_out(Tensor & result, int64_t low, int64_t high, IntList size);
Tensor & randint_out(Tensor & result, int64_t low, int64_t high, IntList size, Generator * generator);
Tensor randint_like(const Tensor & self, int64_t high);
Tensor randint_like(const Tensor & self, int64_t low, int64_t high);
Tensor randint_like(const Tensor & self, int64_t high, const TensorOptions & options);
Tensor randint_like(const Tensor & self, int64_t low, int64_t high, const TensorOptions & options);
Tensor randn(IntList size, const TensorOptions & options={});
Tensor randn(IntList size, Generator * generator, const TensorOptions & options={});
Tensor & randn_out(Tensor & result, IntList size);
Tensor & randn_out(Tensor & result, IntList size, Generator * generator);
Tensor randn_like(const Tensor & self);
Tensor randn_like(const Tensor & self, const TensorOptions & options);
Tensor randperm(int64_t n, const TensorOptions & options={});
Tensor randperm(int64_t n, Generator * generator, const TensorOptions & options={});
Tensor & randperm_out(Tensor & result, int64_t n);
Tensor & randperm_out_cpu(Tensor & result, int64_t n, Generator * generator);
Tensor & randperm_out_cuda(Tensor & result, int64_t n, Generator * generator);
Tensor range(Scalar start, Scalar end, const TensorOptions & options={});
Tensor range(Scalar start, Scalar end, Scalar step, const TensorOptions & options={});
Tensor & range_out(Tensor & result, Scalar start, Scalar end);
Tensor & range_out(Tensor & result, Scalar start, Scalar end, Scalar step);
Tensor repeat(const Tensor & self, IntList repeats);
Tensor reshape(const Tensor & self, IntList shape);
std::tuple<Tensor,Tensor> RoiPooling2d_forward_cpu(const Tensor & input, const Tensor & rois, int64_t pooledHeight, int64_t pooledWidth, double spatialScale);
std::tuple<Tensor,Tensor> RoiPooling2d_forward_cuda(const Tensor & input, const Tensor & rois, int64_t pooledHeight, int64_t pooledWidth, double spatialScale);
Tensor RoiPooling2d_backward_cpu(const Tensor & input, const Tensor & rois, int64_t pooledHeight, int64_t pooledWidth, double spatialScale, const Tensor & gradOutput, const Tensor & argmaxes);
Tensor RoiPooling2d_backward_cuda(const Tensor & input, const Tensor & rois, int64_t pooledHeight, int64_t pooledWidth, double spatialScale, const Tensor & gradOutput, const Tensor & argmaxes);
Tensor round(const Tensor & self);
Tensor & _round__cpu(Tensor & self);
Tensor & _round__cuda(Tensor & self);
Tensor & _round_out_cpu(Tensor & result, const Tensor & self);
Tensor & _round_out_cuda(Tensor & result, const Tensor & self);
Tensor rrelu(const Tensor & self, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, Generator * generator=nullptr);
Tensor & rrelu_(Tensor & self, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, Generator * generator=nullptr);
Tensor relu(const Tensor & self);
Tensor & relu_(Tensor & self);
Tensor hardshrink_cpu(const Tensor & self, Scalar lambd=0.5);
Tensor hardshrink_cuda(const Tensor & self, Scalar lambd=0.5);
Tensor hardshrink_backward_cpu(const Tensor & grad_out, const Tensor & self, Scalar lambd);
Tensor hardshrink_backward_cuda(const Tensor & grad_out, const Tensor & self, Scalar lambd);
Tensor rsqrt(const Tensor & self);
Tensor & _rsqrt__cpu(Tensor & self);
Tensor & _rsqrt__cuda(Tensor & self);
Tensor & _rsqrt_out_cpu(Tensor & result, const Tensor & self);
Tensor & _rsqrt_out_cuda(Tensor & result, const Tensor & self);
Tensor select(const Tensor & self, int64_t dim, int64_t index);
Tensor selu(const Tensor & self);
Tensor & selu_(Tensor & self);
Tensor sin(const Tensor & self);
Tensor & _sin__cpu(Tensor & self);
Tensor & _sin__cuda(Tensor & self);
Tensor & _sin_out_cpu(Tensor & result, const Tensor & self);
Tensor & _sin_out_cuda(Tensor & result, const Tensor & self);
Tensor sinh(const Tensor & self);
Tensor & _sinh__cpu(Tensor & self);
Tensor & _sinh__cuda(Tensor & self);
Tensor & _sinh_out_cpu(Tensor & result, const Tensor & self);
Tensor & _sinh_out_cuda(Tensor & result, const Tensor & self);
int64_t size(const Tensor & self, int64_t dim);
Tensor slice(const Tensor & self, int64_t dim=0, int64_t start=0, int64_t end=9223372036854775807, int64_t step=1);
std::tuple<Tensor,Tensor> slogdet(const Tensor & self);
Tensor smm(const Tensor & self, const Tensor & mat2);
Tensor softmax_cpu(const Tensor & self, int64_t dim);
Tensor softmax_cuda(const Tensor & self, int64_t dim);
Tensor softmax_backward_cpu(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
Tensor softmax_backward_cuda(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
std::vector<Tensor> split(const Tensor & self, int64_t split_size, int64_t dim=0);
std::vector<Tensor> split_with_sizes(const Tensor & self, IntList split_sizes, int64_t dim=0);
Tensor squeeze(const Tensor & self);
Tensor squeeze(const Tensor & self, int64_t dim);
Tensor & squeeze_(Tensor & self);
Tensor & squeeze_(Tensor & self, int64_t dim);
Tensor sspaddmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor & _sspaddmm_out_only_sparse(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor & _sspaddmm_out_only_sparse_cuda(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor & _sspaddmm_out_cpu(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor & _sspaddmm_out_cuda(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor stack(TensorList tensors, int64_t dim=0);
Tensor & stack_out(Tensor & result, TensorList tensors, int64_t dim=0);
Tensor stft(const Tensor & self, int64_t frame_length, int64_t hop, int64_t fft_size, bool normalized=false, bool onesided=true, const Tensor & window={}, int64_t pad_end=0);
int64_t stride(const Tensor & self, int64_t dim);
Tensor sum(const Tensor & self, ScalarType dtype);
Tensor sum(const Tensor & self);
Tensor _sum_cpu(const Tensor & self);
Tensor _sum_cuda(const Tensor & self);
Tensor sum(const Tensor & self, IntList dim, bool keepdim, ScalarType dtype);
Tensor sum(const Tensor & self, IntList dim, bool keepdim=false);
Tensor sum(const Tensor & self, IntList dim, ScalarType dtype);
Tensor _sum(const Tensor & self, IntList dim, bool keepdim=false);
Tensor & sum_out(Tensor & result, const Tensor & self, IntList dim, bool keepdim, ScalarType dtype);
Tensor & sum_out(Tensor & result, const Tensor & self, IntList dim, bool keepdim=false);
Tensor & sum_out(Tensor & result, const Tensor & self, IntList dim, ScalarType dtype);
Tensor & _sum_out(Tensor & result, const Tensor & self, IntList dim, bool keepdim=false);
Tensor & _sum_out_cuda(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false);
Tensor sqrt(const Tensor & self);
Tensor & _sqrt__cpu(Tensor & self);
Tensor & _sqrt__cuda(Tensor & self);
Tensor & _sqrt_out_cpu(Tensor & result, const Tensor & self);
Tensor & _sqrt_out_cuda(Tensor & result, const Tensor & self);
Tensor std(const Tensor & self, int64_t dim, bool unbiased=true, bool keepdim=false);
Tensor & std_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased=true, bool keepdim=false);
Tensor prod(const Tensor & self, ScalarType dtype);
Tensor prod(const Tensor & self);
Tensor _prod_cpu(const Tensor & self);
Tensor _prod_cuda(const Tensor & self);
Tensor prod(const Tensor & self, int64_t dim, bool keepdim, ScalarType dtype);
Tensor prod(const Tensor & self, int64_t dim, bool keepdim=false);
Tensor prod(const Tensor & self, int64_t dim, ScalarType dtype);
Tensor _prod(const Tensor & self, int64_t dim, bool keepdim=false);
Tensor & prod_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim, ScalarType dtype);
Tensor & prod_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false);
Tensor & prod_out(Tensor & result, const Tensor & self, int64_t dim, ScalarType dtype);
Tensor & _prod_out_cpu(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false);
Tensor & _prod_out_cuda(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false);
Tensor t(const Tensor & self);
Tensor & t_(Tensor & self);
Tensor tan(const Tensor & self);
Tensor & _tan__cpu(Tensor & self);
Tensor & _tan__cuda(Tensor & self);
Tensor & _tan_out_cpu(Tensor & result, const Tensor & self);
Tensor & _tan_out_cuda(Tensor & result, const Tensor & self);
Tensor tanh(const Tensor & self);
Tensor & _tanh__cpu(Tensor & self);
Tensor & _tanh__cuda(Tensor & self);
Tensor & _tanh_out_cpu(Tensor & result, const Tensor & self);
Tensor & _tanh_out_cuda(Tensor & result, const Tensor & self);
Tensor transpose(const Tensor & self, int64_t dim0, int64_t dim1);
Tensor & transpose_(Tensor & self, int64_t dim0, int64_t dim1);
Tensor flip_cpu(const Tensor & self, IntList dims);
Tensor flip_cuda(const Tensor & self, IntList dims);
Tensor _trilinear(const Tensor & i1, const Tensor & i2, const Tensor & i3, IntList expand1, IntList expand2, IntList expand3, IntList sumdim, int64_t unroll_dim=1);
Tensor triplet_margin_loss(const Tensor & anchor, const Tensor & positive, const Tensor & negative, double margin=1.0, double p=2, double eps=1e-06, bool swap=false, int64_t reduction=Reduction::ElementwiseMean);
Tensor trunc(const Tensor & self);
Tensor & _trunc__cpu(Tensor & self);
Tensor & _trunc__cuda(Tensor & self);
Tensor & _trunc_out_cpu(Tensor & result, const Tensor & self);
Tensor & _trunc_out_cuda(Tensor & result, const Tensor & self);
Tensor type_as(const Tensor & self, const Tensor & other);
std::tuple<Tensor,Tensor> _unique_cpu(const Tensor & self, bool sorted=false, bool return_inverse=false);
std::tuple<Tensor,Tensor> _unique_cuda(const Tensor & self, bool sorted=false, bool return_inverse=false);
Tensor _unsafe_view(const Tensor & self, IntList size);
Tensor unsqueeze(const Tensor & self, int64_t dim);
Tensor & unsqueeze_(Tensor & self, int64_t dim);
Tensor var(const Tensor & self, int64_t dim, bool unbiased=true, bool keepdim=false);
Tensor & var_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased=true, bool keepdim=false);
Tensor view_as(const Tensor & self, const Tensor & other);
Tensor where(const Tensor & condition, const Tensor & self, const Tensor & other);
Tensor _s_where_cpu(const Tensor & condition, const Tensor & self, const Tensor & other);
Tensor _s_where_cuda(const Tensor & condition, const Tensor & self, const Tensor & other);
Tensor zeros(IntList size, const TensorOptions & options={});
Tensor & zeros_out(Tensor & result, IntList size);
Tensor zeros_like(const Tensor & self);
Tensor zeros_like(const Tensor & self, const TensorOptions & options);
Tensor _standard_gamma_grad_cpu(const Tensor & self, const Tensor & output);
Tensor _standard_gamma_grad_cuda(const Tensor & self, const Tensor & output);
Tensor _s_gamma_cpu(const Tensor & self, Generator * generator=nullptr);
Tensor _s_gamma_cuda(const Tensor & self, Generator * generator=nullptr);
Tensor _s_poisson_cpu(const Tensor & self, Generator * generator=nullptr);
Tensor _s_poisson_cuda(const Tensor & self, Generator * generator=nullptr);
Tensor norm_sparse(const Tensor & self, Scalar p=2);
Tensor norm(const Tensor & self, Scalar p=2);
Tensor norm(const Tensor & self, Scalar p, int64_t dim, bool keepdim=false);
Tensor & norm_out(Tensor & result, const Tensor & self, Scalar p, int64_t dim, bool keepdim=false);
Tensor clone_sparse(const Tensor & self);
Tensor clone(const Tensor & self);
Tensor & resize_as_sparse_(Tensor & self, const Tensor & the_template);
Tensor & resize_as_(Tensor & self, const Tensor & the_template);
Tensor & pow_out_sparse_scalar(Tensor & result, const Tensor & self, Scalar exponent);
Tensor pow_sparse_scalar(const Tensor & self, Scalar exponent);
Tensor & pow_out(Tensor & result, const Tensor & self, Scalar exponent);
Tensor pow(const Tensor & self, Scalar exponent);
Tensor & zero_sparse_(Tensor & self);
Tensor & zero_(Tensor & self);
Tensor & s_add_out_sparse_cpu(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor & s_add_out_sparse_cuda(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor & add_out_dense_sparse_cpu(Tensor & result, const Tensor & self, SparseTensorRef other, Scalar alpha=1);
Tensor & add_out_dense_sparse_cuda(Tensor & result, const Tensor & self, SparseTensorRef other, Scalar alpha=1);
Tensor s_add_sparse_cpu(const Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor s_add_sparse_cuda(const Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor add_dense_sparse_cpu(const Tensor & self, SparseTensorRef other, Scalar alpha=1);
Tensor add_dense_sparse_cuda(const Tensor & self, SparseTensorRef other, Scalar alpha=1);
Tensor & s_add_sparse_cpu_(Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor & s_add_sparse_cuda_(Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor & add_dense_sparse_cpu_(Tensor & self, SparseTensorRef other, Scalar alpha=1);
Tensor & add_dense_sparse_cuda_(Tensor & self, SparseTensorRef other, Scalar alpha=1);
Tensor & add_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor add(const Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor & add_(Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor & s_sub_out_sparse_cpu(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor & s_sub_out_sparse_cuda(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor s_sub_sparse_cpu(const Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor s_sub_sparse_cuda(const Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor & s_sub_sparse_cpu_(Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor & s_sub_sparse_cuda_(Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor & sub_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor sub(const Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor & sub_(Tensor & self, const Tensor & other, Scalar alpha=1);
Tensor & s_mul_out_sparse_cpu(Tensor & result, const Tensor & self, const Tensor & other);
Tensor & s_mul_out_sparse_cuda(Tensor & result, const Tensor & self, const Tensor & other);
Tensor s_mul_sparse_cpu(const Tensor & self, const Tensor & other);
Tensor s_mul_sparse_cuda(const Tensor & self, const Tensor & other);
Tensor & s_mul_sparse_cpu_(Tensor & self, const Tensor & other);
Tensor & s_mul_sparse_cuda_(Tensor & self, const Tensor & other);
Tensor & mul_out_sparse_scalar(Tensor & result, const Tensor & self, Scalar other);
Tensor mul_sparse_scalar(const Tensor & self, Scalar other);
Tensor & mul_sparse_scalar_(Tensor & self, Scalar other);
Tensor & mul_out(Tensor & result, const Tensor & self, const Tensor & other);
Tensor & mul_out(Tensor & result, const Tensor & self, Scalar other);
Tensor mul(const Tensor & self, const Tensor & other);
Tensor mul(const Tensor & self, Scalar other);
Tensor & mul_(Tensor & self, const Tensor & other);
Tensor & mul_(Tensor & self, Scalar other);
Tensor & div_out_sparse_scalar(Tensor & result, const Tensor & self, Scalar other);
Tensor div_sparse_scalar(const Tensor & self, Scalar other);
Tensor & div_sparse_scalar_(Tensor & self, Scalar other);
Tensor & div_out(Tensor & result, const Tensor & self, Scalar other);
Tensor div(const Tensor & self, Scalar other);
Tensor & div_(Tensor & self, Scalar other);
Tensor & s_addmm_out_sparse_dense_cpu(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor & s_addmm_out_sparse_dense_cuda(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor s_addmm_sparse_dense_cpu(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor s_addmm_sparse_dense_cuda(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor & s_addmm_sparse_dense_cpu_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor & s_addmm_sparse_dense_cuda_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor & addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor & addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
Tensor new_sparse(const Type & self_ty);
Tensor new_with_size_sparse(const Type & self_ty, IntList size);
Tensor tensor(const Type & dtype);
Tensor tensor(const Type & dtype, IntList size);
Tensor new_with_tensor_sparse(const Tensor & indices, const Tensor & values);
Tensor new_with_tensor_and_size_sparse(const Tensor & indices, const Tensor & values, IntList size);
Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values);
Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, IntList size);
Tensor new_with_tensor_and_size_unsafe_sparse(const Tensor & indices, const Tensor & values, IntList size);
Tensor _sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntList size);
Tensor & raw_resize_sparse_(Tensor & self, IntList size, int64_t sparseDims, int64_t denseDims);
Tensor sparse_mask_cpu(const Tensor & self, SparseTensorRef mask);
Tensor sparse_mask_cuda(const Tensor & self, SparseTensorRef mask);
Tensor sparse_to_dense(const Tensor & self);
int64_t _sparseDims_sparse(const Tensor & self);
int64_t _sparseDims_sparse(const Tensor & self);
int64_t _denseDims_sparse(const Tensor & self);
int64_t _denseDims_sparse(const Tensor & self);
int64_t _nnz_sparse(const Tensor & self);
Tensor coalesce_sparse_cpu(const Tensor & self);
Tensor coalesce_sparse_cuda(const Tensor & self);
bool is_coalesced_sparse(const Tensor & self);
Tensor _indices_sparse(const Tensor & self);
Tensor _values_sparse(const Tensor & self);
Tensor & hspmm_out_sparse_cpu(Tensor & result, const Tensor & mat1, const Tensor & mat2);
Tensor & hspmm_out_sparse_cuda(Tensor & result, const Tensor & mat1, const Tensor & mat2);
Tensor hspmm_sparse_cpu(const Tensor & mat1, const Tensor & mat2);
Tensor hspmm_sparse_cuda(const Tensor & mat1, const Tensor & mat2);
Tensor & copy_sparse_(Tensor & self, const Tensor & src);
int64_t numel(const Tensor & self);
std::vector<Tensor> unbind(const Tensor & self, int64_t dim=0);
int64_t get_device_sparse_cuda(const Tensor & self);
int64_t get_device(const Tensor & self);
std::vector<Tensor> meshgrid(TensorList tensors);

} // namespace native
} // namespace at
