#pragma once

// @generated by aten/src/ATen/gen.py

#include "ATen/Allocator.h"
#include "ATen/ArrayRef.h"
#include "ATen/ATenGeneral.h"
#include "ATen/Generator.h"
#include "ATen/Half.h"
#include "ATen/Scalar.h"
#include "ATen/ScalarType.h"
#include "ATen/SparseTensorRef.h"
#include "ATen/Tensor.h"
#include "ATen/Deprecated.h"
#include "ATen/Layout.h"
#include "THNN/Reduction.h"

#include <array>
#include <cstddef>
#include <functional>
#include <limits>
#include <memory>

// To solve the conflict of s_addr in inaddr.h
#ifdef _MSC_VER
#ifdef s_addr
#undef s_addr
#endif
#endif

namespace at {

class Context;
struct Allocator;
struct Generator;
struct Storage;

static inline void noop_deleter(void*) {}

enum class TypeID {
  CPUByte,
  CPUChar,
  CPUDouble,
  CPUFloat,
  CPUInt,
  CPULong,
  CPUShort,
  CPUHalf,
  SparseCPUByte,
  SparseCPUChar,
  SparseCPUDouble,
  SparseCPUFloat,
  SparseCPUInt,
  SparseCPULong,
  SparseCPUShort,
  CUDAByte,
  CUDAChar,
  CUDADouble,
  CUDAFloat,
  CUDAInt,
  CUDALong,
  CUDAShort,
  CUDAHalf,
  SparseCUDAByte,
  SparseCUDAChar,
  SparseCUDADouble,
  SparseCUDAFloat,
  SparseCUDAInt,
  SparseCUDALong,
  SparseCUDAShort,
  Undefined,
  NumOptions
};

struct AT_API Type {
  explicit Type(Context* context, bool is_variable, bool is_undefined)
      : context(context), is_variable_(is_variable), is_undefined_(is_undefined) {}
  virtual ~Type() {}
  virtual ScalarType scalarType() const = 0;
  virtual Backend backend() const = 0;
  Layout layout() const noexcept { return layout_from_backend(backend()); }
  virtual bool is_cuda() const = 0;
  virtual bool is_sparse() const = 0;
  virtual bool is_distributed() const = 0;
  bool is_variable() const noexcept { return is_variable_; }
  bool is_undefined() const noexcept { return is_undefined_; }
  static void registerCPU(Context * context);
  virtual std::unique_ptr<Storage> storage() const = 0;
  virtual std::unique_ptr<Storage> storage(size_t size) const = 0;
  virtual std::unique_ptr<Storage> storageFromBlob(void * data, int64_t size, const std::function<void(void*)> & deleter=noop_deleter) const = 0;
  virtual std::unique_ptr<Storage> storageWithAllocator(int64_t size, Allocator* allocator) const = 0;
  virtual std::unique_ptr<Generator> generator() const = 0;
  virtual Tensor unsafeTensorFromTH(void * th_pointer, bool retain) const = 0;
  virtual std::unique_ptr<Storage> unsafeStorageFromTH(void * th_pointer, bool retain) const = 0;
  virtual const char * toString() const = 0;
  virtual size_t elementSizeInBytes() const = 0;
  virtual Type & toBackend(Backend b) const;
  virtual Type & toScalarType(ScalarType s) const;
  Type & toSparse() const {
    return this->toBackend(at::toSparse(this->backend()));
  }
  Type & toDense() const {
    return this->toBackend(at::toDense(this->backend()));
  }
  Context& get_context() const { return *context; }

  // contingious IDs for all types in the system
  // for external dispatch
  virtual TypeID ID() const = 0;

  Tensor copy(const Tensor & src, bool non_blocking=false) const;
  Tensor & copy_(Tensor & self, const Tensor & src, bool non_blocking=false) const;
  virtual Tensor & s_copy_(Tensor & self, const Tensor & src, bool non_blocking) const = 0;
  virtual Tensor & _s_copy_from(const Tensor & self, Tensor & dst, bool non_blocking) const = 0;

  Tensor tensorFromBlob(void * data, IntList sizes, const std::function<void(void*)> & deleter=noop_deleter) const;
  Tensor tensorFromBlob(void * data, IntList sizes, IntList strides, const std::function<void(void*)> & deleter=noop_deleter) const;
  Tensor tensorWithAllocator(IntList sizes, Allocator* allocator) const;
  Tensor tensorWithAllocator(IntList sizes, IntList strides, Allocator* allocator) const;
  Tensor scalarTensor(Scalar s) const;

  bool operator==(const Type& other) const;
  bool operator!=(const Type& other) const;

  // example
  // virtual Tensor * add(Tensor & a, Tensor & b) = 0;
  virtual int64_t storage_offset(const Tensor & self) const;
  virtual Tensor & resize_(Tensor & self, IntList size) const;
  virtual Tensor & set_(Tensor & self, Storage & source) const;
  virtual Tensor & set_(Tensor & self, Storage & source, int64_t storage_offset, IntList size, IntList stride={}) const;
  virtual Tensor & set_(Tensor & self, const Tensor & source) const;
  virtual Tensor & set_(Tensor & self) const;
  virtual Tensor & _fill_(Tensor & self, Scalar value) const;
  virtual Tensor & _fill_(Tensor & self, const Tensor & value) const;
  virtual bool is_contiguous(const Tensor & self) const;
  virtual bool is_set_to(const Tensor & self, const Tensor & tensor) const;
  Tensor & masked_fill_(Tensor & self, const Tensor & mask, Scalar value) const;
  virtual Tensor & s_masked_fill_(Tensor & self, const Tensor & mask, Scalar value) const;
  Tensor & masked_fill_(Tensor & self, const Tensor & mask, const Tensor & value) const;
  virtual Tensor & s_masked_fill_(Tensor & self, const Tensor & mask, const Tensor & value) const;
  Tensor & masked_scatter_(Tensor & self, const Tensor & mask, const Tensor & source) const;
  virtual Tensor & s_masked_scatter_(Tensor & self, const Tensor & mask, const Tensor & source) const;
  Tensor & masked_select_out(Tensor & result, const Tensor & self, const Tensor & mask) const;
  virtual Tensor & s_masked_select_out(Tensor & result, const Tensor & self, const Tensor & mask) const;
  Tensor masked_select(const Tensor & self, const Tensor & mask) const;
  virtual Tensor s_masked_select(const Tensor & self, const Tensor & mask) const;
  virtual Tensor & nonzero_out(Tensor & result, const Tensor & self) const;
  virtual Tensor nonzero(const Tensor & self) const;
  virtual Tensor contiguous(const Tensor & self) const;
  virtual Tensor th_clone(const Tensor & self) const;
  virtual Tensor view(const Tensor & self, IntList size) const;
  virtual Tensor & th_resize_as_(Tensor & self, const Tensor & the_template) const;
  virtual Tensor & index_select_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const;
  virtual Tensor index_select(const Tensor & self, int64_t dim, const Tensor & index) const;
  virtual Tensor & _indexCopy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const;
  virtual Tensor & take_out(Tensor & result, const Tensor & self, const Tensor & index) const;
  virtual Tensor take(const Tensor & self, const Tensor & index) const;
  virtual Tensor & put_(Tensor & self, const Tensor & index, const Tensor & source, bool accumulate=false) const;
  virtual Tensor & index_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const;
  virtual Tensor & index_fill_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const;
  virtual Tensor & index_fill_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & value) const;
  virtual Tensor unfold(const Tensor & self, int64_t dimension, int64_t size, int64_t step) const;
  virtual Tensor & _range_out(Tensor & result, Scalar start, Scalar end, Scalar step=1) const;
  virtual Tensor _range(Scalar start, Scalar end, Scalar step=1) const;
  virtual Tensor & _arange_out(Tensor & result, Scalar start, Scalar end, Scalar step=1) const;
  virtual Tensor _arange(Scalar start, Scalar end, Scalar step=1) const;
  virtual Tensor & _arange_out(Tensor & result, Scalar end) const;
  virtual Tensor _arange(Scalar end) const;
  virtual Tensor & scatter_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const;
  virtual Tensor & scatter_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const;
  virtual Tensor & scatter_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const;
  virtual Tensor & gather_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const;
  virtual Tensor gather(const Tensor & self, int64_t dim, const Tensor & index) const;
  virtual void* data_ptr(const Tensor & self) const;
  virtual bool equal(const Tensor & self, const Tensor & other) const;
  virtual Tensor & __and___out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor __and__(const Tensor & self, Scalar other) const;
  Tensor & __and___out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s___and___out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor __and__(const Tensor & self, const Tensor & other) const;
  virtual Tensor s___and__(const Tensor & self, const Tensor & other) const;
  virtual Tensor & __iand__(Tensor & self, Scalar other) const;
  Tensor & __iand__(Tensor & self, const Tensor & other) const;
  virtual Tensor & s___iand__(Tensor & self, const Tensor & other) const;
  virtual Tensor & __or___out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor __or__(const Tensor & self, Scalar other) const;
  Tensor & __or___out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s___or___out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor __or__(const Tensor & self, const Tensor & other) const;
  virtual Tensor s___or__(const Tensor & self, const Tensor & other) const;
  virtual Tensor & __ior__(Tensor & self, Scalar other) const;
  Tensor & __ior__(Tensor & self, const Tensor & other) const;
  virtual Tensor & s___ior__(Tensor & self, const Tensor & other) const;
  virtual Tensor & __xor___out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor __xor__(const Tensor & self, Scalar other) const;
  Tensor & __xor___out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s___xor___out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor __xor__(const Tensor & self, const Tensor & other) const;
  virtual Tensor s___xor__(const Tensor & self, const Tensor & other) const;
  virtual Tensor & __ixor__(Tensor & self, Scalar other) const;
  Tensor & __ixor__(Tensor & self, const Tensor & other) const;
  virtual Tensor & s___ixor__(Tensor & self, const Tensor & other) const;
  virtual Tensor & __lshift___out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor __lshift__(const Tensor & self, Scalar other) const;
  Tensor & __lshift___out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s___lshift___out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor __lshift__(const Tensor & self, const Tensor & other) const;
  virtual Tensor s___lshift__(const Tensor & self, const Tensor & other) const;
  virtual Tensor & __ilshift__(Tensor & self, Scalar other) const;
  Tensor & __ilshift__(Tensor & self, const Tensor & other) const;
  virtual Tensor & s___ilshift__(Tensor & self, const Tensor & other) const;
  virtual Tensor & __rshift___out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor __rshift__(const Tensor & self, Scalar other) const;
  Tensor & __rshift___out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s___rshift___out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor __rshift__(const Tensor & self, const Tensor & other) const;
  virtual Tensor s___rshift__(const Tensor & self, const Tensor & other) const;
  virtual Tensor & __irshift__(Tensor & self, Scalar other) const;
  Tensor & __irshift__(Tensor & self, const Tensor & other) const;
  virtual Tensor & s___irshift__(Tensor & self, const Tensor & other) const;
  virtual Tensor & lt_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor lt(const Tensor & self, Scalar other) const;
  Tensor & lt_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_lt_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor lt(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_lt(const Tensor & self, const Tensor & other) const;
  virtual Tensor & lt_(Tensor & self, Scalar other) const;
  Tensor & lt_(Tensor & self, const Tensor & other) const;
  virtual Tensor & s_lt_(Tensor & self, const Tensor & other) const;
  virtual Tensor & gt_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor gt(const Tensor & self, Scalar other) const;
  Tensor & gt_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_gt_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor gt(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_gt(const Tensor & self, const Tensor & other) const;
  virtual Tensor & gt_(Tensor & self, Scalar other) const;
  Tensor & gt_(Tensor & self, const Tensor & other) const;
  virtual Tensor & s_gt_(Tensor & self, const Tensor & other) const;
  virtual Tensor & le_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor le(const Tensor & self, Scalar other) const;
  Tensor & le_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_le_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor le(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_le(const Tensor & self, const Tensor & other) const;
  virtual Tensor & le_(Tensor & self, Scalar other) const;
  Tensor & le_(Tensor & self, const Tensor & other) const;
  virtual Tensor & s_le_(Tensor & self, const Tensor & other) const;
  virtual Tensor & ge_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor ge(const Tensor & self, Scalar other) const;
  Tensor & ge_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_ge_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor ge(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_ge(const Tensor & self, const Tensor & other) const;
  virtual Tensor & ge_(Tensor & self, Scalar other) const;
  Tensor & ge_(Tensor & self, const Tensor & other) const;
  virtual Tensor & s_ge_(Tensor & self, const Tensor & other) const;
  virtual Tensor & eq_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor eq(const Tensor & self, Scalar other) const;
  Tensor & eq_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_eq_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor eq(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_eq(const Tensor & self, const Tensor & other) const;
  virtual Tensor & eq_(Tensor & self, Scalar other) const;
  Tensor & eq_(Tensor & self, const Tensor & other) const;
  virtual Tensor & s_eq_(Tensor & self, const Tensor & other) const;
  virtual Tensor & ne_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor ne(const Tensor & self, Scalar other) const;
  Tensor & ne_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_ne_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor ne(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_ne(const Tensor & self, const Tensor & other) const;
  virtual Tensor & ne_(Tensor & self, Scalar other) const;
  Tensor & ne_(Tensor & self, const Tensor & other) const;
  virtual Tensor & s_ne_(Tensor & self, const Tensor & other) const;
  Tensor & min_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_min_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor min(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_min(const Tensor & self, const Tensor & other) const;
  virtual Tensor min(const Tensor & self) const;
  virtual std::tuple<Tensor &,Tensor &> _th_min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual std::tuple<Tensor,Tensor> _th_min(const Tensor & self, int64_t dim, bool keepdim=false) const;
  Tensor & max_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_max_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor max(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_max(const Tensor & self, const Tensor & other) const;
  virtual Tensor max(const Tensor & self) const;
  virtual std::tuple<Tensor &,Tensor &> _th_max_out(Tensor & max, Tensor & max_indices, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual std::tuple<Tensor,Tensor> _th_max(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual std::tuple<Tensor &,Tensor &> _th_kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false) const;
  virtual std::tuple<Tensor,Tensor> _th_kthvalue(const Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false) const;
  virtual std::tuple<Tensor &,Tensor &> _th_mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool keepdim=false) const;
  virtual std::tuple<Tensor,Tensor> _th_mode(const Tensor & self, int64_t dim=-1, bool keepdim=false) const;
  virtual Tensor median(const Tensor & self) const;
  virtual std::tuple<Tensor &,Tensor &> _th_median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual std::tuple<Tensor,Tensor> _th_median(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool descending=false) const;
  virtual std::tuple<Tensor,Tensor> sort(const Tensor & self, int64_t dim=-1, bool descending=false) const;
  virtual std::tuple<Tensor &,Tensor &> topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim=-1, bool largest=true, bool sorted=true) const;
  virtual std::tuple<Tensor,Tensor> topk(const Tensor & self, int64_t k, int64_t dim=-1, bool largest=true, bool sorted=true) const;
  virtual Tensor all(const Tensor & self) const;
  virtual Tensor & _th_all_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor _th_all(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor any(const Tensor & self) const;
  virtual Tensor & _th_any_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor _th_any(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual int64_t _th_get_device(const Tensor & self) const;
  virtual Tensor & _abs_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _abs(const Tensor & self) const;
  virtual Tensor & sigmoid_(Tensor & self) const;
  virtual Tensor & sigmoid_out(Tensor & result, const Tensor & self) const;
  virtual Tensor sigmoid(const Tensor & self) const;
  virtual Tensor & _log_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _log(const Tensor & self) const;
  virtual Tensor & _log10_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _log10(const Tensor & self) const;
  virtual Tensor & _log1p_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _log1p(const Tensor & self) const;
  virtual Tensor & _log2_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _log2(const Tensor & self) const;
  virtual Tensor & lgamma_out(Tensor & result, const Tensor & self) const;
  virtual Tensor lgamma(const Tensor & self) const;
  virtual Tensor & lgamma_(Tensor & self) const;
  virtual Tensor & digamma_out(Tensor & result, const Tensor & self) const;
  virtual Tensor digamma(const Tensor & self) const;
  virtual Tensor & digamma_(Tensor & self) const;
  virtual Tensor & polygamma_out(Tensor & result, int64_t n, const Tensor & self) const;
  virtual Tensor polygamma(int64_t n, const Tensor & self) const;
  virtual Tensor & polygamma_(Tensor & self, int64_t n) const;
  virtual Tensor & _exp_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _exp(const Tensor & self) const;
  virtual Tensor & _expm1_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _expm1(const Tensor & self) const;
  virtual Tensor & _cos_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _cos(const Tensor & self) const;
  virtual Tensor & _acos_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _acos(const Tensor & self) const;
  virtual Tensor & _cosh_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _cosh(const Tensor & self) const;
  virtual Tensor & _sin_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _sin(const Tensor & self) const;
  virtual Tensor & _asin_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _asin(const Tensor & self) const;
  virtual Tensor & _sinh_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _sinh(const Tensor & self) const;
  virtual Tensor & _tan_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _tan(const Tensor & self) const;
  virtual Tensor & _atan_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _atan(const Tensor & self) const;
  virtual Tensor & _th_tanh_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _th_tanh(const Tensor & self) const;
  virtual Tensor & _erf_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _erf(const Tensor & self) const;
  virtual Tensor & erfinv_(Tensor & self) const;
  virtual Tensor & erfinv_out(Tensor & result, const Tensor & self) const;
  virtual Tensor erfinv(const Tensor & self) const;
  virtual Tensor & _sqrt_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _sqrt(const Tensor & self) const;
  virtual Tensor & _rsqrt_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _rsqrt(const Tensor & self) const;
  virtual Tensor & _ceil_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _ceil(const Tensor & self) const;
  virtual Tensor & _floor_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _floor(const Tensor & self) const;
  virtual Tensor & _round_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _round(const Tensor & self) const;
  virtual Tensor & _trunc_out(Tensor & result, const Tensor & self) const;
  virtual Tensor _trunc(const Tensor & self) const;
  virtual Tensor & frac_(Tensor & self) const;
  virtual Tensor & frac_out(Tensor & result, const Tensor & self) const;
  virtual Tensor frac(const Tensor & self) const;
  virtual Tensor var(const Tensor & self, bool unbiased=true) const;
  virtual Tensor & _th_var_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased=true, bool keepdim=false) const;
  virtual Tensor _th_var(const Tensor & self, int64_t dim, bool unbiased=true, bool keepdim=false) const;
  virtual Tensor std(const Tensor & self, bool unbiased=true) const;
  virtual Tensor & _th_std_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased=true, bool keepdim=false) const;
  virtual Tensor _th_std(const Tensor & self, int64_t dim, bool unbiased=true, bool keepdim=false) const;
  virtual Tensor th_norm(const Tensor & self, Scalar p=2) const;
  virtual Tensor & _th_norm_out(Tensor & result, const Tensor & self, Scalar p, int64_t dim, bool keepdim=false) const;
  virtual Tensor _th_norm(const Tensor & self, Scalar p, int64_t dim, bool keepdim=false) const;
  virtual Tensor & renorm_out(Tensor & result, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const;
  virtual Tensor renorm(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const;
  virtual Tensor & renorm_(Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const;
  Tensor dist(const Tensor & self, const Tensor & other, Scalar p=2) const;
  virtual Tensor s_dist(const Tensor & self, const Tensor & other, Scalar p=2) const;
  virtual Tensor & reciprocal_out(Tensor & result, const Tensor & self) const;
  virtual Tensor reciprocal(const Tensor & self) const;
  virtual Tensor & reciprocal_(Tensor & self) const;
  virtual Tensor & neg_out(Tensor & result, const Tensor & self) const;
  virtual Tensor neg(const Tensor & self) const;
  virtual Tensor & neg_(Tensor & self) const;
  Tensor & atan2_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_atan2_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor atan2(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_atan2(const Tensor & self, const Tensor & other) const;
  Tensor & atan2_(Tensor & self, const Tensor & other) const;
  virtual Tensor & s_atan2_(Tensor & self, const Tensor & other) const;
  virtual Tensor & th_pow_out(Tensor & result, const Tensor & self, Scalar exponent) const;
  virtual Tensor th_pow(const Tensor & self, Scalar exponent) const;
  Tensor & pow_out(Tensor & result, const Tensor & self, const Tensor & exponent) const;
  virtual Tensor & s_pow_out(Tensor & result, const Tensor & self, const Tensor & exponent) const;
  Tensor pow(const Tensor & self, const Tensor & exponent) const;
  virtual Tensor s_pow(const Tensor & self, const Tensor & exponent) const;
  virtual Tensor & pow_out(Tensor & result, Scalar base, const Tensor & self) const;
  virtual Tensor pow(Scalar base, const Tensor & self) const;
  virtual Tensor & pow_(Tensor & self, Scalar exponent) const;
  Tensor & pow_(Tensor & self, const Tensor & exponent) const;
  virtual Tensor & s_pow_(Tensor & self, const Tensor & exponent) const;
  Tensor & lerp_out(Tensor & result, const Tensor & self, const Tensor & end, Scalar weight) const;
  virtual Tensor & s_lerp_out(Tensor & result, const Tensor & self, const Tensor & end, Scalar weight) const;
  Tensor lerp(const Tensor & self, const Tensor & end, Scalar weight) const;
  virtual Tensor s_lerp(const Tensor & self, const Tensor & end, Scalar weight) const;
  Tensor & lerp_(Tensor & self, const Tensor & end, Scalar weight) const;
  virtual Tensor & s_lerp_(Tensor & self, const Tensor & end, Scalar weight) const;
  virtual Tensor & _linspace_out(Tensor & result, Scalar start, Scalar end, int64_t steps=100) const;
  virtual Tensor _linspace(Scalar start, Scalar end, int64_t steps=100) const;
  virtual Tensor & _logspace_out(Tensor & result, Scalar start, Scalar end, int64_t steps=100) const;
  virtual Tensor _logspace(Scalar start, Scalar end, int64_t steps=100) const;
  virtual Tensor & histc_out(Tensor & result, const Tensor & self, int64_t bins=100, Scalar min=0, Scalar max=0) const;
  virtual Tensor histc(const Tensor & self, int64_t bins=100, Scalar min=0, Scalar max=0) const;
  virtual Tensor & th_zero_(Tensor & self) const;
  virtual Tensor _sumall(const Tensor & self) const;
  virtual Tensor & _th_sum_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor _th_sum(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor _prodall(const Tensor & self) const;
  virtual Tensor & _th_prod_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor _th_prod(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor & _cumsum_out(Tensor & result, const Tensor & self, int64_t dim) const;
  virtual Tensor _cumsum(const Tensor & self, int64_t dim) const;
  virtual Tensor & _cumprod_out(Tensor & result, const Tensor & self, int64_t dim) const;
  virtual Tensor _cumprod(const Tensor & self, int64_t dim) const;
  virtual Tensor & sign_out(Tensor & result, const Tensor & self) const;
  virtual Tensor sign(const Tensor & self) const;
  virtual Tensor & sign_(Tensor & self) const;
  virtual Tensor trace(const Tensor & self) const;
  Tensor & th_add_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & s_th_add_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  Tensor th_add(const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor s_th_add(const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & add_out(Tensor & result, const Tensor & self, Scalar other, Scalar alpha=1) const;
  virtual Tensor add(const Tensor & self, Scalar other, Scalar alpha=1) const;
  Tensor & th_add_(Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & s_th_add_(Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & add_(Tensor & self, Scalar other, Scalar alpha=1) const;
  Tensor & th_sub_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & s_th_sub_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  Tensor th_sub(const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor s_th_sub(const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & sub_out(Tensor & result, const Tensor & self, Scalar other, Scalar alpha=1) const;
  virtual Tensor sub(const Tensor & self, Scalar other, Scalar alpha=1) const;
  Tensor & th_sub_(Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & s_th_sub_(Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & sub_(Tensor & self, Scalar other, Scalar alpha=1) const;
  virtual Tensor & th_mul_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor th_mul(const Tensor & self, Scalar other) const;
  Tensor & th_mul_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_th_mul_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor th_mul(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_th_mul(const Tensor & self, const Tensor & other) const;
  virtual Tensor & th_mul_(Tensor & self, Scalar other) const;
  Tensor & th_mul_(Tensor & self, const Tensor & other) const;
  virtual Tensor & s_th_mul_(Tensor & self, const Tensor & other) const;
  virtual Tensor & th_div_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor th_div(const Tensor & self, Scalar other) const;
  Tensor & div_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_div_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor div(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_div(const Tensor & self, const Tensor & other) const;
  virtual Tensor & th_div_(Tensor & self, Scalar other) const;
  Tensor & div_(Tensor & self, const Tensor & other) const;
  virtual Tensor & s_div_(Tensor & self, const Tensor & other) const;
  virtual Tensor & fmod_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor fmod(const Tensor & self, Scalar other) const;
  Tensor & fmod_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_fmod_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor fmod(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_fmod(const Tensor & self, const Tensor & other) const;
  virtual Tensor & fmod_(Tensor & self, Scalar other) const;
  Tensor & fmod_(Tensor & self, const Tensor & other) const;
  virtual Tensor & s_fmod_(Tensor & self, const Tensor & other) const;
  virtual Tensor & remainder_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor remainder(const Tensor & self, Scalar other) const;
  Tensor & remainder_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_remainder_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  Tensor remainder(const Tensor & self, const Tensor & other) const;
  virtual Tensor s_remainder(const Tensor & self, const Tensor & other) const;
  virtual Tensor & remainder_(Tensor & self, Scalar other) const;
  Tensor & remainder_(Tensor & self, const Tensor & other) const;
  virtual Tensor & s_remainder_(Tensor & self, const Tensor & other) const;
  virtual Tensor & clamp_out(Tensor & result, const Tensor & self, Scalar min, Scalar max) const;
  virtual Tensor clamp(const Tensor & self, Scalar min, Scalar max) const;
  virtual Tensor & clamp_(Tensor & self, Scalar min, Scalar max) const;
  virtual Tensor & clamp_min_out(Tensor & result, const Tensor & self, Scalar min) const;
  virtual Tensor clamp_min(const Tensor & self, Scalar min) const;
  virtual Tensor & clamp_min_(Tensor & self, Scalar min) const;
  virtual Tensor & clamp_max_out(Tensor & result, const Tensor & self, Scalar max) const;
  virtual Tensor clamp_max(const Tensor & self, Scalar max) const;
  virtual Tensor & clamp_max_(Tensor & self, Scalar max) const;
  virtual Tensor _dot(const Tensor & self, const Tensor & tensor) const;
  virtual Tensor & tril_out(Tensor & result, const Tensor & self, int64_t diagonal=0) const;
  virtual Tensor tril(const Tensor & self, int64_t diagonal=0) const;
  virtual Tensor & tril_(Tensor & self, int64_t diagonal=0) const;
  virtual Tensor & triu_out(Tensor & result, const Tensor & self, int64_t diagonal=0) const;
  virtual Tensor triu(const Tensor & self, int64_t diagonal=0) const;
  virtual Tensor & triu_(Tensor & self, int64_t diagonal=0) const;
  virtual Tensor & cross_out(Tensor & result, const Tensor & self, const Tensor & other, int64_t dim=-1) const;
  virtual Tensor cross(const Tensor & self, const Tensor & other, int64_t dim=-1) const;
  virtual Tensor & diag_out(Tensor & result, const Tensor & self, int64_t diagonal=0) const;
  virtual Tensor diag(const Tensor & self, int64_t diagonal=0) const;
  Tensor & th_addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & s_th_addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  Tensor th_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor s_th_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & th_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  Tensor & _addmv_out(Tensor & result, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & s__addmv_out(Tensor & result, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1) const;
  Tensor _addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor s__addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & _addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1) const;
  Tensor & _addr_out(Tensor & result, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & s__addr_out(Tensor & result, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1) const;
  Tensor _addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor s__addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & _addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & _ger_out(Tensor & result, const Tensor & self, const Tensor & vec2) const;
  virtual Tensor _ger(const Tensor & self, const Tensor & vec2) const;
  virtual Tensor & _mv_out(Tensor & result, const Tensor & self, const Tensor & vec) const;
  virtual Tensor _mv(const Tensor & self, const Tensor & vec) const;
  virtual Tensor & _mm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const;
  virtual Tensor _mm(const Tensor & self, const Tensor & mat2) const;
  virtual Tensor & bmm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const;
  virtual Tensor bmm(const Tensor & self, const Tensor & mat2) const;
  Tensor & addbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & s_addbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1) const;
  Tensor addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor s_addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & addbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1) const;
  Tensor & baddbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & s_baddbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1) const;
  Tensor baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor s_baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & baddbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1) const;
  Tensor & addcmul_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1) const;
  virtual Tensor & s_addcmul_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1) const;
  Tensor addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1) const;
  virtual Tensor s_addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1) const;
  Tensor & addcmul_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1) const;
  virtual Tensor & s_addcmul_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1) const;
  Tensor & addcdiv_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1) const;
  virtual Tensor & s_addcdiv_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1) const;
  Tensor addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1) const;
  virtual Tensor s_addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1) const;
  Tensor & addcdiv_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1) const;
  virtual Tensor & s_addcdiv_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1) const;
  virtual std::tuple<Tensor &,Tensor &> _gesv_single_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A) const;
  virtual std::tuple<Tensor,Tensor> _gesv_single(const Tensor & self, const Tensor & A) const;
  virtual std::tuple<Tensor &,Tensor &> gels_out(Tensor & res1, Tensor & res2, const Tensor & self, const Tensor & A) const;
  virtual std::tuple<Tensor,Tensor> gels(const Tensor & self, const Tensor & A) const;
  virtual std::tuple<Tensor &,Tensor &> trtrs_out(Tensor & res1, Tensor & res2, const Tensor & self, const Tensor & A, bool upper=true, bool transpose=false, bool unitriangular=false) const;
  virtual std::tuple<Tensor,Tensor> trtrs(const Tensor & self, const Tensor & A, bool upper=true, bool transpose=false, bool unitriangular=false) const;
  virtual std::tuple<Tensor &,Tensor &> symeig_out(Tensor & res1, Tensor & res2, const Tensor & self, bool eigenvectors=false, bool upper=true) const;
  virtual std::tuple<Tensor,Tensor> symeig(const Tensor & self, bool eigenvectors=false, bool upper=true) const;
  virtual std::tuple<Tensor &,Tensor &> eig_out(Tensor & res1, Tensor & res2, const Tensor & self, bool eigenvectors=false) const;
  virtual std::tuple<Tensor,Tensor> eig(const Tensor & self, bool eigenvectors=false) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> svd_out(Tensor & res1, Tensor & res2, Tensor & res3, const Tensor & self, bool some=true) const;
  virtual std::tuple<Tensor,Tensor,Tensor> svd(const Tensor & self, bool some=true) const;
  virtual Tensor & inverse_out(Tensor & output, const Tensor & self) const;
  virtual Tensor inverse(const Tensor & self) const;
  virtual Tensor & potrf_out(Tensor & output, const Tensor & self, bool upper=true) const;
  virtual Tensor potrf(const Tensor & self, bool upper=true) const;
  virtual Tensor & potrs_out(Tensor & result, const Tensor & self, const Tensor & input2, bool upper=true) const;
  virtual Tensor potrs(const Tensor & self, const Tensor & input2, bool upper=true) const;
  virtual Tensor & potri_out(Tensor & output, const Tensor & self, bool upper=true) const;
  virtual Tensor potri(const Tensor & self, bool upper=true) const;
  virtual std::tuple<Tensor &,Tensor &> pstrf_out(Tensor & res1, Tensor & res2, const Tensor & self, bool upper=true, Scalar tol=-1) const;
  virtual std::tuple<Tensor,Tensor> pstrf(const Tensor & self, bool upper=true, Scalar tol=-1) const;
  virtual std::tuple<Tensor &,Tensor &> qr_out(Tensor & res1, Tensor & res2, const Tensor & self) const;
  virtual std::tuple<Tensor,Tensor> qr(const Tensor & self) const;
  virtual std::tuple<Tensor &,Tensor &> geqrf_out(Tensor & res1, Tensor & res2, const Tensor & self) const;
  virtual std::tuple<Tensor,Tensor> geqrf(const Tensor & self) const;
  virtual Tensor & orgqr_out(Tensor & result, const Tensor & self, const Tensor & input2) const;
  virtual Tensor orgqr(const Tensor & self, const Tensor & input2) const;
  virtual Tensor & ormqr_out(Tensor & result, const Tensor & self, const Tensor & input2, const Tensor & input3, bool left=true, bool transpose=false) const;
  virtual Tensor ormqr(const Tensor & self, const Tensor & input2, const Tensor & input3, bool left=true, bool transpose=false) const;
  virtual std::tuple<Tensor &,Tensor &> btrifact_out(Tensor & result, Tensor & pivots, const Tensor & self, bool pivot=true) const;
  virtual std::tuple<Tensor,Tensor> btrifact(const Tensor & self, bool pivot=true) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> btrifact_with_info_out(Tensor & result, Tensor & pivots, Tensor & info, const Tensor & self, bool pivot=true) const;
  virtual std::tuple<Tensor,Tensor,Tensor> btrifact_with_info(const Tensor & self, bool pivot=true) const;
  virtual Tensor & btrisolve_out(Tensor & result, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const;
  virtual Tensor btrisolve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const;
  virtual Tensor & random_(Tensor & self, int64_t from, int64_t to, Generator * generator=nullptr) const;
  virtual Tensor & random_(Tensor & self, int64_t to, Generator * generator=nullptr) const;
  virtual Tensor & random_(Tensor & self, Generator * generator=nullptr) const;
  virtual Tensor & multinomial_out(Tensor & result, const Tensor & self, int64_t num_samples, bool replacement=false, Generator * generator=nullptr) const;
  virtual Tensor multinomial(const Tensor & self, int64_t num_samples, bool replacement=false, Generator * generator=nullptr) const;
  virtual Tensor & uniform_(Tensor & self, double from=0, double to=1, Generator * generator=nullptr) const;
  virtual Tensor & normal_out(Tensor & output, const Tensor & mean, double std=1, Generator * generator=nullptr) const;
  virtual Tensor normal(const Tensor & mean, double std=1, Generator * generator=nullptr) const;
  virtual Tensor & normal_out(Tensor & output, double mean, const Tensor & std, Generator * generator=nullptr) const;
  virtual Tensor normal(double mean, const Tensor & std, Generator * generator=nullptr) const;
  virtual Tensor & normal_out(Tensor & output, const Tensor & mean, const Tensor & std, Generator * generator=nullptr) const;
  virtual Tensor normal(const Tensor & mean, const Tensor & std, Generator * generator=nullptr) const;
  virtual Tensor & normal_(Tensor & self, double mean=0, double std=1, Generator * generator=nullptr) const;
  virtual Tensor & cauchy_(Tensor & self, double median=0, double sigma=1, Generator * generator=nullptr) const;
  virtual Tensor & log_normal_(Tensor & self, double mean=1, double std=2, Generator * generator=nullptr) const;
  virtual Tensor & exponential_(Tensor & self, double lambd=1, Generator * generator=nullptr) const;
  virtual Tensor & geometric_(Tensor & self, double p, Generator * generator=nullptr) const;
  virtual Tensor & _bernoulli_(Tensor & self, double p, Generator * generator=nullptr) const;
  virtual Tensor & _th_bernoulli_out(Tensor & output, const Tensor & self, Generator * generator=nullptr) const;
  virtual Tensor _th_bernoulli(const Tensor & self, Generator * generator=nullptr) const;
  virtual Tensor & _dirichlet_grad_out(Tensor & output, const Tensor & x, const Tensor & alpha, const Tensor & total) const;
  virtual Tensor _dirichlet_grad(const Tensor & x, const Tensor & alpha, const Tensor & total) const;
  virtual Tensor th_tensor(IntList size) const;
  virtual Tensor th_tensor() const;
  virtual Tensor tensor(Storage & storage, int64_t storageOffset, IntList size, IntList stride={}) const;
  virtual Tensor tensor(IntList size, IntList stride) const;
  virtual Tensor alias(const Tensor & self) const;
  virtual Tensor & _copy_ignoring_overlaps_(Tensor & self, const Tensor & src) const;
  virtual Tensor & as_strided_out(Tensor & result, const Tensor & self, IntList size, IntList stride, int64_t storage_offset) const;
  virtual Tensor as_strided(const Tensor & self, IntList size, IntList stride, int64_t storage_offset) const;
  virtual Tensor & as_strided_(Tensor & self, IntList size, IntList stride, int64_t storage_offset) const;
  virtual Tensor & _cat_out(Tensor & self, TensorList tensors, int64_t dim=0) const;
  virtual Tensor _cat(TensorList tensors, int64_t dim=0) const;
  virtual Tensor & binary_cross_entropy_out(Tensor & output, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor binary_cross_entropy(const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor & binary_cross_entropy_forward_out(Tensor & output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const;
  virtual Tensor binary_cross_entropy_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const;
  virtual Tensor & binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const;
  virtual Tensor binary_cross_entropy_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const;
  virtual Tensor & kl_div_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor kl_div(const Tensor & self, const Tensor & target, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor & kl_div_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor kl_div_forward(const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor & kl_div_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor kl_div_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor & l1_loss_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor l1_loss(const Tensor & self, const Tensor & target, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor & l1_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor l1_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor & l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor & mse_loss_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor mse_loss(const Tensor & self, const Tensor & target, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor & mse_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor mse_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor & mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor mse_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor & multi_margin_loss_out(Tensor & output, const Tensor & self, const Tensor & target, Scalar p=1, Scalar margin=1, const Tensor & weight={}, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor multi_margin_loss(const Tensor & self, const Tensor & target, Scalar p=1, Scalar margin=1, const Tensor & weight={}, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor & multi_margin_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const;
  virtual Tensor multi_margin_loss_forward(const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const;
  virtual Tensor & multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const;
  virtual Tensor multi_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const;
  virtual Tensor & multilabel_margin_loss_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor multilabel_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual std::tuple<Tensor &,Tensor &> multilabel_margin_loss_forward_out(Tensor & output, Tensor & is_target, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual std::tuple<Tensor,Tensor> multilabel_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor & multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const;
  virtual Tensor multilabel_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const;
  virtual Tensor & nll_loss_out(Tensor & output, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::ElementwiseMean, int64_t ignore_index=-100) const;
  virtual Tensor nll_loss(const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::ElementwiseMean, int64_t ignore_index=-100) const;
  virtual std::tuple<Tensor &,Tensor &> nll_loss_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const;
  virtual std::tuple<Tensor,Tensor> nll_loss_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const;
  virtual Tensor & nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const;
  virtual Tensor nll_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const;
  virtual Tensor & nll_loss2d_out(Tensor & output, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::ElementwiseMean, int64_t ignore_index=-100) const;
  virtual Tensor nll_loss2d(const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::ElementwiseMean, int64_t ignore_index=-100) const;
  virtual std::tuple<Tensor &,Tensor &> nll_loss2d_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const;
  virtual std::tuple<Tensor,Tensor> nll_loss2d_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const;
  virtual Tensor & nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const;
  virtual Tensor nll_loss2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const;
  virtual Tensor & smooth_l1_loss_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor smooth_l1_loss(const Tensor & self, const Tensor & target, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor & smooth_l1_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor smooth_l1_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor & smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor & soft_margin_loss_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor soft_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor & soft_margin_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor soft_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor & soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const;
  virtual Tensor & elu_out(Tensor & output, const Tensor & self, Scalar alpha=1, Scalar scale=1) const;
  virtual Tensor elu(const Tensor & self, Scalar alpha=1, Scalar scale=1) const;
  virtual Tensor & elu_forward_out(Tensor & output, const Tensor & self, Scalar alpha, Scalar scale) const;
  virtual Tensor elu_forward(const Tensor & self, Scalar alpha, Scalar scale) const;
  virtual Tensor & elu_backward_out(Tensor & grad_input, const Tensor & grad_output, Scalar alpha, Scalar scale, const Tensor & output) const;
  virtual Tensor elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, const Tensor & output) const;
  virtual Tensor & elu_(Tensor & self, Scalar alpha=1, Scalar scale=1) const;
  virtual Tensor & elu_forward_(Tensor & self, Scalar alpha, Scalar scale) const;
  virtual Tensor & glu_out(Tensor & output, const Tensor & self, int64_t dim=-1) const;
  virtual Tensor glu(const Tensor & self, int64_t dim=-1) const;
  virtual Tensor & glu_forward_out(Tensor & output, const Tensor & self, int64_t dim) const;
  virtual Tensor glu_forward(const Tensor & self, int64_t dim) const;
  virtual Tensor & glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, int64_t dim) const;
  virtual Tensor glu_backward(const Tensor & grad_output, const Tensor & self, int64_t dim) const;
  virtual Tensor & hardtanh_out(Tensor & output, const Tensor & self, Scalar min_val=-1, Scalar max_val=1) const;
  virtual Tensor hardtanh(const Tensor & self, Scalar min_val=-1, Scalar max_val=1) const;
  virtual Tensor & hardtanh_forward_out(Tensor & output, const Tensor & self, Scalar min_val, Scalar max_val) const;
  virtual Tensor hardtanh_forward(const Tensor & self, Scalar min_val, Scalar max_val) const;
  virtual Tensor & hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const;
  virtual Tensor hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const;
  virtual Tensor & hardtanh_(Tensor & self, Scalar min_val=-1, Scalar max_val=1) const;
  virtual Tensor & hardtanh_forward_(Tensor & self, Scalar min_val, Scalar max_val) const;
  virtual Tensor & leaky_relu_out(Tensor & output, const Tensor & self, Scalar negative_slope=0.01) const;
  virtual Tensor leaky_relu(const Tensor & self, Scalar negative_slope=0.01) const;
  virtual Tensor & leaky_relu_forward_out(Tensor & output, const Tensor & self, Scalar negative_slope) const;
  virtual Tensor leaky_relu_forward(const Tensor & self, Scalar negative_slope) const;
  virtual Tensor & leaky_relu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const;
  virtual Tensor leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const;
  virtual Tensor & leaky_relu_(Tensor & self, Scalar negative_slope=0.01) const;
  virtual Tensor & leaky_relu_forward_(Tensor & self, Scalar negative_slope) const;
  virtual Tensor & log_sigmoid_out(Tensor & output, const Tensor & self) const;
  virtual Tensor log_sigmoid(const Tensor & self) const;
  virtual std::tuple<Tensor &,Tensor &> log_sigmoid_forward_out(Tensor & output, Tensor & buffer, const Tensor & self) const;
  virtual std::tuple<Tensor,Tensor> log_sigmoid_forward(const Tensor & self) const;
  virtual Tensor & log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const;
  virtual Tensor log_sigmoid_backward(const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const;
  virtual Tensor & prelu_out(Tensor & output, const Tensor & self, const Tensor & weight) const;
  virtual Tensor prelu(const Tensor & self, const Tensor & weight) const;
  virtual Tensor & prelu_forward_out(Tensor & output, const Tensor & self, const Tensor & weight) const;
  virtual Tensor prelu_forward(const Tensor & self, const Tensor & weight) const;
  virtual std::tuple<Tensor &,Tensor &> prelu_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight) const;
  virtual std::tuple<Tensor,Tensor> prelu_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, std::array<bool,2> output_mask={{true, true}}) const;
  virtual Tensor & rrelu_with_noise_out(Tensor & output, const Tensor & self, const Tensor & noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, Generator * generator=nullptr) const;
  virtual Tensor rrelu_with_noise(const Tensor & self, const Tensor & noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, Generator * generator=nullptr) const;
  virtual Tensor & rrelu_with_noise_forward_out(Tensor & output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const;
  virtual Tensor rrelu_with_noise_forward(const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const;
  virtual Tensor & rrelu_with_noise_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const;
  virtual Tensor rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const;
  virtual Tensor & rrelu_with_noise_(Tensor & self, const Tensor & noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, Generator * generator=nullptr) const;
  virtual Tensor & rrelu_with_noise_forward_(Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const;
  virtual Tensor & softplus_out(Tensor & output, const Tensor & self, Scalar beta=1, Scalar threshold=20) const;
  virtual Tensor softplus(const Tensor & self, Scalar beta=1, Scalar threshold=20) const;
  virtual Tensor & softplus_forward_out(Tensor & output, const Tensor & self, Scalar beta, Scalar threshold) const;
  virtual Tensor softplus_forward(const Tensor & self, Scalar beta, Scalar threshold) const;
  virtual Tensor & softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const;
  virtual Tensor softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const;
  virtual Tensor & softshrink_out(Tensor & output, const Tensor & self, Scalar lambd=0.5) const;
  virtual Tensor softshrink(const Tensor & self, Scalar lambd=0.5) const;
  virtual Tensor & softshrink_forward_out(Tensor & output, const Tensor & self, Scalar lambd) const;
  virtual Tensor softshrink_forward(const Tensor & self, Scalar lambd) const;
  virtual Tensor & softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar lambd) const;
  virtual Tensor softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd) const;
  virtual Tensor & threshold_out(Tensor & output, const Tensor & self, Scalar threshold, Scalar value) const;
  virtual Tensor threshold(const Tensor & self, Scalar threshold, Scalar value) const;
  virtual Tensor & threshold_forward_out(Tensor & output, const Tensor & self, Scalar threshold, Scalar value) const;
  virtual Tensor threshold_forward(const Tensor & self, Scalar threshold, Scalar value) const;
  virtual Tensor & threshold_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar threshold, Scalar value) const;
  virtual Tensor threshold_backward(const Tensor & grad_output, const Tensor & self, Scalar threshold, Scalar value) const;
  virtual Tensor & threshold_(Tensor & self, Scalar threshold, Scalar value) const;
  virtual Tensor & threshold_forward_(Tensor & self, Scalar threshold, Scalar value) const;
  virtual Tensor & adaptive_avg_pool2d_out(Tensor & output, const Tensor & self, IntList output_size) const;
  virtual Tensor adaptive_avg_pool2d(const Tensor & self, IntList output_size) const;
  virtual Tensor & adaptive_avg_pool2d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const;
  virtual Tensor adaptive_avg_pool2d_forward(const Tensor & self, IntList output_size) const;
  virtual Tensor & adaptive_avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self) const;
  virtual Tensor adaptive_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self) const;
  virtual Tensor & adaptive_avg_pool3d_out(Tensor & output, const Tensor & self, IntList output_size) const;
  virtual Tensor adaptive_avg_pool3d(const Tensor & self, IntList output_size) const;
  virtual Tensor & adaptive_avg_pool3d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const;
  virtual Tensor adaptive_avg_pool3d_forward(const Tensor & self, IntList output_size) const;
  virtual Tensor & adaptive_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self) const;
  virtual Tensor adaptive_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self) const;
  virtual std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_out(Tensor & output, Tensor & indices, const Tensor & self, IntList output_size) const;
  virtual std::tuple<Tensor,Tensor> adaptive_max_pool2d(const Tensor & self, IntList output_size) const;
  virtual std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList output_size) const;
  virtual std::tuple<Tensor,Tensor> adaptive_max_pool2d_forward(const Tensor & self, IntList output_size) const;
  virtual Tensor & adaptive_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices) const;
  virtual Tensor adaptive_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices) const;
  virtual std::tuple<Tensor &,Tensor &> adaptive_max_pool3d_out(Tensor & output, Tensor & indices, const Tensor & self, IntList output_size) const;
  virtual std::tuple<Tensor,Tensor> adaptive_max_pool3d(const Tensor & self, IntList output_size) const;
  virtual std::tuple<Tensor &,Tensor &> adaptive_max_pool3d_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList output_size) const;
  virtual std::tuple<Tensor,Tensor> adaptive_max_pool3d_forward(const Tensor & self, IntList output_size) const;
  virtual Tensor & adaptive_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices) const;
  virtual Tensor adaptive_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices) const;
  virtual Tensor & avg_pool2d_out(Tensor & output, const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, bool ceil_mode=false, bool count_include_pad=true) const;
  virtual Tensor avg_pool2d(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, bool ceil_mode=false, bool count_include_pad=true) const;
  virtual Tensor & avg_pool2d_forward_out(Tensor & output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const;
  virtual Tensor avg_pool2d_forward(const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const;
  virtual Tensor & avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const;
  virtual Tensor avg_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const;
  virtual Tensor & avg_pool3d_out(Tensor & output, const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, bool ceil_mode=false, bool count_include_pad=true) const;
  virtual Tensor avg_pool3d(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, bool ceil_mode=false, bool count_include_pad=true) const;
  virtual Tensor & avg_pool3d_forward_out(Tensor & output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const;
  virtual Tensor avg_pool3d_forward(const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const;
  virtual Tensor & avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const;
  virtual Tensor avg_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const;
  virtual std::tuple<Tensor &,Tensor &> fractional_max_pool2d_out(Tensor & output, Tensor & indices, const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & random_samples) const;
  virtual std::tuple<Tensor,Tensor> fractional_max_pool2d(const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & random_samples) const;
  virtual std::tuple<Tensor &,Tensor &> fractional_max_pool2d_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & random_samples) const;
  virtual std::tuple<Tensor,Tensor> fractional_max_pool2d_forward(const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & random_samples) const;
  virtual Tensor & fractional_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & indices) const;
  virtual Tensor fractional_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & indices) const;
  virtual std::tuple<Tensor &,Tensor &> max_pool2d_with_indices_out(Tensor & output, Tensor & indices, const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, IntList dilation=1, bool ceil_mode=false) const;
  virtual std::tuple<Tensor,Tensor> max_pool2d_with_indices(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, IntList dilation=1, bool ceil_mode=false) const;
  virtual std::tuple<Tensor &,Tensor &> max_pool2d_with_indices_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const;
  virtual std::tuple<Tensor,Tensor> max_pool2d_with_indices_forward(const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const;
  virtual Tensor & max_pool2d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const;
  virtual Tensor max_pool2d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const;
  virtual std::tuple<Tensor &,Tensor &> max_pool3d_with_indices_out(Tensor & output, Tensor & indices, const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, IntList dilation=1, bool ceil_mode=false) const;
  virtual std::tuple<Tensor,Tensor> max_pool3d_with_indices(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, IntList dilation=1, bool ceil_mode=false) const;
  virtual std::tuple<Tensor &,Tensor &> max_pool3d_with_indices_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const;
  virtual std::tuple<Tensor,Tensor> max_pool3d_with_indices_forward(const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const;
  virtual Tensor & max_pool3d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const;
  virtual Tensor max_pool3d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const;
  virtual Tensor & max_unpool2d_out(Tensor & output, const Tensor & self, const Tensor & indices, IntList output_size) const;
  virtual Tensor max_unpool2d(const Tensor & self, const Tensor & indices, IntList output_size) const;
  virtual Tensor & max_unpool2d_forward_out(Tensor & output, const Tensor & self, const Tensor & indices, IntList output_size) const;
  virtual Tensor max_unpool2d_forward(const Tensor & self, const Tensor & indices, IntList output_size) const;
  virtual Tensor & max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntList output_size) const;
  virtual Tensor max_unpool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntList output_size) const;
  virtual Tensor & max_unpool3d_out(Tensor & output, const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const;
  virtual Tensor max_unpool3d(const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const;
  virtual Tensor & max_unpool3d_forward_out(Tensor & output, const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const;
  virtual Tensor max_unpool3d_forward(const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const;
  virtual Tensor & max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const;
  virtual Tensor max_unpool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const;
  virtual Tensor & reflection_pad1d_out(Tensor & output, const Tensor & self, IntList padding) const;
  virtual Tensor reflection_pad1d(const Tensor & self, IntList padding) const;
  virtual Tensor & reflection_pad1d_forward_out(Tensor & output, const Tensor & self, IntList padding) const;
  virtual Tensor reflection_pad1d_forward(const Tensor & self, IntList padding) const;
  virtual Tensor & reflection_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const;
  virtual Tensor reflection_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const;
  virtual Tensor & reflection_pad2d_out(Tensor & output, const Tensor & self, IntList padding) const;
  virtual Tensor reflection_pad2d(const Tensor & self, IntList padding) const;
  virtual Tensor & reflection_pad2d_forward_out(Tensor & output, const Tensor & self, IntList padding) const;
  virtual Tensor reflection_pad2d_forward(const Tensor & self, IntList padding) const;
  virtual Tensor & reflection_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const;
  virtual Tensor reflection_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const;
  virtual Tensor & replication_pad1d_out(Tensor & output, const Tensor & self, IntList padding) const;
  virtual Tensor replication_pad1d(const Tensor & self, IntList padding) const;
  virtual Tensor & replication_pad1d_forward_out(Tensor & output, const Tensor & self, IntList padding) const;
  virtual Tensor replication_pad1d_forward(const Tensor & self, IntList padding) const;
  virtual Tensor & replication_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const;
  virtual Tensor replication_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const;
  virtual Tensor & replication_pad2d_out(Tensor & output, const Tensor & self, IntList padding) const;
  virtual Tensor replication_pad2d(const Tensor & self, IntList padding) const;
  virtual Tensor & replication_pad2d_forward_out(Tensor & output, const Tensor & self, IntList padding) const;
  virtual Tensor replication_pad2d_forward(const Tensor & self, IntList padding) const;
  virtual Tensor & replication_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const;
  virtual Tensor replication_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const;
  virtual Tensor & replication_pad3d_out(Tensor & output, const Tensor & self, IntList padding) const;
  virtual Tensor replication_pad3d(const Tensor & self, IntList padding) const;
  virtual Tensor & replication_pad3d_forward_out(Tensor & output, const Tensor & self, IntList padding) const;
  virtual Tensor replication_pad3d_forward(const Tensor & self, IntList padding) const;
  virtual Tensor & replication_pad3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const;
  virtual Tensor replication_pad3d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const;
  virtual Tensor & upsample_linear1d_out(Tensor & output, const Tensor & self, IntList output_size, bool align_corners) const;
  virtual Tensor upsample_linear1d(const Tensor & self, IntList output_size, bool align_corners) const;
  virtual Tensor & upsample_linear1d_forward_out(Tensor & output, const Tensor & self, IntList output_size, bool align_corners) const;
  virtual Tensor upsample_linear1d_forward(const Tensor & self, IntList output_size, bool align_corners) const;
  virtual Tensor & upsample_linear1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const;
  virtual Tensor upsample_linear1d_backward(const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const;
  virtual Tensor & upsample_bilinear2d_out(Tensor & output, const Tensor & self, IntList output_size, bool align_corners) const;
  virtual Tensor upsample_bilinear2d(const Tensor & self, IntList output_size, bool align_corners) const;
  virtual Tensor & upsample_bilinear2d_forward_out(Tensor & output, const Tensor & self, IntList output_size, bool align_corners) const;
  virtual Tensor upsample_bilinear2d_forward(const Tensor & self, IntList output_size, bool align_corners) const;
  virtual Tensor & upsample_bilinear2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const;
  virtual Tensor upsample_bilinear2d_backward(const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const;
  virtual Tensor & upsample_trilinear3d_out(Tensor & output, const Tensor & self, IntList output_size, bool align_corners) const;
  virtual Tensor upsample_trilinear3d(const Tensor & self, IntList output_size, bool align_corners) const;
  virtual Tensor & upsample_trilinear3d_forward_out(Tensor & output, const Tensor & self, IntList output_size, bool align_corners) const;
  virtual Tensor upsample_trilinear3d_forward(const Tensor & self, IntList output_size, bool align_corners) const;
  virtual Tensor & upsample_trilinear3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const;
  virtual Tensor upsample_trilinear3d_backward(const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const;
  virtual Tensor & upsample_nearest1d_out(Tensor & output, const Tensor & self, IntList output_size) const;
  virtual Tensor upsample_nearest1d(const Tensor & self, IntList output_size) const;
  virtual Tensor & upsample_nearest1d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const;
  virtual Tensor upsample_nearest1d_forward(const Tensor & self, IntList output_size) const;
  virtual Tensor & upsample_nearest1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size) const;
  virtual Tensor upsample_nearest1d_backward(const Tensor & grad_output, IntList output_size, IntList input_size) const;
  virtual Tensor & upsample_nearest2d_out(Tensor & output, const Tensor & self, IntList output_size) const;
  virtual Tensor upsample_nearest2d(const Tensor & self, IntList output_size) const;
  virtual Tensor & upsample_nearest2d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const;
  virtual Tensor upsample_nearest2d_forward(const Tensor & self, IntList output_size) const;
  virtual Tensor & upsample_nearest2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size) const;
  virtual Tensor upsample_nearest2d_backward(const Tensor & grad_output, IntList output_size, IntList input_size) const;
  virtual Tensor & upsample_nearest3d_out(Tensor & output, const Tensor & self, IntList output_size) const;
  virtual Tensor upsample_nearest3d(const Tensor & self, IntList output_size) const;
  virtual Tensor & upsample_nearest3d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const;
  virtual Tensor upsample_nearest3d_forward(const Tensor & self, IntList output_size) const;
  virtual Tensor & upsample_nearest3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size) const;
  virtual Tensor upsample_nearest3d_backward(const Tensor & grad_output, IntList output_size, IntList input_size) const;
  virtual Tensor & _sigmoid_out(Tensor & output, const Tensor & self) const;
  virtual Tensor _sigmoid(const Tensor & self) const;
  virtual Tensor & _sigmoid_forward_out(Tensor & output, const Tensor & self) const;
  virtual Tensor _sigmoid_forward(const Tensor & self) const;
  virtual Tensor & _sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const;
  virtual Tensor _sigmoid_backward(const Tensor & grad_output, const Tensor & output) const;
  virtual Tensor & _tanh_out(Tensor & output, const Tensor & self) const;
  virtual Tensor _tanh(const Tensor & self) const;
  virtual Tensor & _tanh_forward_out(Tensor & output, const Tensor & self) const;
  virtual Tensor _tanh_forward(const Tensor & self) const;
  virtual Tensor & _tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const;
  virtual Tensor _tanh_backward(const Tensor & grad_output, const Tensor & output) const;
  virtual Tensor & thnn_batch_norm_out(Tensor & output, const Tensor & self, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) const;
  virtual Tensor thnn_batch_norm(const Tensor & self, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_batch_norm_forward_out(Tensor & output, Tensor & save_mean, Tensor & save_std, const Tensor & self, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_batch_norm_forward(const Tensor & self, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_batch_norm_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, bool training, double eps, const Tensor & save_mean, const Tensor & save_std) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_batch_norm_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, bool training, double eps, const Tensor & save_mean, const Tensor & save_std, std::array<bool,3> output_mask={{true, true, true}}) const;
  virtual Tensor & thnn_conv_transpose2d_out(Tensor & output, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList output_padding=0, IntList dilation=1) const;
  virtual Tensor thnn_conv_transpose2d(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList output_padding=0, IntList dilation=1) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose2d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & columns, const Tensor & ones) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask={{true, true, true}}) const;
  virtual Tensor & thnn_conv_transpose3d_out(Tensor & output, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList output_padding=0, IntList dilation=1) const;
  virtual Tensor thnn_conv_transpose3d(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList output_padding=0, IntList dilation=1) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose3d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & finput, const Tensor & fgrad_input) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask={{true, true, true}}) const;
  virtual Tensor & thnn_conv2d_out(Tensor & output, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0) const;
  virtual Tensor thnn_conv2d(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask={{true, true, true}}) const;
  virtual Tensor & thnn_conv_depthwise2d_out(Tensor & output, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList dilation=1) const;
  virtual Tensor thnn_conv_depthwise2d(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList dilation=1) const;
  virtual Tensor & thnn_conv_depthwise2d_forward_out(Tensor & output, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const;
  virtual Tensor thnn_conv_depthwise2d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const;
  virtual std::tuple<Tensor &,Tensor &> thnn_conv_depthwise2d_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation) const;
  virtual std::tuple<Tensor,Tensor> thnn_conv_depthwise2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, std::array<bool,2> output_mask={{true, true}}) const;
  virtual Tensor & thnn_conv3d_out(Tensor & output, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0) const;
  virtual Tensor thnn_conv3d(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv3d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask={{true, true, true}}) const;
  virtual Tensor & thnn_conv_dilated2d_out(Tensor & output, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList dilation=1) const;
  virtual Tensor thnn_conv_dilated2d(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList dilation=1) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated2d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask={{true, true, true}}) const;
  virtual Tensor & thnn_conv_dilated3d_out(Tensor & output, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList dilation=1) const;
  virtual Tensor thnn_conv_dilated3d(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList dilation=1) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated3d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated3d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const;
  virtual std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones) const;
  virtual std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask={{true, true, true}}) const;
  virtual Tensor _cast_Byte(const Tensor & self, bool non_blocking=false) const;
  virtual Tensor _cast_Char(const Tensor & self, bool non_blocking=false) const;
  virtual Tensor _cast_Double(const Tensor & self, bool non_blocking=false) const;
  virtual Tensor _cast_Float(const Tensor & self, bool non_blocking=false) const;
  virtual Tensor _cast_Int(const Tensor & self, bool non_blocking=false) const;
  virtual Tensor _cast_Long(const Tensor & self, bool non_blocking=false) const;
  virtual Tensor _cast_Short(const Tensor & self, bool non_blocking=false) const;
  virtual Tensor _cast_Half(const Tensor & self, bool non_blocking=false) const;
  virtual Tensor _cudnn_rnn_flatten_weight(TensorList weight_arr, int64_t weight_stride0, int64_t input_size, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, bool bidirectional) const;
  virtual std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _cudnn_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntList batch_sizes, const Tensor & dropout_state) const;
  virtual std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> _cudnn_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntList batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask) const;
  virtual Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed) const;
  virtual Tensor abs(const Tensor & self) const;
  virtual Tensor & abs_(Tensor & self) const;
  virtual Tensor & abs_out(Tensor & result, const Tensor & self) const;
  virtual Tensor acos(const Tensor & self) const;
  virtual Tensor & acos_(Tensor & self) const;
  virtual Tensor & acos_out(Tensor & result, const Tensor & self) const;
  virtual Tensor avg_pool1d(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, bool ceil_mode=false, bool count_include_pad=true) const;
  virtual Tensor adaptive_avg_pool1d(const Tensor & self, IntList output_size) const;
  virtual std::tuple<Tensor,Tensor> adaptive_max_pool1d(const Tensor & self, IntList output_size) const;
  virtual bool allclose(const Tensor & self, const Tensor & other, double rtol=1e-05, double atol=1e-08, bool equal_nan=false) const;
  virtual Tensor addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & addmv_out(Tensor & result, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & addr_out(Tensor & result, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor all(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor & all_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor any(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor & any_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor & arange_out(Tensor & result, Scalar start, Scalar end) const;
  virtual Tensor & arange_out(Tensor & result, Scalar start, Scalar end, Scalar step) const;
  virtual Tensor & arange_out(Tensor & result, Scalar end) const;
  AT_DEPRECATED(virtual Tensor arange(Scalar start, Scalar end, Scalar step=1) const);
  AT_DEPRECATED(virtual Tensor arange(Scalar end) const);
  virtual Tensor _dim_arange(const Tensor & like, int64_t dim) const;
  virtual Tensor argmax(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor argmax(const Tensor & self) const;
  virtual Tensor _argmax(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor argmin(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor argmin(const Tensor & self) const;
  virtual Tensor _argmin(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor as_strided(const Tensor & self, IntList size, IntList stride) const;
  virtual Tensor & as_strided_(Tensor & self, IntList size, IntList stride) const;
  virtual Tensor asin(const Tensor & self) const;
  virtual Tensor & asin_(Tensor & self) const;
  virtual Tensor & asin_out(Tensor & result, const Tensor & self) const;
  virtual Tensor atan(const Tensor & self) const;
  virtual Tensor & atan_(Tensor & self) const;
  virtual Tensor & atan_out(Tensor & result, const Tensor & self) const;
  virtual Tensor batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled) const;
  virtual Tensor bernoulli(const Tensor & self, const Tensor & p, Generator * generator=nullptr) const;
  virtual Tensor bernoulli(const Tensor & self, double p, Generator * generator=nullptr) const;
  virtual Tensor bernoulli(const Tensor & self) const;
  virtual Tensor & bernoulli_(Tensor & self, const Tensor & p, Generator * generator=nullptr) const;
  virtual Tensor & bernoulli_(Tensor & self, double p, Generator * generator=nullptr) const;
  virtual Tensor & bernoulli_(Tensor & self) const;
  virtual Tensor bilinear(const Tensor & input1, const Tensor & input2, const Tensor & weight, const Tensor & bias) const;
  virtual Tensor bincount(const Tensor & self, const Tensor & weights={}, int64_t minlength=0) const;
  virtual Tensor cat(TensorList tensors, int64_t dim=0) const;
  virtual Tensor & cat_out(Tensor & result, TensorList tensors, int64_t dim=0) const;
  virtual Tensor ceil(const Tensor & self) const;
  virtual Tensor & ceil_(Tensor & self) const;
  virtual Tensor & ceil_out(Tensor & result, const Tensor & self) const;
  virtual std::vector<Tensor> chunk(const Tensor & self, int64_t chunks, int64_t dim=0) const;
  virtual bool cudnn_is_acceptable(const Tensor & self) const;
  virtual Tensor convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntList stride, IntList padding, IntList dilation, bool transposed, IntList output_padding, int64_t groups) const;
  virtual Tensor _convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntList stride, IntList padding, IntList dilation, bool transposed, IntList output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled) const;
  virtual Tensor _convolution_nogroup(const Tensor & input, const Tensor & weight, const Tensor & bias, IntList stride, IntList padding, IntList dilation, bool transposed, IntList output_padding) const;
  virtual std::tuple<Tensor,Tensor,Tensor> _convolution_double_backward(const Tensor & ggI, const Tensor & ggW, const Tensor & ggb, const Tensor & gO, const Tensor & weight, const Tensor & self, IntList stride, IntList padding, IntList dilation, bool transposed, IntList output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, std::array<bool,3> output_mask) const;
  virtual Tensor conv1d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList dilation=1, int64_t groups=1) const;
  virtual Tensor conv2d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList dilation=1, int64_t groups=1) const;
  virtual Tensor conv3d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList dilation=1, int64_t groups=1) const;
  virtual Tensor conv_tbc(const Tensor & self, const Tensor & weight, const Tensor & bias, int64_t pad) const;
  virtual std::tuple<Tensor,Tensor,Tensor> conv_tbc_backward(const Tensor & self, const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t pad) const;
  virtual Tensor conv_transpose1d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList output_padding=0, int64_t groups=1, IntList dilation=1) const;
  virtual Tensor conv_transpose2d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList output_padding=0, int64_t groups=1, IntList dilation=1) const;
  virtual Tensor conv_transpose3d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntList stride=1, IntList padding=0, IntList output_padding=0, int64_t groups=1, IntList dilation=1) const;
  virtual Tensor cos(const Tensor & self) const;
  virtual Tensor & cos_(Tensor & self) const;
  virtual Tensor & cos_out(Tensor & result, const Tensor & self) const;
  virtual Tensor cosh(const Tensor & self) const;
  virtual Tensor & cosh_(Tensor & self) const;
  virtual Tensor & cosh_out(Tensor & result, const Tensor & self) const;
  virtual Tensor cosine_embedding_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin=0.0, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor cudnn_affine_grid_generator(const Tensor & theta, int64_t N, int64_t C, int64_t H, int64_t W) const;
  virtual Tensor cudnn_affine_grid_generator_backward(const Tensor & grad, int64_t N, int64_t C, int64_t H, int64_t W) const;
  virtual std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon) const;
  virtual std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon) const;
  virtual Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const;
  virtual Tensor cudnn_convolution_backward_input(IntList self_size, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const;
  virtual std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const;
  virtual Tensor cudnn_convolution_backward_bias(const Tensor & grad_output) const;
  virtual Tensor cudnn_convolution_backward_weight(IntList weight_size, const Tensor & grad_output, const Tensor & self, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const;
  virtual Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntList padding, IntList output_padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const;
  virtual std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList output_padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const;
  virtual Tensor cudnn_convolution_transpose_backward_bias(const Tensor & grad_output) const;
  virtual Tensor cudnn_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const;
  virtual Tensor cudnn_convolution_transpose_backward_weight(IntList weight_size, const Tensor & grad_output, const Tensor & self, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const;
  virtual Tensor cudnn_grid_sampler(const Tensor & self, const Tensor & grid) const;
  virtual std::tuple<Tensor,Tensor> cudnn_grid_sampler_backward(const Tensor & self, const Tensor & grid, const Tensor & grad_output) const;
  virtual Tensor cumsum(const Tensor & self, int64_t dim, ScalarType dtype) const;
  virtual Tensor cumsum(const Tensor & self, int64_t dim) const;
  virtual Tensor & cumsum_out(Tensor & result, const Tensor & self, int64_t dim, ScalarType dtype) const;
  virtual Tensor & cumsum_out(Tensor & result, const Tensor & self, int64_t dim) const;
  virtual Tensor cumprod(const Tensor & self, int64_t dim, ScalarType dtype) const;
  virtual Tensor cumprod(const Tensor & self, int64_t dim) const;
  virtual Tensor & cumprod_out(Tensor & result, const Tensor & self, int64_t dim, ScalarType dtype) const;
  virtual Tensor & cumprod_out(Tensor & result, const Tensor & self, int64_t dim) const;
  virtual Tensor det(const Tensor & self) const;
  virtual Tensor diagflat(const Tensor & self, int64_t offset=0) const;
  virtual Tensor diagonal(const Tensor & self, int64_t offset=0, int64_t dim1=0, int64_t dim2=1) const;
  virtual Tensor dot(const Tensor & self, const Tensor & tensor) const;
  virtual Tensor & dot_out(Tensor & result, const Tensor & self, const Tensor & tensor) const;
  virtual Tensor einsum(std::string equation, TensorList tensors) const;
  virtual Tensor embedding(const Tensor & weight, const Tensor & indices, int64_t padding_idx=-1, bool scale_grad_by_freq=false, bool sparse=false) const;
  virtual Tensor embedding_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq, bool sparse) const;
  virtual Tensor embedding_dense_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq) const;
  virtual Tensor & embedding_renorm_(Tensor & self, const Tensor & indices, double max_norm, double norm_type) const;
  virtual Tensor embedding_sparse_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq) const;
  virtual std::tuple<Tensor,Tensor,Tensor,Tensor> embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false) const;
  virtual std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false) const;
  virtual Tensor _embedding_bag_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, bool sparse) const;
  virtual Tensor _embedding_bag_sparse_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, int64_t num_weights, bool scale_grad_by_freq, int64_t mode) const;
  virtual Tensor _embedding_bag_dense_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode) const;
  virtual Tensor & empty_out(Tensor & result, IntList size) const;
  virtual Tensor empty_like(const Tensor & self) const;
  AT_DEPRECATED(virtual Tensor empty(IntList size) const);
  virtual Tensor erf(const Tensor & self) const;
  virtual Tensor & erf_(Tensor & self) const;
  virtual Tensor & erf_out(Tensor & result, const Tensor & self) const;
  virtual Tensor exp(const Tensor & self) const;
  virtual Tensor & exp_(Tensor & self) const;
  virtual Tensor & exp_out(Tensor & result, const Tensor & self) const;
  virtual Tensor expm1(const Tensor & self) const;
  virtual Tensor & expm1_(Tensor & self) const;
  virtual Tensor & expm1_out(Tensor & result, const Tensor & self) const;
  virtual Tensor expand(const Tensor & self, IntList size, bool implicit=false) const;
  virtual Tensor expand_as(const Tensor & self, const Tensor & other) const;
  virtual Tensor & eye_out(Tensor & result, int64_t n) const;
  virtual Tensor & eye_out(Tensor & result, int64_t n, int64_t m) const;
  AT_DEPRECATED(virtual Tensor eye(int64_t n, int64_t m=-1) const);
  virtual Tensor flatten(const Tensor & self, int64_t start_dim=0, int64_t end_dim=-1) const;
  virtual Tensor & fill_(Tensor & self, Scalar value) const;
  virtual Tensor & fill_(Tensor & self, const Tensor & value) const;
  virtual Tensor floor(const Tensor & self) const;
  virtual Tensor & floor_(Tensor & self) const;
  virtual Tensor & floor_out(Tensor & result, const Tensor & self) const;
  virtual Tensor & full_out(Tensor & result, IntList size, Scalar fill_value) const;
  virtual Tensor full_like(const Tensor & self, Scalar fill_value) const;
  AT_DEPRECATED(virtual Tensor full(IntList size, Scalar fill_value) const);
  virtual Tensor hinge_embedding_loss(const Tensor & self, const Tensor & target, double margin=1.0, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor ger(const Tensor & self, const Tensor & vec2) const;
  virtual Tensor & ger_out(Tensor & result, const Tensor & self, const Tensor & vec2) const;
  virtual std::tuple<Tensor,Tensor> gesv(const Tensor & self, const Tensor & A) const;
  virtual std::tuple<Tensor &,Tensor &> gesv_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A) const;
  virtual std::tuple<Tensor,Tensor> _gesv_helper(const Tensor & self, const Tensor & A) const;
  virtual Tensor group_norm(const Tensor & input, int64_t num_groups, const Tensor & weight={}, const Tensor & bias={}, double eps=1e-05, bool cudnn_enabled=true) const;
  virtual Tensor fft(const Tensor & self, int64_t signal_ndim, bool normalized=false) const;
  virtual Tensor ifft(const Tensor & self, int64_t signal_ndim, bool normalized=false) const;
  virtual Tensor rfft(const Tensor & self, int64_t signal_ndim, bool normalized=false, bool onesided=true) const;
  virtual Tensor irfft(const Tensor & self, int64_t signal_ndim, bool normalized=false, bool onesided=true, IntList signal_sizes={}) const;
  virtual Tensor _fft_with_size(const Tensor & self, int64_t signal_ndim, bool complex_input, bool complex_output, bool inverse, IntList checked_signal_sizes, bool normalized, bool onesided, IntList output_sizes) const;
  virtual int64_t _cufft_get_plan_cache_size() const;
  virtual int64_t _cufft_get_plan_cache_max_size() const;
  virtual void _cufft_set_plan_cache_max_size(int64_t max_size) const;
  virtual void _cufft_clear_plan_cache() const;
  virtual Tensor index(const Tensor & self, TensorList indices) const;
  virtual Tensor & index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const;
  virtual Tensor index_put(const Tensor & self, TensorList indices, const Tensor & values) const;
  virtual Tensor & index_put_(Tensor & self, TensorList indices, const Tensor & values) const;
  virtual Tensor isclose(const Tensor & self, const Tensor & other, double rtol=1e-05, double atol=1e-08, bool equal_nan=false) const;
  virtual bool is_cuda(const Tensor & self) const;
  virtual bool is_distributed(const Tensor & self) const;
  virtual bool is_floating_point(const Tensor & self) const;
  virtual bool is_nonzero(const Tensor & self) const;
  virtual bool is_same_size(const Tensor & self, const Tensor & other) const;
  virtual bool is_signed(const Tensor & self) const;
  virtual bool is_sparse(const Tensor & self) const;
  virtual std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false) const;
  virtual std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false) const;
  virtual Tensor layer_norm(const Tensor & input, IntList normalized_shape, const Tensor & weight={}, const Tensor & bias={}, double eps=1e-05, bool cudnn_enable=true) const;
  virtual Tensor & linspace_out(Tensor & result, Scalar start, Scalar end) const;
  virtual Tensor & linspace_out(Tensor & result, Scalar start, Scalar end, int64_t steps) const;
  AT_DEPRECATED(virtual Tensor linspace(Scalar start, Scalar end, int64_t steps=100) const);
  virtual Tensor log(const Tensor & self) const;
  virtual Tensor & log_(Tensor & self) const;
  virtual Tensor & log_out(Tensor & result, const Tensor & self) const;
  virtual Tensor log10(const Tensor & self) const;
  virtual Tensor & log10_(Tensor & self) const;
  virtual Tensor & log10_out(Tensor & result, const Tensor & self) const;
  virtual Tensor log1p(const Tensor & self) const;
  virtual Tensor & log1p_(Tensor & self) const;
  virtual Tensor & log1p_out(Tensor & result, const Tensor & self) const;
  virtual Tensor log2(const Tensor & self) const;
  virtual Tensor & log2_(Tensor & self) const;
  virtual Tensor & log2_out(Tensor & result, const Tensor & self) const;
  virtual Tensor logdet(const Tensor & self) const;
  virtual Tensor & logspace_out(Tensor & result, Scalar start, Scalar end) const;
  virtual Tensor & logspace_out(Tensor & result, Scalar start, Scalar end, int64_t steps) const;
  AT_DEPRECATED(virtual Tensor logspace(Scalar start, Scalar end, int64_t steps=100) const);
  virtual Tensor log_softmax(const Tensor & self, int64_t dim) const;
  virtual Tensor log_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self) const;
  virtual Tensor logsumexp(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor & logsumexp_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor margin_ranking_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin=0.0, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor matmul(const Tensor & self, const Tensor & other) const;
  virtual Tensor & matmul_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual std::tuple<Tensor,Tensor> max(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_values, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor max_values(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual std::tuple<Tensor,Tensor> max_pool1d_with_indices(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, IntList dilation=1, bool ceil_mode=false) const;
  virtual Tensor max_pool1d(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, IntList dilation=1, bool ceil_mode=false) const;
  virtual Tensor max_pool2d(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, IntList dilation=1, bool ceil_mode=false) const;
  virtual Tensor max_pool3d(const Tensor & self, IntList kernel_size, IntList stride={}, IntList padding=0, IntList dilation=1, bool ceil_mode=false) const;
  virtual Tensor mean(const Tensor & self, ScalarType dtype) const;
  virtual Tensor mean(const Tensor & self) const;
  virtual Tensor mean(const Tensor & self, int64_t dim, bool keepdim, ScalarType dtype) const;
  virtual Tensor mean(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor mean(const Tensor & self, int64_t dim, ScalarType dtype) const;
  virtual Tensor & mean_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim, ScalarType dtype) const;
  virtual Tensor & mean_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor & mean_out(Tensor & result, const Tensor & self, int64_t dim, ScalarType dtype) const;
  virtual std::tuple<Tensor,Tensor> median(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual std::tuple<Tensor,Tensor> min(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor min_values(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor mkldnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntList padding, IntList stride, IntList dilation) const;
  virtual Tensor mkldnn_convolution_backward_input(IntList self_size, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, bool bias_defined) const;
  virtual std::tuple<Tensor,Tensor> mkldnn_convolution_backward_weights(IntList weight_size, const Tensor & grad_output, const Tensor & self, IntList padding, IntList stride, IntList dilation, bool bias_defined) const;
  virtual std::tuple<Tensor,Tensor,Tensor> mkldnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, std::array<bool,3> output_mask) const;
  virtual Tensor mm(const Tensor & self, const Tensor & mat2) const;
  virtual Tensor & mm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const;
  virtual std::tuple<Tensor,Tensor> mode(const Tensor & self, int64_t dim=-1, bool keepdim=false) const;
  virtual std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool keepdim=false) const;
  virtual Tensor mv(const Tensor & self, const Tensor & vec) const;
  virtual Tensor & mv_out(Tensor & result, const Tensor & self, const Tensor & vec) const;
  virtual Tensor narrow(const Tensor & self, int64_t dim, int64_t start, int64_t length) const;
  virtual Tensor & ones_out(Tensor & result, IntList size) const;
  virtual Tensor ones_like(const Tensor & self) const;
  AT_DEPRECATED(virtual Tensor ones(IntList size) const);
  virtual Tensor pairwise_distance(const Tensor & x1, const Tensor & x2, double p=2, double eps=1e-06, bool keepdim=false) const;
  virtual Tensor permute(const Tensor & self, IntList dims) const;
  virtual Tensor pin_memory(const Tensor & self) const;
  virtual Tensor pinverse(const Tensor & self, double rcond=1e-15) const;
  virtual Tensor & rand_out(Tensor & result, IntList size) const;
  virtual Tensor & rand_out(Tensor & result, IntList size, Generator * generator) const;
  virtual Tensor rand_like(const Tensor & self) const;
  AT_DEPRECATED(virtual Tensor rand(IntList size, Generator * generator=nullptr) const);
  AT_DEPRECATED(virtual Tensor randint(int64_t high, IntList size, Generator * generator=nullptr) const);
  AT_DEPRECATED(virtual Tensor randint(int64_t low, int64_t high, IntList size, Generator * generator=nullptr) const);
  virtual Tensor & randint_out(Tensor & result, int64_t high, IntList size) const;
  virtual Tensor & randint_out(Tensor & result, int64_t high, IntList size, Generator * generator) const;
  virtual Tensor & randint_out(Tensor & result, int64_t low, int64_t high, IntList size) const;
  virtual Tensor & randint_out(Tensor & result, int64_t low, int64_t high, IntList size, Generator * generator) const;
  virtual Tensor randint_like(const Tensor & self, int64_t high) const;
  virtual Tensor randint_like(const Tensor & self, int64_t low, int64_t high) const;
  virtual Tensor & randn_out(Tensor & result, IntList size) const;
  virtual Tensor & randn_out(Tensor & result, IntList size, Generator * generator) const;
  virtual Tensor randn_like(const Tensor & self) const;
  AT_DEPRECATED(virtual Tensor randn(IntList size, Generator * generator=nullptr) const);
  virtual Tensor & randperm_out(Tensor & result, int64_t n) const;
  virtual Tensor & randperm_out(Tensor & result, int64_t n, Generator * generator) const;
  AT_DEPRECATED(virtual Tensor randperm(int64_t n, Generator * generator=nullptr) const);
  virtual Tensor & range_out(Tensor & result, Scalar start, Scalar end) const;
  virtual Tensor & range_out(Tensor & result, Scalar start, Scalar end, Scalar step) const;
  AT_DEPRECATED(virtual Tensor range(Scalar start, Scalar end, Scalar step=1) const);
  virtual Tensor repeat(const Tensor & self, IntList repeats) const;
  virtual Tensor reshape(const Tensor & self, IntList shape) const;
  virtual std::tuple<Tensor,Tensor> RoiPooling2d_forward(const Tensor & input, const Tensor & rois, int64_t pooledHeight, int64_t pooledWidth, double spatialScale) const;
  virtual Tensor RoiPooling2d_backward(const Tensor & input, const Tensor & rois, int64_t pooledHeight, int64_t pooledWidth, double spatialScale, const Tensor & gradOutput, const Tensor & argmaxes) const;
  virtual Tensor round(const Tensor & self) const;
  virtual Tensor & round_(Tensor & self) const;
  virtual Tensor & round_out(Tensor & result, const Tensor & self) const;
  virtual Tensor rrelu(const Tensor & self, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, Generator * generator=nullptr) const;
  virtual Tensor & rrelu_(Tensor & self, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, Generator * generator=nullptr) const;
  virtual Tensor relu(const Tensor & self) const;
  virtual Tensor & relu_(Tensor & self) const;
  virtual Tensor hardshrink(const Tensor & self, Scalar lambd=0.5) const;
  virtual Tensor hardshrink_backward(const Tensor & grad_out, const Tensor & self, Scalar lambd) const;
  virtual Tensor rsqrt(const Tensor & self) const;
  virtual Tensor & rsqrt_(Tensor & self) const;
  virtual Tensor & rsqrt_out(Tensor & result, const Tensor & self) const;
  virtual Tensor select(const Tensor & self, int64_t dim, int64_t index) const;
  virtual Tensor selu(const Tensor & self) const;
  virtual Tensor & selu_(Tensor & self) const;
  virtual Tensor sin(const Tensor & self) const;
  virtual Tensor & sin_(Tensor & self) const;
  virtual Tensor & sin_out(Tensor & result, const Tensor & self) const;
  virtual Tensor sinh(const Tensor & self) const;
  virtual Tensor & sinh_(Tensor & self) const;
  virtual Tensor & sinh_out(Tensor & result, const Tensor & self) const;
  virtual int64_t size(const Tensor & self, int64_t dim) const;
  virtual Tensor slice(const Tensor & self, int64_t dim=0, int64_t start=0, int64_t end=9223372036854775807, int64_t step=1) const;
  virtual std::tuple<Tensor,Tensor> slogdet(const Tensor & self) const;
  virtual Tensor smm(const Tensor & self, const Tensor & mat2) const;
  virtual Tensor softmax(const Tensor & self, int64_t dim) const;
  virtual Tensor softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self) const;
  virtual std::vector<Tensor> split(const Tensor & self, int64_t split_size, int64_t dim=0) const;
  virtual std::vector<Tensor> split_with_sizes(const Tensor & self, IntList split_sizes, int64_t dim=0) const;
  virtual Tensor squeeze(const Tensor & self) const;
  virtual Tensor squeeze(const Tensor & self, int64_t dim) const;
  virtual Tensor & squeeze_(Tensor & self) const;
  virtual Tensor & squeeze_(Tensor & self, int64_t dim) const;
  virtual Tensor sspaddmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & sspaddmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor stack(TensorList tensors, int64_t dim=0) const;
  virtual Tensor & stack_out(Tensor & result, TensorList tensors, int64_t dim=0) const;
  virtual Tensor stft(const Tensor & self, int64_t frame_length, int64_t hop, int64_t fft_size, bool normalized=false, bool onesided=true, const Tensor & window={}, int64_t pad_end=0) const;
  virtual int64_t stride(const Tensor & self, int64_t dim) const;
  virtual Tensor sum(const Tensor & self, ScalarType dtype) const;
  virtual Tensor sum(const Tensor & self) const;
  virtual Tensor _sum(const Tensor & self) const;
  virtual Tensor sum(const Tensor & self, IntList dim, bool keepdim, ScalarType dtype) const;
  virtual Tensor sum(const Tensor & self, IntList dim, bool keepdim=false) const;
  virtual Tensor sum(const Tensor & self, IntList dim, ScalarType dtype) const;
  virtual Tensor _sum(const Tensor & self, IntList dim, bool keepdim=false) const;
  virtual Tensor & sum_out(Tensor & result, const Tensor & self, IntList dim, bool keepdim, ScalarType dtype) const;
  virtual Tensor & sum_out(Tensor & result, const Tensor & self, IntList dim, bool keepdim=false) const;
  virtual Tensor & sum_out(Tensor & result, const Tensor & self, IntList dim, ScalarType dtype) const;
  virtual Tensor & _sum_out(Tensor & result, const Tensor & self, IntList dim, bool keepdim=false) const;
  virtual Tensor & _sum_cuda_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor sqrt(const Tensor & self) const;
  virtual Tensor & sqrt_(Tensor & self) const;
  virtual Tensor & sqrt_out(Tensor & result, const Tensor & self) const;
  virtual Tensor std(const Tensor & self, int64_t dim, bool unbiased=true, bool keepdim=false) const;
  virtual Tensor & std_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased=true, bool keepdim=false) const;
  virtual Tensor prod(const Tensor & self, ScalarType dtype) const;
  virtual Tensor prod(const Tensor & self) const;
  virtual Tensor _prod(const Tensor & self) const;
  virtual Tensor prod(const Tensor & self, int64_t dim, bool keepdim, ScalarType dtype) const;
  virtual Tensor prod(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor prod(const Tensor & self, int64_t dim, ScalarType dtype) const;
  virtual Tensor _prod(const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor & prod_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim, ScalarType dtype) const;
  virtual Tensor & prod_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor & prod_out(Tensor & result, const Tensor & self, int64_t dim, ScalarType dtype) const;
  virtual Tensor & _prod_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim=false) const;
  virtual Tensor t(const Tensor & self) const;
  virtual Tensor & t_(Tensor & self) const;
  virtual Tensor tan(const Tensor & self) const;
  virtual Tensor & tan_(Tensor & self) const;
  virtual Tensor & tan_out(Tensor & result, const Tensor & self) const;
  virtual Tensor tanh(const Tensor & self) const;
  virtual Tensor & tanh_(Tensor & self) const;
  virtual Tensor & tanh_out(Tensor & result, const Tensor & self) const;
  virtual Tensor transpose(const Tensor & self, int64_t dim0, int64_t dim1) const;
  virtual Tensor & transpose_(Tensor & self, int64_t dim0, int64_t dim1) const;
  virtual Tensor flip(const Tensor & self, IntList dims) const;
  virtual Tensor _trilinear(const Tensor & i1, const Tensor & i2, const Tensor & i3, IntList expand1, IntList expand2, IntList expand3, IntList sumdim, int64_t unroll_dim=1) const;
  virtual Tensor triplet_margin_loss(const Tensor & anchor, const Tensor & positive, const Tensor & negative, double margin=1.0, double p=2, double eps=1e-06, bool swap=false, int64_t reduction=Reduction::ElementwiseMean) const;
  virtual Tensor trunc(const Tensor & self) const;
  virtual Tensor & trunc_(Tensor & self) const;
  virtual Tensor & trunc_out(Tensor & result, const Tensor & self) const;
  virtual Tensor type_as(const Tensor & self, const Tensor & other) const;
  virtual std::tuple<Tensor,Tensor> _unique(const Tensor & self, bool sorted=false, bool return_inverse=false) const;
  virtual Tensor _unsafe_view(const Tensor & self, IntList size) const;
  virtual Tensor unsqueeze(const Tensor & self, int64_t dim) const;
  virtual Tensor & unsqueeze_(Tensor & self, int64_t dim) const;
  virtual Tensor var(const Tensor & self, int64_t dim, bool unbiased=true, bool keepdim=false) const;
  virtual Tensor & var_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased=true, bool keepdim=false) const;
  virtual Tensor view_as(const Tensor & self, const Tensor & other) const;
  virtual Tensor where(const Tensor & condition, const Tensor & self, const Tensor & other) const;
  virtual Tensor _s_where(const Tensor & condition, const Tensor & self, const Tensor & other) const;
  virtual Tensor & zeros_out(Tensor & result, IntList size) const;
  virtual Tensor zeros_like(const Tensor & self) const;
  AT_DEPRECATED(virtual Tensor zeros(IntList size) const);
  virtual Tensor _standard_gamma_grad(const Tensor & self, const Tensor & output) const;
  virtual Tensor _standard_gamma(const Tensor & self, Generator * generator=nullptr) const;
  virtual Tensor poisson(const Tensor & self, Generator * generator=nullptr) const;
  virtual Tensor native_norm(const Tensor & self, Scalar p=2) const;
  virtual Tensor norm(const Tensor & self, Scalar p=2) const;
  virtual Tensor norm(const Tensor & self, Scalar p, int64_t dim, bool keepdim=false) const;
  virtual Tensor & norm_out(Tensor & result, const Tensor & self, Scalar p, int64_t dim, bool keepdim=false) const;
  virtual Tensor native_clone(const Tensor & self) const;
  virtual Tensor clone(const Tensor & self) const;
  virtual Tensor & native_resize_as_(Tensor & self, const Tensor & the_template) const;
  virtual Tensor & resize_as_(Tensor & self, const Tensor & the_template) const;
  virtual Tensor & native_pow_out(Tensor & result, const Tensor & self, Scalar exponent) const;
  virtual Tensor native_pow(const Tensor & self, Scalar exponent) const;
  virtual Tensor & pow_out(Tensor & result, const Tensor & self, Scalar exponent) const;
  virtual Tensor pow(const Tensor & self, Scalar exponent) const;
  virtual Tensor & native_zero_(Tensor & self) const;
  virtual Tensor & zero_(Tensor & self) const;
  virtual Tensor & s_native_add_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & native_add_out(Tensor & result, const Tensor & self, SparseTensorRef other, Scalar alpha=1) const;
  virtual Tensor s_native_add(const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor native_add(const Tensor & self, SparseTensorRef other, Scalar alpha=1) const;
  virtual Tensor & s_native_add_(Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & native_add_(Tensor & self, SparseTensorRef other, Scalar alpha=1) const;
  virtual Tensor & add_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor add(const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & add_(Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & s_native_sub_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor s_native_sub(const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & s_native_sub_(Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & sub_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor sub(const Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & sub_(Tensor & self, const Tensor & other, Scalar alpha=1) const;
  virtual Tensor & s_native_mul_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor s_native_mul(const Tensor & self, const Tensor & other) const;
  virtual Tensor & s_native_mul_(Tensor & self, const Tensor & other) const;
  virtual Tensor & native_mul_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor native_mul(const Tensor & self, Scalar other) const;
  virtual Tensor & native_mul_(Tensor & self, Scalar other) const;
  virtual Tensor & mul_out(Tensor & result, const Tensor & self, const Tensor & other) const;
  virtual Tensor & mul_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor mul(const Tensor & self, const Tensor & other) const;
  virtual Tensor mul(const Tensor & self, Scalar other) const;
  virtual Tensor & mul_(Tensor & self, const Tensor & other) const;
  virtual Tensor & mul_(Tensor & self, Scalar other) const;
  virtual Tensor & native_div_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor native_div(const Tensor & self, Scalar other) const;
  virtual Tensor & native_div_(Tensor & self, Scalar other) const;
  virtual Tensor & div_out(Tensor & result, const Tensor & self, Scalar other) const;
  virtual Tensor div(const Tensor & self, Scalar other) const;
  virtual Tensor & div_(Tensor & self, Scalar other) const;
  virtual Tensor & s_native_addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor s_native_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & s_native_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor & addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1) const;
  virtual Tensor native_tensor() const;
  virtual Tensor native_tensor(IntList size) const;
  virtual Tensor tensor() const;
  virtual Tensor tensor(IntList size) const;
  virtual Tensor native_sparse_coo_tensor(const Tensor & indices, const Tensor & values) const;
  virtual Tensor native_sparse_coo_tensor(const Tensor & indices, const Tensor & values, IntList size) const;
  virtual Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values) const;
  virtual Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, IntList size) const;
  virtual Tensor _native_sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntList size) const;
  virtual Tensor _sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntList size) const;
  virtual Tensor & sparse_raw_resize_(Tensor & self, IntList size, int64_t sparseDims, int64_t denseDims) const;
  virtual Tensor _sparse_mask(const Tensor & self, SparseTensorRef mask) const;
  virtual Tensor to_dense(const Tensor & self) const;
  virtual int64_t _sparseDims(const Tensor & self) const;
  virtual int64_t _dimI(const Tensor & self) const;
  virtual int64_t _denseDims(const Tensor & self) const;
  virtual int64_t _dimV(const Tensor & self) const;
  virtual int64_t _nnz(const Tensor & self) const;
  virtual Tensor coalesce(const Tensor & self) const;
  virtual bool is_coalesced(const Tensor & self) const;
  virtual Tensor _indices(const Tensor & self) const;
  virtual Tensor _values(const Tensor & self) const;
  virtual Tensor & hspmm_out(Tensor & result, const Tensor & mat1, const Tensor & mat2) const;
  virtual Tensor hspmm(const Tensor & mat1, const Tensor & mat2) const;
  virtual Tensor & raw_copy_sparse_(Tensor & self, const Tensor & src) const;
  virtual int64_t numel(const Tensor & self) const;
  virtual std::vector<Tensor> unbind(const Tensor & self, int64_t dim=0) const;
  virtual int64_t native_get_device(const Tensor & self) const;
  virtual int64_t get_device(const Tensor & self) const;
  virtual std::vector<Tensor> meshgrid(TensorList tensors) const;
protected:
  Context* context;
  bool is_variable_;
  bool is_undefined_;

};

inline bool Tensor::is_variable() const noexcept {
  return type().is_variable();
}

inline ScalarType Tensor::dtype() const noexcept {
  return type().scalarType();
}

inline Layout Tensor::layout() const noexcept {
  return type().layout();
}

inline Device Tensor::device() const {
  return Device(type().backend(), type().is_cuda() ? get_device() : -1);
}

} // namespace at
