# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.analysis_access_info import AnalysisAccessInfo
from typing import Optional, Set
from typing_extensions import Self

class AnalysisDetailResponse(BaseModel):
    """
    AnalysisDetailResponse
    """ # noqa: E501
    access: AnalysisAccessInfo
    analysis_id: StrictInt
    analysis_scope: StrictStr
    architecture: StrictStr
    binary_dynamic: StrictBool
    binary_format: StrictStr
    binary_name: StrictStr
    binary_size: StrictInt
    binary_type: StrictStr
    creation: StrictStr
    debug: StrictBool
    model_name: StrictStr
    sbom: Optional[Dict[str, Any]] = None
    sha_256_hash: StrictStr
    __properties: ClassVar[List[str]] = ["access", "analysis_id", "analysis_scope", "architecture", "binary_dynamic", "binary_format", "binary_name", "binary_size", "binary_type", "creation", "debug", "model_name", "sbom", "sha_256_hash"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnalysisDetailResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of access
        if self.access:
            _dict['access'] = self.access.to_dict()
        # set to None if sbom (nullable) is None
        # and model_fields_set contains the field
        if self.sbom is None and "sbom" in self.model_fields_set:
            _dict['sbom'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnalysisDetailResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "access": AnalysisAccessInfo.from_dict(obj["access"]) if obj.get("access") is not None else None,
            "analysis_id": obj.get("analysis_id"),
            "analysis_scope": obj.get("analysis_scope"),
            "architecture": obj.get("architecture"),
            "binary_dynamic": obj.get("binary_dynamic"),
            "binary_format": obj.get("binary_format"),
            "binary_name": obj.get("binary_name"),
            "binary_size": obj.get("binary_size"),
            "binary_type": obj.get("binary_type"),
            "creation": obj.get("creation"),
            "debug": obj.get("debug"),
            "model_name": obj.get("model_name"),
            "sbom": obj.get("sbom"),
            "sha_256_hash": obj.get("sha_256_hash")
        })
        return _obj


