# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.matched_function_group import MatchedFunctionGroup
from typing import Optional, Set
from typing_extensions import Self

class AutoUnstripByGroupResponse(BaseModel):
    """
    AutoUnstripByGroupResponse
    """ # noqa: E501
    progress: Optional[StrictInt] = Field(default=0, description="Progress of the auto-unstrip operation, represented as a percentage")
    status: Optional[StrictStr] = None
    total_time: Optional[StrictInt] = None
    matches_map: Optional[Dict[str, List[MatchedFunctionGroup]]] = None
    applied: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["progress", "status", "total_time", "matches_map", "applied"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AutoUnstripByGroupResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in matches_map (dict of array)
        _field_dict_of_array = {}
        if self.matches_map:
            for _key_matches_map in self.matches_map:
                if self.matches_map[_key_matches_map] is not None:
                    _field_dict_of_array[_key_matches_map] = [
                        _item.to_dict() for _item in self.matches_map[_key_matches_map]
                    ]
            _dict['matches_map'] = _field_dict_of_array
        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if total_time (nullable) is None
        # and model_fields_set contains the field
        if self.total_time is None and "total_time" in self.model_fields_set:
            _dict['total_time'] = None

        # set to None if matches_map (nullable) is None
        # and model_fields_set contains the field
        if self.matches_map is None and "matches_map" in self.model_fields_set:
            _dict['matches_map'] = None

        # set to None if applied (nullable) is None
        # and model_fields_set contains the field
        if self.applied is None and "applied" in self.model_fields_set:
            _dict['applied'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AutoUnstripByGroupResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "progress": obj.get("progress") if obj.get("progress") is not None else 0,
            "status": obj.get("status"),
            "total_time": obj.get("total_time"),
            "matches_map": dict(
                (_k,
                        [MatchedFunctionGroup.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("matches_map", {}).items()
            ),
            "applied": obj.get("applied")
        })
        return _obj


