# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List
from revengai.models.community_match_percentages import CommunityMatchPercentages
from typing import Optional, Set
from typing_extensions import Self

class Communities(BaseModel):
    """
    Communities
    """ # noqa: E501
    total_functions: StrictInt = Field(description="The total number of matched community functions")
    total_matched_functions: StrictInt = Field(description="The total number of functions in the binary")
    direct_community_match_percentages: List[CommunityMatchPercentages] = Field(description="The list of directly matched communities")
    top_components: List[Dict[str, Any]] = Field(description="The top components of the binary")
    __properties: ClassVar[List[str]] = ["total_functions", "total_matched_functions", "direct_community_match_percentages", "top_components"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Communities from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in direct_community_match_percentages (list)
        _items = []
        if self.direct_community_match_percentages:
            for _item_direct_community_match_percentages in self.direct_community_match_percentages:
                if _item_direct_community_match_percentages:
                    _items.append(_item_direct_community_match_percentages.to_dict())
            _dict['direct_community_match_percentages'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Communities from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "total_functions": obj.get("total_functions"),
            "total_matched_functions": obj.get("total_matched_functions"),
            "direct_community_match_percentages": [CommunityMatchPercentages.from_dict(_item) for _item in obj["direct_community_match_percentages"]] if obj.get("direct_community_match_percentages") is not None else None,
            "top_components": obj.get("top_components")
        })
        return _obj


