# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.function_block_response import FunctionBlockResponse
from revengai.models.function_local_variable_response import FunctionLocalVariableResponse
from revengai.models.function_param_response import FunctionParamResponse
from typing import Optional, Set
from typing_extensions import Self

class FunctionBlocksResponse(BaseModel):
    """
    Response for returning disassembly of a function.
    """ # noqa: E501
    blocks: List[FunctionBlockResponse] = Field(description="Disassembly is broken into control flow blocks")
    local_variables: List[FunctionLocalVariableResponse] = Field(description="Local variables associated with this function")
    params: List[FunctionParamResponse] = Field(description="Params associated with this function")
    overview_comment: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["blocks", "local_variables", "params", "overview_comment"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionBlocksResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in blocks (list)
        _items = []
        if self.blocks:
            for _item_blocks in self.blocks:
                if _item_blocks:
                    _items.append(_item_blocks.to_dict())
            _dict['blocks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in local_variables (list)
        _items = []
        if self.local_variables:
            for _item_local_variables in self.local_variables:
                if _item_local_variables:
                    _items.append(_item_local_variables.to_dict())
            _dict['local_variables'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in params (list)
        _items = []
        if self.params:
            for _item_params in self.params:
                if _item_params:
                    _items.append(_item_params.to_dict())
            _dict['params'] = _items
        # set to None if overview_comment (nullable) is None
        # and model_fields_set contains the field
        if self.overview_comment is None and "overview_comment" in self.model_fields_set:
            _dict['overview_comment'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionBlocksResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "blocks": [FunctionBlockResponse.from_dict(_item) for _item in obj["blocks"]] if obj.get("blocks") is not None else None,
            "local_variables": [FunctionLocalVariableResponse.from_dict(_item) for _item in obj["local_variables"]] if obj.get("local_variables") is not None else None,
            "params": [FunctionParamResponse.from_dict(_item) for _item in obj["params"]] if obj.get("params") is not None else None,
            "overview_comment": obj.get("overview_comment")
        })
        return _obj


