# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.function_info_input_func_deps_inner import FunctionInfoInputFuncDepsInner
from revengai.models.function_type_output import FunctionTypeOutput
from typing import Optional, Set
from typing_extensions import Self

class FunctionInfoOutput(BaseModel):
    """
    FunctionInfoOutput
    """ # noqa: E501
    func_types: Optional[FunctionTypeOutput] = None
    func_deps: List[FunctionInfoInputFuncDepsInner] = Field(description="List of function dependencies")
    __properties: ClassVar[List[str]] = ["func_types", "func_deps"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionInfoOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of func_types
        if self.func_types:
            _dict['func_types'] = self.func_types.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in func_deps (list)
        _items = []
        if self.func_deps:
            for _item_func_deps in self.func_deps:
                if _item_func_deps:
                    _items.append(_item_func_deps.to_dict())
            _dict['func_deps'] = _items
        # set to None if func_types (nullable) is None
        # and model_fields_set contains the field
        if self.func_types is None and "func_types" in self.model_fields_set:
            _dict['func_types'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionInfoOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "func_types": FunctionTypeOutput.from_dict(obj["func_types"]) if obj.get("func_types") is not None else None,
            "func_deps": [FunctionInfoInputFuncDepsInner.from_dict(_item) for _item in obj["func_deps"]] if obj.get("func_deps") is not None else None
        })
        return _obj


