# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from revengai.models.inverse_function_map_item import InverseFunctionMapItem
from revengai.models.inverse_string_map_item import InverseStringMapItem
from revengai.models.inverse_value import InverseValue
from typing import Optional, Set
from typing_extensions import Self

class FunctionMappingFull(BaseModel):
    """
    FunctionMappingFull
    """ # noqa: E501
    inverse_string_map: Dict[str, InverseStringMapItem]
    inverse_function_map: Dict[str, InverseFunctionMapItem]
    unmatched_functions: Dict[str, InverseValue]
    unmatched_external_vars: Dict[str, InverseValue]
    unmatched_custom_types: Dict[str, InverseValue]
    unmatched_strings: Dict[str, InverseValue]
    unmatched_vars: Dict[str, InverseValue]
    unmatched_go_to_labels: Dict[str, InverseValue]
    unmatched_custom_function_pointers: Dict[str, InverseValue]
    unmatched_variadic_lists: Dict[str, InverseValue]
    fields: Dict[str, Dict[str, InverseValue]]
    __properties: ClassVar[List[str]] = ["inverse_string_map", "inverse_function_map", "unmatched_functions", "unmatched_external_vars", "unmatched_custom_types", "unmatched_strings", "unmatched_vars", "unmatched_go_to_labels", "unmatched_custom_function_pointers", "unmatched_variadic_lists", "fields"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionMappingFull from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in inverse_string_map (dict)
        _field_dict = {}
        if self.inverse_string_map:
            for _key_inverse_string_map in self.inverse_string_map:
                if self.inverse_string_map[_key_inverse_string_map]:
                    _field_dict[_key_inverse_string_map] = self.inverse_string_map[_key_inverse_string_map].to_dict()
            _dict['inverse_string_map'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in inverse_function_map (dict)
        _field_dict = {}
        if self.inverse_function_map:
            for _key_inverse_function_map in self.inverse_function_map:
                if self.inverse_function_map[_key_inverse_function_map]:
                    _field_dict[_key_inverse_function_map] = self.inverse_function_map[_key_inverse_function_map].to_dict()
            _dict['inverse_function_map'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in unmatched_functions (dict)
        _field_dict = {}
        if self.unmatched_functions:
            for _key_unmatched_functions in self.unmatched_functions:
                if self.unmatched_functions[_key_unmatched_functions]:
                    _field_dict[_key_unmatched_functions] = self.unmatched_functions[_key_unmatched_functions].to_dict()
            _dict['unmatched_functions'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in unmatched_external_vars (dict)
        _field_dict = {}
        if self.unmatched_external_vars:
            for _key_unmatched_external_vars in self.unmatched_external_vars:
                if self.unmatched_external_vars[_key_unmatched_external_vars]:
                    _field_dict[_key_unmatched_external_vars] = self.unmatched_external_vars[_key_unmatched_external_vars].to_dict()
            _dict['unmatched_external_vars'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in unmatched_custom_types (dict)
        _field_dict = {}
        if self.unmatched_custom_types:
            for _key_unmatched_custom_types in self.unmatched_custom_types:
                if self.unmatched_custom_types[_key_unmatched_custom_types]:
                    _field_dict[_key_unmatched_custom_types] = self.unmatched_custom_types[_key_unmatched_custom_types].to_dict()
            _dict['unmatched_custom_types'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in unmatched_strings (dict)
        _field_dict = {}
        if self.unmatched_strings:
            for _key_unmatched_strings in self.unmatched_strings:
                if self.unmatched_strings[_key_unmatched_strings]:
                    _field_dict[_key_unmatched_strings] = self.unmatched_strings[_key_unmatched_strings].to_dict()
            _dict['unmatched_strings'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in unmatched_vars (dict)
        _field_dict = {}
        if self.unmatched_vars:
            for _key_unmatched_vars in self.unmatched_vars:
                if self.unmatched_vars[_key_unmatched_vars]:
                    _field_dict[_key_unmatched_vars] = self.unmatched_vars[_key_unmatched_vars].to_dict()
            _dict['unmatched_vars'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in unmatched_go_to_labels (dict)
        _field_dict = {}
        if self.unmatched_go_to_labels:
            for _key_unmatched_go_to_labels in self.unmatched_go_to_labels:
                if self.unmatched_go_to_labels[_key_unmatched_go_to_labels]:
                    _field_dict[_key_unmatched_go_to_labels] = self.unmatched_go_to_labels[_key_unmatched_go_to_labels].to_dict()
            _dict['unmatched_go_to_labels'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in unmatched_custom_function_pointers (dict)
        _field_dict = {}
        if self.unmatched_custom_function_pointers:
            for _key_unmatched_custom_function_pointers in self.unmatched_custom_function_pointers:
                if self.unmatched_custom_function_pointers[_key_unmatched_custom_function_pointers]:
                    _field_dict[_key_unmatched_custom_function_pointers] = self.unmatched_custom_function_pointers[_key_unmatched_custom_function_pointers].to_dict()
            _dict['unmatched_custom_function_pointers'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in unmatched_variadic_lists (dict)
        _field_dict = {}
        if self.unmatched_variadic_lists:
            for _key_unmatched_variadic_lists in self.unmatched_variadic_lists:
                if self.unmatched_variadic_lists[_key_unmatched_variadic_lists]:
                    _field_dict[_key_unmatched_variadic_lists] = self.unmatched_variadic_lists[_key_unmatched_variadic_lists].to_dict()
            _dict['unmatched_variadic_lists'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in fields (dict)
        _field_dict = {}
        if self.fields:
            for _key_fields in self.fields:
                if self.fields[_key_fields]:
                    _field_dict[_key_fields] = self.fields[_key_fields].to_dict()
            _dict['fields'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionMappingFull from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "inverse_string_map": dict(
                (_k, InverseStringMapItem.from_dict(_v))
                for _k, _v in obj["inverse_string_map"].items()
            )
            if obj.get("inverse_string_map") is not None
            else None,
            "inverse_function_map": dict(
                (_k, InverseFunctionMapItem.from_dict(_v))
                for _k, _v in obj["inverse_function_map"].items()
            )
            if obj.get("inverse_function_map") is not None
            else None,
            "unmatched_functions": dict(
                (_k, InverseValue.from_dict(_v))
                for _k, _v in obj["unmatched_functions"].items()
            )
            if obj.get("unmatched_functions") is not None
            else None,
            "unmatched_external_vars": dict(
                (_k, InverseValue.from_dict(_v))
                for _k, _v in obj["unmatched_external_vars"].items()
            )
            if obj.get("unmatched_external_vars") is not None
            else None,
            "unmatched_custom_types": dict(
                (_k, InverseValue.from_dict(_v))
                for _k, _v in obj["unmatched_custom_types"].items()
            )
            if obj.get("unmatched_custom_types") is not None
            else None,
            "unmatched_strings": dict(
                (_k, InverseValue.from_dict(_v))
                for _k, _v in obj["unmatched_strings"].items()
            )
            if obj.get("unmatched_strings") is not None
            else None,
            "unmatched_vars": dict(
                (_k, InverseValue.from_dict(_v))
                for _k, _v in obj["unmatched_vars"].items()
            )
            if obj.get("unmatched_vars") is not None
            else None,
            "unmatched_go_to_labels": dict(
                (_k, InverseValue.from_dict(_v))
                for _k, _v in obj["unmatched_go_to_labels"].items()
            )
            if obj.get("unmatched_go_to_labels") is not None
            else None,
            "unmatched_custom_function_pointers": dict(
                (_k, InverseValue.from_dict(_v))
                for _k, _v in obj["unmatched_custom_function_pointers"].items()
            )
            if obj.get("unmatched_custom_function_pointers") is not None
            else None,
            "unmatched_variadic_lists": dict(
                (_k, InverseValue.from_dict(_v))
                for _k, _v in obj["unmatched_variadic_lists"].items()
            )
            if obj.get("unmatched_variadic_lists") is not None
            else None,
            "fields": dict(
                (_k, dict(
                    (_ik, InverseValue.from_dict(_iv))
                        for _ik, _iv in _v.items()
                    )
                    if _v is not None
                    else None
                )
                for _k, _v in obj.get("fields").items()
            )
            if obj.get("fields") is not None
            else None
        })
        return _obj


