# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.code_signature_model import CodeSignatureModel
from revengai.models.entrypoint_model import EntrypointModel
from revengai.models.export_model import ExportModel
from revengai.models.icon_model import IconModel
from revengai.models.import_model import ImportModel
from revengai.models.pdb_debug_model import PDBDebugModel
from revengai.models.section_model import SectionModel
from revengai.models.security_model import SecurityModel
from revengai.models.timestamp_model import TimestampModel
from typing import Optional, Set
from typing_extensions import Self

class PEModel(BaseModel):
    """
    PEModel
    """ # noqa: E501
    type: StrictStr
    timestamps: Optional[TimestampModel]
    architecture: StrictStr
    checksum: StrictInt
    image_base: StrictInt
    security: Optional[SecurityModel]
    version_info: Optional[Dict[str, Any]]
    debug_info: Optional[PDBDebugModel]
    number_of_resources: Optional[StrictInt]
    entry_point: Optional[EntrypointModel]
    signature: Optional[CodeSignatureModel]
    dotnet: StrictBool
    debug_stripped: StrictBool
    import_hash: StrictStr
    export_hash: StrictStr
    rich_header_hash: StrictStr
    sections: Optional[SectionModel]
    imports: Optional[ImportModel]
    exports: Optional[ExportModel]
    icon_data: Optional[IconModel]
    __properties: ClassVar[List[str]] = ["type", "timestamps", "architecture", "checksum", "image_base", "security", "version_info", "debug_info", "number_of_resources", "entry_point", "signature", "dotnet", "debug_stripped", "import_hash", "export_hash", "rich_header_hash", "sections", "imports", "exports", "icon_data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PEModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of timestamps
        if self.timestamps:
            _dict['timestamps'] = self.timestamps.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        # override the default output from pydantic by calling `to_dict()` of debug_info
        if self.debug_info:
            _dict['debug_info'] = self.debug_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entry_point
        if self.entry_point:
            _dict['entry_point'] = self.entry_point.to_dict()
        # override the default output from pydantic by calling `to_dict()` of signature
        if self.signature:
            _dict['signature'] = self.signature.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sections
        if self.sections:
            _dict['sections'] = self.sections.to_dict()
        # override the default output from pydantic by calling `to_dict()` of imports
        if self.imports:
            _dict['imports'] = self.imports.to_dict()
        # override the default output from pydantic by calling `to_dict()` of exports
        if self.exports:
            _dict['exports'] = self.exports.to_dict()
        # override the default output from pydantic by calling `to_dict()` of icon_data
        if self.icon_data:
            _dict['icon_data'] = self.icon_data.to_dict()
        # set to None if timestamps (nullable) is None
        # and model_fields_set contains the field
        if self.timestamps is None and "timestamps" in self.model_fields_set:
            _dict['timestamps'] = None

        # set to None if security (nullable) is None
        # and model_fields_set contains the field
        if self.security is None and "security" in self.model_fields_set:
            _dict['security'] = None

        # set to None if version_info (nullable) is None
        # and model_fields_set contains the field
        if self.version_info is None and "version_info" in self.model_fields_set:
            _dict['version_info'] = None

        # set to None if debug_info (nullable) is None
        # and model_fields_set contains the field
        if self.debug_info is None and "debug_info" in self.model_fields_set:
            _dict['debug_info'] = None

        # set to None if number_of_resources (nullable) is None
        # and model_fields_set contains the field
        if self.number_of_resources is None and "number_of_resources" in self.model_fields_set:
            _dict['number_of_resources'] = None

        # set to None if entry_point (nullable) is None
        # and model_fields_set contains the field
        if self.entry_point is None and "entry_point" in self.model_fields_set:
            _dict['entry_point'] = None

        # set to None if signature (nullable) is None
        # and model_fields_set contains the field
        if self.signature is None and "signature" in self.model_fields_set:
            _dict['signature'] = None

        # set to None if sections (nullable) is None
        # and model_fields_set contains the field
        if self.sections is None and "sections" in self.model_fields_set:
            _dict['sections'] = None

        # set to None if imports (nullable) is None
        # and model_fields_set contains the field
        if self.imports is None and "imports" in self.model_fields_set:
            _dict['imports'] = None

        # set to None if exports (nullable) is None
        # and model_fields_set contains the field
        if self.exports is None and "exports" in self.model_fields_set:
            _dict['exports'] = None

        # set to None if icon_data (nullable) is None
        # and model_fields_set contains the field
        if self.icon_data is None and "icon_data" in self.model_fields_set:
            _dict['icon_data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PEModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "timestamps": TimestampModel.from_dict(obj["timestamps"]) if obj.get("timestamps") is not None else None,
            "architecture": obj.get("architecture"),
            "checksum": obj.get("checksum"),
            "image_base": obj.get("image_base"),
            "security": SecurityModel.from_dict(obj["security"]) if obj.get("security") is not None else None,
            "version_info": obj.get("version_info"),
            "debug_info": PDBDebugModel.from_dict(obj["debug_info"]) if obj.get("debug_info") is not None else None,
            "number_of_resources": obj.get("number_of_resources"),
            "entry_point": EntrypointModel.from_dict(obj["entry_point"]) if obj.get("entry_point") is not None else None,
            "signature": CodeSignatureModel.from_dict(obj["signature"]) if obj.get("signature") is not None else None,
            "dotnet": obj.get("dotnet"),
            "debug_stripped": obj.get("debug_stripped"),
            "import_hash": obj.get("import_hash"),
            "export_hash": obj.get("export_hash"),
            "rich_header_hash": obj.get("rich_header_hash"),
            "sections": SectionModel.from_dict(obj["sections"]) if obj.get("sections") is not None else None,
            "imports": ImportModel.from_dict(obj["imports"]) if obj.get("imports") is not None else None,
            "exports": ExportModel.from_dict(obj["exports"]) if obj.get("exports") is not None else None,
            "icon_data": IconModel.from_dict(obj["icon_data"]) if obj.get("icon_data") is not None else None
        })
        return _obj


