# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.structure_member import StructureMember
from typing import Optional, Set
from typing_extensions import Self

class Structure(BaseModel):
    """
    Structure
    """ # noqa: E501
    last_change: Optional[StrictStr] = None
    name: StrictStr = Field(description="Name of the structure")
    size: Optional[StrictInt] = None
    members: Dict[str, StructureMember] = Field(description="Dictionary of structure members")
    artifact_type: Optional[StrictStr] = Field(default=None, description="Type of artifact that the structure is associated with")
    __properties: ClassVar[List[str]] = ["last_change", "name", "size", "members", "artifact_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Structure from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in members (dict)
        _field_dict = {}
        if self.members:
            for _key_members in self.members:
                if self.members[_key_members]:
                    _field_dict[_key_members] = self.members[_key_members].to_dict()
            _dict['members'] = _field_dict
        # set to None if last_change (nullable) is None
        # and model_fields_set contains the field
        if self.last_change is None and "last_change" in self.model_fields_set:
            _dict['last_change'] = None

        # set to None if size (nullable) is None
        # and model_fields_set contains the field
        if self.size is None and "size" in self.model_fields_set:
            _dict['size'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Structure from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "last_change": obj.get("last_change"),
            "name": obj.get("name"),
            "size": obj.get("size"),
            "members": dict(
                (_k, StructureMember.from_dict(_v))
                for _k, _v in obj["members"].items()
            )
            if obj.get("members") is not None
            else None,
            "artifact_type": obj.get("artifact_type")
        })
        return _obj


