
# python wrapper for package codeberg.org/slidge/slidge-whatsapp/slidge_whatsapp within overall package whatsapp
# This is what you import to use the package.
# File is generated by gopy. Do not edit.
# gopy build -output=generated -no-make=true -build-tags="mupdf extlib static" .

# the following is required to enable dlopen to open the _go.so file
import os,sys,inspect,collections
try:
	import collections.abc as _collections_abc
except ImportError:
	_collections_abc = collections

cwd = os.getcwd()
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
os.chdir(currentdir)
from . import _whatsapp
from . import go

os.chdir(cwd)

# to use this code in your end-user python file, import it as follows:
# from whatsapp import whatsapp
# and then refer to everything using whatsapp. prefix
# packages imported by this package listed below:




# ---- Types ---

# Python type for slice []whatsapp.Attachment
class Slice_whatsapp_Attachment(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.Slice_whatsapp_Attachment_CTor()
			_whatsapp.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Iterable):
					raise TypeError('Slice_whatsapp_Attachment.__init__ takes a sequence as argument')
				for elt in args[0]:
					self.append(elt)
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		s = 'whatsapp.Slice_whatsapp_Attachment len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' ['
		if len(self) < 120:
			s += ', '.join(map(str, self)) + ']'
		return s
	def __repr__(self):
		return 'whatsapp.Slice_whatsapp_Attachment([' + ', '.join(map(str, self)) + '])'
	def __len__(self):
		return _whatsapp.Slice_whatsapp_Attachment_len(self.handle)
	def __getitem__(self, key):
		if isinstance(key, slice):
			if key.step == None or key.step == 1:
				st = key.start
				ed = key.stop
				if st == None:
					st = 0
				if ed == None:
					ed = _whatsapp.Slice_whatsapp_Attachment_len(self.handle)
				return Slice_whatsapp_Attachment(handle=_whatsapp.Slice_whatsapp_Attachment_subslice(self.handle, st, ed))
			return [self[ii] for ii in range(*key.indices(len(self)))]
		elif isinstance(key, int):
			if key < 0:
				key += len(self)
			if key < 0 or key >= len(self):
				raise IndexError('slice index out of range')
			return Attachment(handle=_whatsapp.Slice_whatsapp_Attachment_elem(self.handle, key))
		else:
			raise TypeError('slice index invalid type')
	def __setitem__(self, idx, value):
		if idx < 0:
			idx += len(self)
		if idx < len(self):
			_whatsapp.Slice_whatsapp_Attachment_set(self.handle, idx, value.handle)
			return
		raise IndexError('slice index out of range')
	def __iadd__(self, value):
		if not isinstance(value, _collections_abc.Iterable):
			raise TypeError('Slice_whatsapp_Attachment.__iadd__ takes a sequence as argument')
		for elt in value:
			self.append(elt)
		return self
	def __iter__(self):
		self.index = 0
		return self
	def __next__(self):
		if self.index < len(self):
			rv = Attachment(handle=_whatsapp.Slice_whatsapp_Attachment_elem(self.handle, self.index))
			self.index = self.index + 1
			return rv
		raise StopIteration
	def append(self, value):
		_whatsapp.Slice_whatsapp_Attachment_append(self.handle, value.handle)
	def copy(self, src):
		""" copy emulates the go copy function, copying elements into this list from source list, up to min of size of each list """
		mx = min(len(self), len(src))
		for i in range(mx):
			self[i] = src[i]

# Python type for slice []whatsapp.Contact
class Slice_whatsapp_Contact(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.Slice_whatsapp_Contact_CTor()
			_whatsapp.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Iterable):
					raise TypeError('Slice_whatsapp_Contact.__init__ takes a sequence as argument')
				for elt in args[0]:
					self.append(elt)
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		s = 'whatsapp.Slice_whatsapp_Contact len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' ['
		if len(self) < 120:
			s += ', '.join(map(str, self)) + ']'
		return s
	def __repr__(self):
		return 'whatsapp.Slice_whatsapp_Contact([' + ', '.join(map(str, self)) + '])'
	def __len__(self):
		return _whatsapp.Slice_whatsapp_Contact_len(self.handle)
	def __getitem__(self, key):
		if isinstance(key, slice):
			if key.step == None or key.step == 1:
				st = key.start
				ed = key.stop
				if st == None:
					st = 0
				if ed == None:
					ed = _whatsapp.Slice_whatsapp_Contact_len(self.handle)
				return Slice_whatsapp_Contact(handle=_whatsapp.Slice_whatsapp_Contact_subslice(self.handle, st, ed))
			return [self[ii] for ii in range(*key.indices(len(self)))]
		elif isinstance(key, int):
			if key < 0:
				key += len(self)
			if key < 0 or key >= len(self):
				raise IndexError('slice index out of range')
			return Contact(handle=_whatsapp.Slice_whatsapp_Contact_elem(self.handle, key))
		else:
			raise TypeError('slice index invalid type')
	def __setitem__(self, idx, value):
		if idx < 0:
			idx += len(self)
		if idx < len(self):
			_whatsapp.Slice_whatsapp_Contact_set(self.handle, idx, value.handle)
			return
		raise IndexError('slice index out of range')
	def __iadd__(self, value):
		if not isinstance(value, _collections_abc.Iterable):
			raise TypeError('Slice_whatsapp_Contact.__iadd__ takes a sequence as argument')
		for elt in value:
			self.append(elt)
		return self
	def __iter__(self):
		self.index = 0
		return self
	def __next__(self):
		if self.index < len(self):
			rv = Contact(handle=_whatsapp.Slice_whatsapp_Contact_elem(self.handle, self.index))
			self.index = self.index + 1
			return rv
		raise StopIteration
	def append(self, value):
		_whatsapp.Slice_whatsapp_Contact_append(self.handle, value.handle)
	def copy(self, src):
		""" copy emulates the go copy function, copying elements into this list from source list, up to min of size of each list """
		mx = min(len(self), len(src))
		for i in range(mx):
			self[i] = src[i]

# Python type for slice []whatsapp.Group
class Slice_whatsapp_Group(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.Slice_whatsapp_Group_CTor()
			_whatsapp.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Iterable):
					raise TypeError('Slice_whatsapp_Group.__init__ takes a sequence as argument')
				for elt in args[0]:
					self.append(elt)
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		s = 'whatsapp.Slice_whatsapp_Group len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' ['
		if len(self) < 120:
			s += ', '.join(map(str, self)) + ']'
		return s
	def __repr__(self):
		return 'whatsapp.Slice_whatsapp_Group([' + ', '.join(map(str, self)) + '])'
	def __len__(self):
		return _whatsapp.Slice_whatsapp_Group_len(self.handle)
	def __getitem__(self, key):
		if isinstance(key, slice):
			if key.step == None or key.step == 1:
				st = key.start
				ed = key.stop
				if st == None:
					st = 0
				if ed == None:
					ed = _whatsapp.Slice_whatsapp_Group_len(self.handle)
				return Slice_whatsapp_Group(handle=_whatsapp.Slice_whatsapp_Group_subslice(self.handle, st, ed))
			return [self[ii] for ii in range(*key.indices(len(self)))]
		elif isinstance(key, int):
			if key < 0:
				key += len(self)
			if key < 0 or key >= len(self):
				raise IndexError('slice index out of range')
			return Group(handle=_whatsapp.Slice_whatsapp_Group_elem(self.handle, key))
		else:
			raise TypeError('slice index invalid type')
	def __setitem__(self, idx, value):
		if idx < 0:
			idx += len(self)
		if idx < len(self):
			_whatsapp.Slice_whatsapp_Group_set(self.handle, idx, value.handle)
			return
		raise IndexError('slice index out of range')
	def __iadd__(self, value):
		if not isinstance(value, _collections_abc.Iterable):
			raise TypeError('Slice_whatsapp_Group.__iadd__ takes a sequence as argument')
		for elt in value:
			self.append(elt)
		return self
	def __iter__(self):
		self.index = 0
		return self
	def __next__(self):
		if self.index < len(self):
			rv = Group(handle=_whatsapp.Slice_whatsapp_Group_elem(self.handle, self.index))
			self.index = self.index + 1
			return rv
		raise StopIteration
	def append(self, value):
		_whatsapp.Slice_whatsapp_Group_append(self.handle, value.handle)
	def copy(self, src):
		""" copy emulates the go copy function, copying elements into this list from source list, up to min of size of each list """
		mx = min(len(self), len(src))
		for i in range(mx):
			self[i] = src[i]

# Python type for slice []whatsapp.GroupParticipant
class Slice_whatsapp_GroupParticipant(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.Slice_whatsapp_GroupParticipant_CTor()
			_whatsapp.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Iterable):
					raise TypeError('Slice_whatsapp_GroupParticipant.__init__ takes a sequence as argument')
				for elt in args[0]:
					self.append(elt)
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		s = 'whatsapp.Slice_whatsapp_GroupParticipant len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' ['
		if len(self) < 120:
			s += ', '.join(map(str, self)) + ']'
		return s
	def __repr__(self):
		return 'whatsapp.Slice_whatsapp_GroupParticipant([' + ', '.join(map(str, self)) + '])'
	def __len__(self):
		return _whatsapp.Slice_whatsapp_GroupParticipant_len(self.handle)
	def __getitem__(self, key):
		if isinstance(key, slice):
			if key.step == None or key.step == 1:
				st = key.start
				ed = key.stop
				if st == None:
					st = 0
				if ed == None:
					ed = _whatsapp.Slice_whatsapp_GroupParticipant_len(self.handle)
				return Slice_whatsapp_GroupParticipant(handle=_whatsapp.Slice_whatsapp_GroupParticipant_subslice(self.handle, st, ed))
			return [self[ii] for ii in range(*key.indices(len(self)))]
		elif isinstance(key, int):
			if key < 0:
				key += len(self)
			if key < 0 or key >= len(self):
				raise IndexError('slice index out of range')
			return GroupParticipant(handle=_whatsapp.Slice_whatsapp_GroupParticipant_elem(self.handle, key))
		else:
			raise TypeError('slice index invalid type')
	def __setitem__(self, idx, value):
		if idx < 0:
			idx += len(self)
		if idx < len(self):
			_whatsapp.Slice_whatsapp_GroupParticipant_set(self.handle, idx, value.handle)
			return
		raise IndexError('slice index out of range')
	def __iadd__(self, value):
		if not isinstance(value, _collections_abc.Iterable):
			raise TypeError('Slice_whatsapp_GroupParticipant.__iadd__ takes a sequence as argument')
		for elt in value:
			self.append(elt)
		return self
	def __iter__(self):
		self.index = 0
		return self
	def __next__(self):
		if self.index < len(self):
			rv = GroupParticipant(handle=_whatsapp.Slice_whatsapp_GroupParticipant_elem(self.handle, self.index))
			self.index = self.index + 1
			return rv
		raise StopIteration
	def append(self, value):
		_whatsapp.Slice_whatsapp_GroupParticipant_append(self.handle, value.handle)
	def copy(self, src):
		""" copy emulates the go copy function, copying elements into this list from source list, up to min of size of each list """
		mx = min(len(self), len(src))
		for i in range(mx):
			self[i] = src[i]

# Python type for slice []whatsapp.Message
class Slice_whatsapp_Message(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.Slice_whatsapp_Message_CTor()
			_whatsapp.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Iterable):
					raise TypeError('Slice_whatsapp_Message.__init__ takes a sequence as argument')
				for elt in args[0]:
					self.append(elt)
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		s = 'whatsapp.Slice_whatsapp_Message len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' ['
		if len(self) < 120:
			s += ', '.join(map(str, self)) + ']'
		return s
	def __repr__(self):
		return 'whatsapp.Slice_whatsapp_Message([' + ', '.join(map(str, self)) + '])'
	def __len__(self):
		return _whatsapp.Slice_whatsapp_Message_len(self.handle)
	def __getitem__(self, key):
		if isinstance(key, slice):
			if key.step == None or key.step == 1:
				st = key.start
				ed = key.stop
				if st == None:
					st = 0
				if ed == None:
					ed = _whatsapp.Slice_whatsapp_Message_len(self.handle)
				return Slice_whatsapp_Message(handle=_whatsapp.Slice_whatsapp_Message_subslice(self.handle, st, ed))
			return [self[ii] for ii in range(*key.indices(len(self)))]
		elif isinstance(key, int):
			if key < 0:
				key += len(self)
			if key < 0 or key >= len(self):
				raise IndexError('slice index out of range')
			return Message(handle=_whatsapp.Slice_whatsapp_Message_elem(self.handle, key))
		else:
			raise TypeError('slice index invalid type')
	def __setitem__(self, idx, value):
		if idx < 0:
			idx += len(self)
		if idx < len(self):
			_whatsapp.Slice_whatsapp_Message_set(self.handle, idx, value.handle)
			return
		raise IndexError('slice index out of range')
	def __iadd__(self, value):
		if not isinstance(value, _collections_abc.Iterable):
			raise TypeError('Slice_whatsapp_Message.__iadd__ takes a sequence as argument')
		for elt in value:
			self.append(elt)
		return self
	def __iter__(self):
		self.index = 0
		return self
	def __next__(self):
		if self.index < len(self):
			rv = Message(handle=_whatsapp.Slice_whatsapp_Message_elem(self.handle, self.index))
			self.index = self.index + 1
			return rv
		raise StopIteration
	def append(self, value):
		_whatsapp.Slice_whatsapp_Message_append(self.handle, value.handle)
	def copy(self, src):
		""" copy emulates the go copy function, copying elements into this list from source list, up to min of size of each list """
		mx = min(len(self), len(src))
		for i in range(mx):
			self[i] = src[i]

# Python type for slice []whatsapp.PollOption
class Slice_whatsapp_PollOption(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.Slice_whatsapp_PollOption_CTor()
			_whatsapp.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Iterable):
					raise TypeError('Slice_whatsapp_PollOption.__init__ takes a sequence as argument')
				for elt in args[0]:
					self.append(elt)
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		s = 'whatsapp.Slice_whatsapp_PollOption len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' ['
		if len(self) < 120:
			s += ', '.join(map(str, self)) + ']'
		return s
	def __repr__(self):
		return 'whatsapp.Slice_whatsapp_PollOption([' + ', '.join(map(str, self)) + '])'
	def __len__(self):
		return _whatsapp.Slice_whatsapp_PollOption_len(self.handle)
	def __getitem__(self, key):
		if isinstance(key, slice):
			if key.step == None or key.step == 1:
				st = key.start
				ed = key.stop
				if st == None:
					st = 0
				if ed == None:
					ed = _whatsapp.Slice_whatsapp_PollOption_len(self.handle)
				return Slice_whatsapp_PollOption(handle=_whatsapp.Slice_whatsapp_PollOption_subslice(self.handle, st, ed))
			return [self[ii] for ii in range(*key.indices(len(self)))]
		elif isinstance(key, int):
			if key < 0:
				key += len(self)
			if key < 0 or key >= len(self):
				raise IndexError('slice index out of range')
			return PollOption(handle=_whatsapp.Slice_whatsapp_PollOption_elem(self.handle, key))
		else:
			raise TypeError('slice index invalid type')
	def __setitem__(self, idx, value):
		if idx < 0:
			idx += len(self)
		if idx < len(self):
			_whatsapp.Slice_whatsapp_PollOption_set(self.handle, idx, value.handle)
			return
		raise IndexError('slice index out of range')
	def __iadd__(self, value):
		if not isinstance(value, _collections_abc.Iterable):
			raise TypeError('Slice_whatsapp_PollOption.__iadd__ takes a sequence as argument')
		for elt in value:
			self.append(elt)
		return self
	def __iter__(self):
		self.index = 0
		return self
	def __next__(self):
		if self.index < len(self):
			rv = PollOption(handle=_whatsapp.Slice_whatsapp_PollOption_elem(self.handle, self.index))
			self.index = self.index + 1
			return rv
		raise StopIteration
	def append(self, value):
		_whatsapp.Slice_whatsapp_PollOption_append(self.handle, value.handle)
	def copy(self, src):
		""" copy emulates the go copy function, copying elements into this list from source list, up to min of size of each list """
		mx = min(len(self), len(src))
		for i in range(mx):
			self[i] = src[i]

# Python type for slice []whatsapp.Receipt
class Slice_whatsapp_Receipt(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.Slice_whatsapp_Receipt_CTor()
			_whatsapp.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Iterable):
					raise TypeError('Slice_whatsapp_Receipt.__init__ takes a sequence as argument')
				for elt in args[0]:
					self.append(elt)
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		s = 'whatsapp.Slice_whatsapp_Receipt len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' ['
		if len(self) < 120:
			s += ', '.join(map(str, self)) + ']'
		return s
	def __repr__(self):
		return 'whatsapp.Slice_whatsapp_Receipt([' + ', '.join(map(str, self)) + '])'
	def __len__(self):
		return _whatsapp.Slice_whatsapp_Receipt_len(self.handle)
	def __getitem__(self, key):
		if isinstance(key, slice):
			if key.step == None or key.step == 1:
				st = key.start
				ed = key.stop
				if st == None:
					st = 0
				if ed == None:
					ed = _whatsapp.Slice_whatsapp_Receipt_len(self.handle)
				return Slice_whatsapp_Receipt(handle=_whatsapp.Slice_whatsapp_Receipt_subslice(self.handle, st, ed))
			return [self[ii] for ii in range(*key.indices(len(self)))]
		elif isinstance(key, int):
			if key < 0:
				key += len(self)
			if key < 0 or key >= len(self):
				raise IndexError('slice index out of range')
			return Receipt(handle=_whatsapp.Slice_whatsapp_Receipt_elem(self.handle, key))
		else:
			raise TypeError('slice index invalid type')
	def __setitem__(self, idx, value):
		if idx < 0:
			idx += len(self)
		if idx < len(self):
			_whatsapp.Slice_whatsapp_Receipt_set(self.handle, idx, value.handle)
			return
		raise IndexError('slice index out of range')
	def __iadd__(self, value):
		if not isinstance(value, _collections_abc.Iterable):
			raise TypeError('Slice_whatsapp_Receipt.__iadd__ takes a sequence as argument')
		for elt in value:
			self.append(elt)
		return self
	def __iter__(self):
		self.index = 0
		return self
	def __next__(self):
		if self.index < len(self):
			rv = Receipt(handle=_whatsapp.Slice_whatsapp_Receipt_elem(self.handle, self.index))
			self.index = self.index + 1
			return rv
		raise StopIteration
	def append(self, value):
		_whatsapp.Slice_whatsapp_Receipt_append(self.handle, value.handle)
	def copy(self, src):
		""" copy emulates the go copy function, copying elements into this list from source list, up to min of size of each list """
		mx = min(len(self), len(src))
		for i in range(mx):
			self[i] = src[i]


#---- Enums from Go (collections of consts with same type) ---
from enum import Enum

class CallState(Enum):
	"""
	CallState represents the state of the call to synchronize with.
	
	"""
	CallUnknown = 0
	"""
	The call states handled by the overarching session event handler.
	
	"""
	CallIncoming = 1
	"""
	The call states handled by the overarching session event handler.
	
	"""
	CallMissed = 2
	"""
	The call states handled by the overarching session event handler.
	
	"""

CallUnknown = 0
"""
The call states handled by the overarching session event handler.

"""
CallIncoming = 1
"""
The call states handled by the overarching session event handler.

"""
CallMissed = 2
"""
The call states handled by the overarching session event handler.

"""

class ChatStateKind(Enum):
	"""
	ChatStateKind represents the different kinds of chat-states possible in WhatsApp.
	
	"""
	ChatStateUnknown = 0
	"""
	The chat states handled by the overarching session event handler.
	
	"""
	ChatStateComposing = 1
	"""
	The chat states handled by the overarching session event handler.
	
	"""
	ChatStatePaused = 2
	"""
	The chat states handled by the overarching session event handler.
	
	"""

ChatStateUnknown = 0
"""
The chat states handled by the overarching session event handler.

"""
ChatStateComposing = 1
"""
The chat states handled by the overarching session event handler.

"""
ChatStatePaused = 2
"""
The chat states handled by the overarching session event handler.

"""

class EventKind(Enum):
	"""
	EventKind represents all event types recognized by the Python session adapter, as emitted by the
	Go session adapter.
	
	"""
	EventUnknown = 0
	"""
	The event types handled by the overarching session adapter handler.
	
	"""
	EventQRCode = 1
	"""
	The event types handled by the overarching session adapter handler.
	
	"""
	EventPair = 2
	"""
	The event types handled by the overarching session adapter handler.
	
	"""
	EventConnect = 3
	"""
	The event types handled by the overarching session adapter handler.
	
	"""
	EventLoggedOut = 4
	"""
	The event types handled by the overarching session adapter handler.
	
	"""
	EventContact = 5
	"""
	The event types handled by the overarching session adapter handler.
	
	"""
	EventPresence = 6
	"""
	The event types handled by the overarching session adapter handler.
	
	"""
	EventMessage = 7
	"""
	The event types handled by the overarching session adapter handler.
	
	"""
	EventChatState = 8
	"""
	The event types handled by the overarching session adapter handler.
	
	"""
	EventReceipt = 9
	"""
	The event types handled by the overarching session adapter handler.
	
	"""
	EventGroup = 10
	"""
	The event types handled by the overarching session adapter handler.
	
	"""
	EventCall = 11
	"""
	The event types handled by the overarching session adapter handler.
	
	"""

EventUnknown = 0
"""
The event types handled by the overarching session adapter handler.

"""
EventQRCode = 1
"""
The event types handled by the overarching session adapter handler.

"""
EventPair = 2
"""
The event types handled by the overarching session adapter handler.

"""
EventConnect = 3
"""
The event types handled by the overarching session adapter handler.

"""
EventLoggedOut = 4
"""
The event types handled by the overarching session adapter handler.

"""
EventContact = 5
"""
The event types handled by the overarching session adapter handler.

"""
EventPresence = 6
"""
The event types handled by the overarching session adapter handler.

"""
EventMessage = 7
"""
The event types handled by the overarching session adapter handler.

"""
EventChatState = 8
"""
The event types handled by the overarching session adapter handler.

"""
EventReceipt = 9
"""
The event types handled by the overarching session adapter handler.

"""
EventGroup = 10
"""
The event types handled by the overarching session adapter handler.

"""
EventCall = 11
"""
The event types handled by the overarching session adapter handler.

"""

class GroupAffiliation(Enum):
	"""
	GroupAffiliation represents the set of privilidges given to a specific participant in a group.
	
	"""
	GroupAffiliationNone = 0
	GroupAffiliationAdmin = 1
	GroupAffiliationOwner = 2

GroupAffiliationNone = 0
GroupAffiliationAdmin = 1
GroupAffiliationOwner = 2

class GroupParticipantAction(Enum):
	"""
	GroupParticipantAction represents the distinct set of actions that can be taken when encountering
	a group participant, typically to add or remove.
	
	"""
	GroupParticipantActionAdd = 0
	GroupParticipantActionRemove = 1
	GroupParticipantActionPromote = 2
	GroupParticipantActionDemote = 3

GroupParticipantActionAdd = 0
GroupParticipantActionRemove = 1
GroupParticipantActionPromote = 2
GroupParticipantActionDemote = 3

class MessageKind(Enum):
	"""
	MessageKind represents all concrete message types (plain-text messages, edit messages, reactions)
	recognized by the Python session adapter.
	
	"""
	MessagePlain = 0
	"""
	The message types handled by the overarching session event handler.
	
	"""
	MessageEdit = 1
	"""
	The message types handled by the overarching session event handler.
	
	"""
	MessageRevoke = 2
	"""
	The message types handled by the overarching session event handler.
	
	"""
	MessageReaction = 3
	"""
	The message types handled by the overarching session event handler.
	
	"""
	MessageAttachment = 4
	"""
	The message types handled by the overarching session event handler.
	
	"""
	MessagePoll = 5
	"""
	The message types handled by the overarching session event handler.
	
	"""

MessagePlain = 0
"""
The message types handled by the overarching session event handler.

"""
MessageEdit = 1
"""
The message types handled by the overarching session event handler.

"""
MessageRevoke = 2
"""
The message types handled by the overarching session event handler.

"""
MessageReaction = 3
"""
The message types handled by the overarching session event handler.

"""
MessageAttachment = 4
"""
The message types handled by the overarching session event handler.

"""
MessagePoll = 5
"""
The message types handled by the overarching session event handler.

"""

class PresenceKind(Enum):
	"""
	PresenceKind represents the different kinds of activity states possible in WhatsApp.
	
	"""
	PresenceUnknown = 0
	"""
	The presences handled by the overarching session event handler.
	
	"""
	PresenceAvailable = 1
	"""
	The presences handled by the overarching session event handler.
	
	"""
	PresenceUnavailable = 2
	"""
	The presences handled by the overarching session event handler.
	
	"""

PresenceUnknown = 0
"""
The presences handled by the overarching session event handler.

"""
PresenceAvailable = 1
"""
The presences handled by the overarching session event handler.

"""
PresenceUnavailable = 2
"""
The presences handled by the overarching session event handler.

"""

class PreviewKind(Enum):
	"""
	PreviewKind represents different ways of previewingadditional data inline with messages.
	
	"""
	PreviewPlain = 0
	PreviewVideo = 1

PreviewPlain = 0
PreviewVideo = 1

class ReceiptKind(Enum):
	"""
	ReceiptKind represents the different types of delivery receipts possible in WhatsApp.
	
	"""
	ReceiptUnknown = 0
	"""
	The delivery receipts handled by the overarching session event handler.
	
	"""
	ReceiptDelivered = 1
	"""
	The delivery receipts handled by the overarching session event handler.
	
	"""
	ReceiptRead = 2
	"""
	The delivery receipts handled by the overarching session event handler.
	
	"""

ReceiptUnknown = 0
"""
The delivery receipts handled by the overarching session event handler.

"""
ReceiptDelivered = 1
"""
The delivery receipts handled by the overarching session event handler.

"""
ReceiptRead = 2
"""
The delivery receipts handled by the overarching session event handler.

"""



#---- Constants from Go: Python can only ask that you please don't change these! ---
DefaultGroupServer = "g.us"
DefaultUserServer = "s.whatsapp.net"


# ---- Global Variables: can only use functions to access ---


# ---- Interfaces ---


# ---- Structs ---

# Python type for struct whatsapp.GroupParticipant
class GroupParticipant(go.GoClass):
	"""A GroupParticipant represents a contact who is currently joined in a given group. Participants in\nWhatsApp can generally be derived back to their individual [Contact]; there are no anonymous groups\nin WhatsApp.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_GroupParticipant_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.JID = args[0]
			if "JID" in kwargs:
				self.JID = kwargs["JID"]
			if  1 < len(args):
				self.Nickname = args[1]
			if "Nickname" in kwargs:
				self.Nickname = kwargs["Nickname"]
			if  2 < len(args):
				self.Affiliation = args[2]
			if "Affiliation" in kwargs:
				self.Affiliation = kwargs["Affiliation"]
			if  3 < len(args):
				self.Action = args[3]
			if "Action" in kwargs:
				self.Action = kwargs["Action"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.GroupParticipant{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.GroupParticipant ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def JID(self):
		return _whatsapp.whatsapp_GroupParticipant_JID_Get(self.handle)
	@JID.setter
	def JID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_GroupParticipant_JID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_GroupParticipant_JID_Set(self.handle, value)
	@property
	def Nickname(self):
		return _whatsapp.whatsapp_GroupParticipant_Nickname_Get(self.handle)
	@Nickname.setter
	def Nickname(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_GroupParticipant_Nickname_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_GroupParticipant_Nickname_Set(self.handle, value)
	@property
	def Affiliation(self):
		return _whatsapp.whatsapp_GroupParticipant_Affiliation_Get(self.handle)
	@Affiliation.setter
	def Affiliation(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_GroupParticipant_Affiliation_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_GroupParticipant_Affiliation_Set(self.handle, value)
	@property
	def Action(self):
		return _whatsapp.whatsapp_GroupParticipant_Action_Get(self.handle)
	@Action.setter
	def Action(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_GroupParticipant_Action_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_GroupParticipant_Action_Set(self.handle, value)

# Python type for struct whatsapp.GroupSubject
class GroupSubject(go.GoClass):
	"""A GroupSubject represents the user-defined group description and attached metadata thereof, for a\ngiven [Group].\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_GroupSubject_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.Subject = args[0]
			if "Subject" in kwargs:
				self.Subject = kwargs["Subject"]
			if  1 < len(args):
				self.SetAt = args[1]
			if "SetAt" in kwargs:
				self.SetAt = kwargs["SetAt"]
			if  2 < len(args):
				self.SetBy = args[2]
			if "SetBy" in kwargs:
				self.SetBy = kwargs["SetBy"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.GroupSubject{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.GroupSubject ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Subject(self):
		return _whatsapp.whatsapp_GroupSubject_Subject_Get(self.handle)
	@Subject.setter
	def Subject(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_GroupSubject_Subject_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_GroupSubject_Subject_Set(self.handle, value)
	@property
	def SetAt(self):
		return _whatsapp.whatsapp_GroupSubject_SetAt_Get(self.handle)
	@SetAt.setter
	def SetAt(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_GroupSubject_SetAt_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_GroupSubject_SetAt_Set(self.handle, value)
	@property
	def SetBy(self):
		return _whatsapp.whatsapp_GroupSubject_SetBy_Get(self.handle)
	@SetBy.setter
	def SetBy(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_GroupSubject_SetBy_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_GroupSubject_SetBy_Set(self.handle, value)

# Python type for struct whatsapp.Session
class Session(go.GoClass):
	"""A Session represents a connection (active or not) between a linked device and WhatsApp. Active\nsessions need to be established by logging in, after which incoming events will be forwarded to\nthe adapter event handler, and outgoing events will be forwarded to WhatsApp.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Session_CTor()
			_whatsapp.IncRef(self.handle)
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Session{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Session ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	def Login(self):
		"""Login() str
		
		Login attempts to authenticate the given [Session], either by re-using the [LinkedDevice] attached
		or by initiating a pairing session for a new linked device. Callers are expected to have set an
		event handler in order to receive any incoming events from the underlying WhatsApp session.
		"""
		return _whatsapp.whatsapp_Session_Login(self.handle)
	def Logout(self):
		"""Logout() str
		
		Logout disconnects and removes the current linked device locally and initiates a logout remotely.
		"""
		return _whatsapp.whatsapp_Session_Logout(self.handle)
	def Disconnect(self):
		"""Disconnect() str
		
		Disconnects detaches the current connection to WhatsApp without removing any linked device state.
		"""
		return _whatsapp.whatsapp_Session_Disconnect(self.handle)
	def PairPhone(self, phone):
		"""PairPhone(str phone) str, str
		
		PairPhone returns a one-time code from WhatsApp, used for pairing this [Session] against the
		user's primary device, as identified by the given phone number. This will return an error if the
		[Session] is already paired, or if the phone number given is empty or invalid.
		"""
		return _whatsapp.whatsapp_Session_PairPhone(self.handle, phone)
	def SendMessage(self, message):
		"""SendMessage(object message) str
		
		SendMessage processes the given Message and sends a WhatsApp message for the kind and contact JID
		specified within. In general, different message kinds require different fields to be set; see the
		documentation for the [Message] type for more information.
		"""
		return _whatsapp.whatsapp_Session_SendMessage(self.handle, message.handle)
	def GenerateMessageID(self):
		"""GenerateMessageID() str
		
		GenerateMessageID returns a valid, pseudo-random message ID for use in outgoing messages.
		"""
		return _whatsapp.whatsapp_Session_GenerateMessageID(self.handle)
	def SendChatState(self, state):
		"""SendChatState(object state) str
		
		SendChatState sends the given chat state notification (e.g. composing message) to WhatsApp for the
		contact specified within.
		"""
		return _whatsapp.whatsapp_Session_SendChatState(self.handle, state.handle)
	def SendReceipt(self, receipt):
		"""SendReceipt(object receipt) str
		
		SendReceipt sends a read receipt to WhatsApp for the message IDs specified within.
		"""
		return _whatsapp.whatsapp_Session_SendReceipt(self.handle, receipt.handle)
	def SendPresence(self, presence, statusMessage):
		"""SendPresence(int presence, str statusMessage) str
		
		SendPresence sets the activity state and (optional) status message for the current session and
		user. An error is returned if setting availability fails for any reason.
		"""
		return _whatsapp.whatsapp_Session_SendPresence(self.handle, presence, statusMessage)
	def GetContacts(self, refresh):
		"""GetContacts(bool refresh) []object, str
		
		GetContacts subscribes to the WhatsApp roster currently stored in the Session's internal state.
		If `refresh` is `true`, FetchRoster will pull application state from the remote service and
		synchronize any contacts found with the adapter.
		"""
		return Slice_whatsapp_Contact(handle=_whatsapp.whatsapp_Session_GetContacts(self.handle, refresh))
	def GetGroups(self):
		"""GetGroups() []object, str
		
		GetGroups returns a list of all group-chats currently joined in WhatsApp, along with additional
		information on present participants.
		"""
		return Slice_whatsapp_Group(handle=_whatsapp.whatsapp_Session_GetGroups(self.handle))
	def CreateGroup(self, name, participants):
		"""CreateGroup(str name, []str participants) object, str
		
		CreateGroup attempts to create a new WhatsApp group for the given human-readable name and
		participant JIDs given.
		"""
		return Group(handle=_whatsapp.whatsapp_Session_CreateGroup(self.handle, name, participants.handle))
	def LeaveGroup(self, resourceID):
		"""LeaveGroup(str resourceID) str
		
		LeaveGroup attempts to remove our own user from the given WhatsApp group, for the JID given.
		"""
		return _whatsapp.whatsapp_Session_LeaveGroup(self.handle, resourceID)
	def GetAvatar(self, resourceID, avatarID):
		"""GetAvatar(str resourceID, str avatarID) object, str
		
		GetAvatar fetches a profile picture for the Contact or Group JID given. If a non-empty `avatarID`
		is also given, GetAvatar will return an empty [Avatar] instance with no error if the remote state
		for the given ID has not changed.
		"""
		return Avatar(handle=_whatsapp.whatsapp_Session_GetAvatar(self.handle, resourceID, avatarID))
	def SetAvatar(self, resourceID, avatar):
		"""SetAvatar(str resourceID, []int avatar) str, str
		
		SetAvatar updates the profile picture for the Contact or Group JID given; it can also update the
		profile picture for our own user by providing an empty JID. The unique picture ID is returned,
		typically used as a cache reference or in providing to future calls for [Session.GetAvatar].
		"""
		return _whatsapp.whatsapp_Session_SetAvatar(self.handle, resourceID, avatar.handle)
	def SetGroupName(self, resourceID, name):
		"""SetGroupName(str resourceID, str name) str
		
		SetGroupName updates the name of a WhatsApp group for the Group JID given.
		"""
		return _whatsapp.whatsapp_Session_SetGroupName(self.handle, resourceID, name)
	def SetGroupTopic(self, resourceID, topic):
		"""SetGroupTopic(str resourceID, str topic) str
		
		SetGroupName updates the topic of a WhatsApp group for the Group JID given.
		"""
		return _whatsapp.whatsapp_Session_SetGroupTopic(self.handle, resourceID, topic)
	def UpdateGroupParticipants(self, resourceID, participants):
		"""UpdateGroupParticipants(str resourceID, []object participants) []object, str
		
		UpdateGroupParticipants processes changes to the given group's participants, including additions,
		removals, and changes to privileges. Participant JIDs given must be part of the authenticated
		session's roster at least, and must also be active group participants for other types of changes.
		"""
		return Slice_whatsapp_GroupParticipant(handle=_whatsapp.whatsapp_Session_UpdateGroupParticipants(self.handle, resourceID, participants.handle))
	def FindContact(self, phone):
		"""FindContact(str phone) object, str
		
		FindContact attempts to check for a registered contact on WhatsApp corresponding to the given
		phone number, returning a concrete instance if found; typically, only the contact JID is set. No
		error is returned if no contact was found, but any unexpected errors will otherwise be returned
		directly.
		"""
		return Contact(handle=_whatsapp.whatsapp_Session_FindContact(self.handle, phone))
	def RequestMessageHistory(self, resourceID, oldestMessage):
		"""RequestMessageHistory(str resourceID, object oldestMessage) str
		
		RequestMessageHistory sends and asynchronous request for message history related to the given
		resource (e.g. Contact or Group JID), ending at the oldest message given. Messages returned from
		history should then be handled as a `HistorySync` event of type `ON_DEMAND`, in the session-wide
		event handler. An error will be returned if requesting history fails for any reason.
		"""
		return _whatsapp.whatsapp_Session_RequestMessageHistory(self.handle, resourceID, oldestMessage.handle)
	def SetEventHandler(self, h, goRun=False):
		"""SetEventHandler(callable h) 
		
		SetEventHandler assigns the given handler function for propagating internal events into the Python
		gateway. Note that the event handler function is not entirely safe to use directly, and all calls
		should instead be sent to the [Gateway] via its internal call channel.
		"""
		_whatsapp.whatsapp_Session_SetEventHandler(self.handle, h, goRun)

# Python type for struct whatsapp.Attachment
class Attachment(go.GoClass):
	"""A Attachment represents additional binary data (e.g. images, videos, documents) provided alongside\na message, for display or storage on the recepient client.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Attachment_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.MIME = args[0]
			if "MIME" in kwargs:
				self.MIME = kwargs["MIME"]
			if  1 < len(args):
				self.Filename = args[1]
			if "Filename" in kwargs:
				self.Filename = kwargs["Filename"]
			if  2 < len(args):
				self.Caption = args[2]
			if "Caption" in kwargs:
				self.Caption = kwargs["Caption"]
			if  3 < len(args):
				self.Data = args[3]
			if "Data" in kwargs:
				self.Data = kwargs["Data"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Attachment{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Attachment ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def MIME(self):
		return _whatsapp.whatsapp_Attachment_MIME_Get(self.handle)
	@MIME.setter
	def MIME(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Attachment_MIME_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Attachment_MIME_Set(self.handle, value)
	@property
	def Filename(self):
		return _whatsapp.whatsapp_Attachment_Filename_Get(self.handle)
	@Filename.setter
	def Filename(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Attachment_Filename_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Attachment_Filename_Set(self.handle, value)
	@property
	def Caption(self):
		return _whatsapp.whatsapp_Attachment_Caption_Get(self.handle)
	@Caption.setter
	def Caption(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Attachment_Caption_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Attachment_Caption_Set(self.handle, value)
	@property
	def Data(self):
		return go.Slice_byte(handle=_whatsapp.whatsapp_Attachment_Data_Get(self.handle))
	@Data.setter
	def Data(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Attachment_Data_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	def GetSpec(self, ctx):
		"""GetSpec(object ctx) object, str
		
		GetSpec returns metadata for this attachment, as derived from the underlying attachment data.
		"""
		return go.Ptr_media_Spec(handle=_whatsapp.whatsapp_Attachment_GetSpec(self.handle, ctx.handle))

# Python type for struct whatsapp.Call
class Call(go.GoClass):
	"""A Call represents an incoming or outgoing voice/video call made over WhatsApp. Full support for\ncalls is currently not implemented, and this structure contains the bare minimum data required\nfor notifying on missed calls.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Call_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.State = args[0]
			if "State" in kwargs:
				self.State = kwargs["State"]
			if  1 < len(args):
				self.JID = args[1]
			if "JID" in kwargs:
				self.JID = kwargs["JID"]
			if  2 < len(args):
				self.Timestamp = args[2]
			if "Timestamp" in kwargs:
				self.Timestamp = kwargs["Timestamp"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Call{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Call ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def State(self):
		return _whatsapp.whatsapp_Call_State_Get(self.handle)
	@State.setter
	def State(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Call_State_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Call_State_Set(self.handle, value)
	@property
	def JID(self):
		return _whatsapp.whatsapp_Call_JID_Get(self.handle)
	@JID.setter
	def JID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Call_JID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Call_JID_Set(self.handle, value)
	@property
	def Timestamp(self):
		return _whatsapp.whatsapp_Call_Timestamp_Get(self.handle)
	@Timestamp.setter
	def Timestamp(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Call_Timestamp_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Call_Timestamp_Set(self.handle, value)

# Python type for struct whatsapp.Avatar
class Avatar(go.GoClass):
	"""A Avatar represents a small image set for a Contact or Group.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Avatar_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.ID = args[0]
			if "ID" in kwargs:
				self.ID = kwargs["ID"]
			if  1 < len(args):
				self.URL = args[1]
			if "URL" in kwargs:
				self.URL = kwargs["URL"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Avatar{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Avatar ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def ID(self):
		return _whatsapp.whatsapp_Avatar_ID_Get(self.handle)
	@ID.setter
	def ID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Avatar_ID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Avatar_ID_Set(self.handle, value)
	@property
	def URL(self):
		return _whatsapp.whatsapp_Avatar_URL_Get(self.handle)
	@URL.setter
	def URL(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Avatar_URL_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Avatar_URL_Set(self.handle, value)

# Python type for struct whatsapp.EventPayload
class EventPayload(go.GoClass):
	"""EventPayload represents the collected payloads for all event types handled by the overarching\nsession adapter handler. Only specific fields will be populated in events emitted by internal\nhandlers, see documentation for specific types for more information.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_EventPayload_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.QRCode = args[0]
			if "QRCode" in kwargs:
				self.QRCode = kwargs["QRCode"]
			if  1 < len(args):
				self.PairDeviceID = args[1]
			if "PairDeviceID" in kwargs:
				self.PairDeviceID = kwargs["PairDeviceID"]
			if  2 < len(args):
				self.Connect = args[2]
			if "Connect" in kwargs:
				self.Connect = kwargs["Connect"]
			if  3 < len(args):
				self.LoggedOut = args[3]
			if "LoggedOut" in kwargs:
				self.LoggedOut = kwargs["LoggedOut"]
			if  4 < len(args):
				self.Contact = args[4]
			if "Contact" in kwargs:
				self.Contact = kwargs["Contact"]
			if  5 < len(args):
				self.Presence = args[5]
			if "Presence" in kwargs:
				self.Presence = kwargs["Presence"]
			if  6 < len(args):
				self.Message = args[6]
			if "Message" in kwargs:
				self.Message = kwargs["Message"]
			if  7 < len(args):
				self.ChatState = args[7]
			if "ChatState" in kwargs:
				self.ChatState = kwargs["ChatState"]
			if  8 < len(args):
				self.Receipt = args[8]
			if "Receipt" in kwargs:
				self.Receipt = kwargs["Receipt"]
			if  9 < len(args):
				self.Group = args[9]
			if "Group" in kwargs:
				self.Group = kwargs["Group"]
			if  10 < len(args):
				self.Call = args[10]
			if "Call" in kwargs:
				self.Call = kwargs["Call"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.EventPayload{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.EventPayload ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def QRCode(self):
		return _whatsapp.whatsapp_EventPayload_QRCode_Get(self.handle)
	@QRCode.setter
	def QRCode(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_EventPayload_QRCode_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_EventPayload_QRCode_Set(self.handle, value)
	@property
	def PairDeviceID(self):
		return _whatsapp.whatsapp_EventPayload_PairDeviceID_Get(self.handle)
	@PairDeviceID.setter
	def PairDeviceID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_EventPayload_PairDeviceID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_EventPayload_PairDeviceID_Set(self.handle, value)
	@property
	def Connect(self):
		return Connect(handle=_whatsapp.whatsapp_EventPayload_Connect_Get(self.handle))
	@Connect.setter
	def Connect(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_EventPayload_Connect_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def LoggedOut(self):
		return LoggedOut(handle=_whatsapp.whatsapp_EventPayload_LoggedOut_Get(self.handle))
	@LoggedOut.setter
	def LoggedOut(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_EventPayload_LoggedOut_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Contact(self):
		return Contact(handle=_whatsapp.whatsapp_EventPayload_Contact_Get(self.handle))
	@Contact.setter
	def Contact(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_EventPayload_Contact_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Presence(self):
		return Presence(handle=_whatsapp.whatsapp_EventPayload_Presence_Get(self.handle))
	@Presence.setter
	def Presence(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_EventPayload_Presence_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Message(self):
		return Message(handle=_whatsapp.whatsapp_EventPayload_Message_Get(self.handle))
	@Message.setter
	def Message(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_EventPayload_Message_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def ChatState(self):
		return ChatState(handle=_whatsapp.whatsapp_EventPayload_ChatState_Get(self.handle))
	@ChatState.setter
	def ChatState(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_EventPayload_ChatState_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Receipt(self):
		return Receipt(handle=_whatsapp.whatsapp_EventPayload_Receipt_Get(self.handle))
	@Receipt.setter
	def Receipt(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_EventPayload_Receipt_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Group(self):
		return Group(handle=_whatsapp.whatsapp_EventPayload_Group_Get(self.handle))
	@Group.setter
	def Group(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_EventPayload_Group_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Call(self):
		return Call(handle=_whatsapp.whatsapp_EventPayload_Call_Get(self.handle))
	@Call.setter
	def Call(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_EventPayload_Call_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))

# Python type for struct whatsapp.Location
class Location(go.GoClass):
	"""A Location represents additional metadata given to location messages.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Location_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.Latitude = args[0]
			if "Latitude" in kwargs:
				self.Latitude = kwargs["Latitude"]
			if  1 < len(args):
				self.Longitude = args[1]
			if "Longitude" in kwargs:
				self.Longitude = kwargs["Longitude"]
			if  2 < len(args):
				self.Accuracy = args[2]
			if "Accuracy" in kwargs:
				self.Accuracy = kwargs["Accuracy"]
			if  3 < len(args):
				self.IsLive = args[3]
			if "IsLive" in kwargs:
				self.IsLive = kwargs["IsLive"]
			if  4 < len(args):
				self.Name = args[4]
			if "Name" in kwargs:
				self.Name = kwargs["Name"]
			if  5 < len(args):
				self.Address = args[5]
			if "Address" in kwargs:
				self.Address = kwargs["Address"]
			if  6 < len(args):
				self.URL = args[6]
			if "URL" in kwargs:
				self.URL = kwargs["URL"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Location{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Location ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Latitude(self):
		return _whatsapp.whatsapp_Location_Latitude_Get(self.handle)
	@Latitude.setter
	def Latitude(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Location_Latitude_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Location_Latitude_Set(self.handle, value)
	@property
	def Longitude(self):
		return _whatsapp.whatsapp_Location_Longitude_Get(self.handle)
	@Longitude.setter
	def Longitude(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Location_Longitude_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Location_Longitude_Set(self.handle, value)
	@property
	def Accuracy(self):
		return _whatsapp.whatsapp_Location_Accuracy_Get(self.handle)
	@Accuracy.setter
	def Accuracy(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Location_Accuracy_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Location_Accuracy_Set(self.handle, value)
	@property
	def IsLive(self):
		return _whatsapp.whatsapp_Location_IsLive_Get(self.handle)
	@IsLive.setter
	def IsLive(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Location_IsLive_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Location_IsLive_Set(self.handle, value)
	@property
	def Name(self):
		"""Optional fields given for named locations.
		"""
		return _whatsapp.whatsapp_Location_Name_Get(self.handle)
	@Name.setter
	def Name(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Location_Name_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Location_Name_Set(self.handle, value)
	@property
	def Address(self):
		return _whatsapp.whatsapp_Location_Address_Get(self.handle)
	@Address.setter
	def Address(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Location_Address_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Location_Address_Set(self.handle, value)
	@property
	def URL(self):
		return _whatsapp.whatsapp_Location_URL_Get(self.handle)
	@URL.setter
	def URL(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Location_URL_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Location_URL_Set(self.handle, value)

# Python type for struct whatsapp.Poll
class Poll(go.GoClass):
	"""A Poll represents a multiple-choice question, on which each choice might be voted for one or more\ntimes.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Poll_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.Title = args[0]
			if "Title" in kwargs:
				self.Title = kwargs["Title"]
			if  1 < len(args):
				self.Options = args[1]
			if "Options" in kwargs:
				self.Options = kwargs["Options"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Poll{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Poll ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Title(self):
		return _whatsapp.whatsapp_Poll_Title_Get(self.handle)
	@Title.setter
	def Title(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Poll_Title_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Poll_Title_Set(self.handle, value)
	@property
	def Options(self):
		return Slice_whatsapp_PollOption(handle=_whatsapp.whatsapp_Poll_Options_Get(self.handle))
	@Options.setter
	def Options(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Poll_Options_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))

# Python type for struct whatsapp.PollOption
class PollOption(go.GoClass):
	"""A PollOption represents an individual choice within a broader poll.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_PollOption_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.Title = args[0]
			if "Title" in kwargs:
				self.Title = kwargs["Title"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.PollOption{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.PollOption ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Title(self):
		return _whatsapp.whatsapp_PollOption_Title_Get(self.handle)
	@Title.setter
	def Title(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_PollOption_Title_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_PollOption_Title_Set(self.handle, value)

# Python type for struct whatsapp.Album
class Album(go.GoClass):
	"""A Album message represents a collection of media files, typically images and videos.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Album_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.IsAlbum = args[0]
			if "IsAlbum" in kwargs:
				self.IsAlbum = kwargs["IsAlbum"]
			if  1 < len(args):
				self.ImageCount = args[1]
			if "ImageCount" in kwargs:
				self.ImageCount = kwargs["ImageCount"]
			if  2 < len(args):
				self.VideoCount = args[2]
			if "VideoCount" in kwargs:
				self.VideoCount = kwargs["VideoCount"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Album{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Album ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def IsAlbum(self):
		return _whatsapp.whatsapp_Album_IsAlbum_Get(self.handle)
	@IsAlbum.setter
	def IsAlbum(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Album_IsAlbum_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Album_IsAlbum_Set(self.handle, value)
	@property
	def ImageCount(self):
		return _whatsapp.whatsapp_Album_ImageCount_Get(self.handle)
	@ImageCount.setter
	def ImageCount(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Album_ImageCount_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Album_ImageCount_Set(self.handle, value)
	@property
	def VideoCount(self):
		return _whatsapp.whatsapp_Album_VideoCount_Get(self.handle)
	@VideoCount.setter
	def VideoCount(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Album_VideoCount_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Album_VideoCount_Set(self.handle, value)

# Python type for struct whatsapp.Connect
class Connect(go.GoClass):
	"""Connect represents event data related to a connection to WhatsApp being established, or failing\nto do so (based on the [Connect.Error] result).\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Connect_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.JID = args[0]
			if "JID" in kwargs:
				self.JID = kwargs["JID"]
			if  1 < len(args):
				self.Error = args[1]
			if "Error" in kwargs:
				self.Error = kwargs["Error"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Connect{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Connect ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def JID(self):
		return _whatsapp.whatsapp_Connect_JID_Get(self.handle)
	@JID.setter
	def JID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Connect_JID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Connect_JID_Set(self.handle, value)
	@property
	def Error(self):
		return _whatsapp.whatsapp_Connect_Error_Get(self.handle)
	@Error.setter
	def Error(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Connect_Error_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Connect_Error_Set(self.handle, value)

# Python type for struct whatsapp.Contact
class Contact(go.GoClass):
	"""A Contact represents any entity that be communicated with directly in WhatsApp. This typically\nrepresents people, but may represent a business or bot as well, but not a group-chat.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Contact_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.JID = args[0]
			if "JID" in kwargs:
				self.JID = kwargs["JID"]
			if  1 < len(args):
				self.Name = args[1]
			if "Name" in kwargs:
				self.Name = kwargs["Name"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Contact{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Contact ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def JID(self):
		return _whatsapp.whatsapp_Contact_JID_Get(self.handle)
	@JID.setter
	def JID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Contact_JID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Contact_JID_Set(self.handle, value)
	@property
	def Name(self):
		return _whatsapp.whatsapp_Contact_Name_Get(self.handle)
	@Name.setter
	def Name(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Contact_Name_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Contact_Name_Set(self.handle, value)

# Python type for struct whatsapp.Gateway
class Gateway(go.GoClass):
	"""A Gateway represents a persistent process for establishing individual sessions between linked\ndevices and WhatsApp.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Gateway_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.DBPath = args[0]
			if "DBPath" in kwargs:
				self.DBPath = kwargs["DBPath"]
			if  1 < len(args):
				self.Name = args[1]
			if "Name" in kwargs:
				self.Name = kwargs["Name"]
			if  2 < len(args):
				self.LogLevel = args[2]
			if "LogLevel" in kwargs:
				self.LogLevel = kwargs["LogLevel"]
			if  3 < len(args):
				self.TempDir = args[3]
			if "TempDir" in kwargs:
				self.TempDir = kwargs["TempDir"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Gateway{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Gateway ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def DBPath(self):
		return _whatsapp.whatsapp_Gateway_DBPath_Get(self.handle)
	@DBPath.setter
	def DBPath(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Gateway_DBPath_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Gateway_DBPath_Set(self.handle, value)
	@property
	def Name(self):
		return _whatsapp.whatsapp_Gateway_Name_Get(self.handle)
	@Name.setter
	def Name(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Gateway_Name_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Gateway_Name_Set(self.handle, value)
	@property
	def LogLevel(self):
		return _whatsapp.whatsapp_Gateway_LogLevel_Get(self.handle)
	@LogLevel.setter
	def LogLevel(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Gateway_LogLevel_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Gateway_LogLevel_Set(self.handle, value)
	@property
	def TempDir(self):
		return _whatsapp.whatsapp_Gateway_TempDir_Get(self.handle)
	@TempDir.setter
	def TempDir(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Gateway_TempDir_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Gateway_TempDir_Set(self.handle, value)
	def Init(self):
		"""Init() str
		
		Init performs initialization procedures for the Gateway, and is expected to be run before any
		calls to [Gateway.Session].
		"""
		return _whatsapp.whatsapp_Gateway_Init(self.handle)
	def NewSession(self, device):
		"""NewSession(object device) object
		
		NewSession returns a new [Session] for the LinkedDevice given. If the linked device does not have
		a valid ID, a pair operation will be required, as described in [Session.Login].
		"""
		return Session(handle=_whatsapp.whatsapp_Gateway_NewSession(self.handle, device.handle))
	def CleanupSession(self, device):
		"""CleanupSession(object device) str
		
		CleanupSession will remove all invalid and obsolete references to the given device, and should be
		used when pairing a new device or unregistering from the Gateway.
		"""
		return _whatsapp.whatsapp_Gateway_CleanupSession(self.handle, device.handle)

# Python type for struct whatsapp.Group
class Group(go.GoClass):
	"""A Group represents a named, many-to-many chat space which may be joined or left at will. All\nfields apart from the group JID are considered to be optional, and may not be set in cases where\ngroup information is being updated against previous assumed state. Groups in WhatsApp are\ngenerally invited to out-of-band with respect to overarching adaptor; see the documentation for\n[Session.GetGroups] for more information.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Group_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.JID = args[0]
			if "JID" in kwargs:
				self.JID = kwargs["JID"]
			if  1 < len(args):
				self.Name = args[1]
			if "Name" in kwargs:
				self.Name = kwargs["Name"]
			if  2 < len(args):
				self.Subject = args[2]
			if "Subject" in kwargs:
				self.Subject = kwargs["Subject"]
			if  3 < len(args):
				self.Nickname = args[3]
			if "Nickname" in kwargs:
				self.Nickname = kwargs["Nickname"]
			if  4 < len(args):
				self.Participants = args[4]
			if "Participants" in kwargs:
				self.Participants = kwargs["Participants"]
			if  5 < len(args):
				self.InviteCode = args[5]
			if "InviteCode" in kwargs:
				self.InviteCode = kwargs["InviteCode"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Group{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Group ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def JID(self):
		return _whatsapp.whatsapp_Group_JID_Get(self.handle)
	@JID.setter
	def JID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Group_JID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Group_JID_Set(self.handle, value)
	@property
	def Name(self):
		return _whatsapp.whatsapp_Group_Name_Get(self.handle)
	@Name.setter
	def Name(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Group_Name_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Group_Name_Set(self.handle, value)
	@property
	def Subject(self):
		return GroupSubject(handle=_whatsapp.whatsapp_Group_Subject_Get(self.handle))
	@Subject.setter
	def Subject(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Group_Subject_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Nickname(self):
		return _whatsapp.whatsapp_Group_Nickname_Get(self.handle)
	@Nickname.setter
	def Nickname(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Group_Nickname_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Group_Nickname_Set(self.handle, value)
	@property
	def Participants(self):
		return Slice_whatsapp_GroupParticipant(handle=_whatsapp.whatsapp_Group_Participants_Get(self.handle))
	@Participants.setter
	def Participants(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Group_Participants_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def InviteCode(self):
		return _whatsapp.whatsapp_Group_InviteCode_Get(self.handle)
	@InviteCode.setter
	def InviteCode(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Group_InviteCode_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Group_InviteCode_Set(self.handle, value)

# Python type for struct whatsapp.LinkedDevice
class LinkedDevice(go.GoClass):
	"""A LinkedDevice represents a unique pairing session between the gateway and WhatsApp. It is not\nunique to the underlying \"main\" device (or phone number), as multiple linked devices may be paired\nwith any main device.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_LinkedDevice_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.ID = args[0]
			if "ID" in kwargs:
				self.ID = kwargs["ID"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.LinkedDevice{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.LinkedDevice ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def ID(self):
		"""ID is an opaque string identifying this LinkedDevice to the Session. Noted that this string
		is currently equivalent to a password, and needs to be protected accordingly.
		"""
		return _whatsapp.whatsapp_LinkedDevice_ID_Get(self.handle)
	@ID.setter
	def ID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_LinkedDevice_ID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_LinkedDevice_ID_Set(self.handle, value)
	def JID(self):
		"""JID() object
		
		JID returns the WhatsApp JID corresponding to the LinkedDevice ID. Empty or invalid device IDs
		may return invalid JIDs, and this function does not handle errors.
		"""
		return go.types_JID(handle=_whatsapp.whatsapp_LinkedDevice_JID(self.handle))

# Python type for struct whatsapp.LoggedOut
class LoggedOut(go.GoClass):
	"""LoggedOut repreents event data related to an explicit or implicit log-out event.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_LoggedOut_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.Reason = args[0]
			if "Reason" in kwargs:
				self.Reason = kwargs["Reason"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.LoggedOut{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.LoggedOut ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Reason(self):
		return _whatsapp.whatsapp_LoggedOut_Reason_Get(self.handle)
	@Reason.setter
	def Reason(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_LoggedOut_Reason_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_LoggedOut_Reason_Set(self.handle, value)

# Python type for struct whatsapp.Message
class Message(go.GoClass):
	"""A Message represents one of many kinds of bidirectional communication payloads, for example, a\ntext message, a file (image, video) attachment, an emoji reaction, etc. Messages of different\nkinds are denoted as such, and re-use fields where the semantics overlap.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Message_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.Kind = args[0]
			if "Kind" in kwargs:
				self.Kind = kwargs["Kind"]
			if  1 < len(args):
				self.ID = args[1]
			if "ID" in kwargs:
				self.ID = kwargs["ID"]
			if  2 < len(args):
				self.JID = args[2]
			if "JID" in kwargs:
				self.JID = kwargs["JID"]
			if  3 < len(args):
				self.GroupJID = args[3]
			if "GroupJID" in kwargs:
				self.GroupJID = kwargs["GroupJID"]
			if  4 < len(args):
				self.OriginJID = args[4]
			if "OriginJID" in kwargs:
				self.OriginJID = kwargs["OriginJID"]
			if  5 < len(args):
				self.Body = args[5]
			if "Body" in kwargs:
				self.Body = kwargs["Body"]
			if  6 < len(args):
				self.Timestamp = args[6]
			if "Timestamp" in kwargs:
				self.Timestamp = kwargs["Timestamp"]
			if  7 < len(args):
				self.IsCarbon = args[7]
			if "IsCarbon" in kwargs:
				self.IsCarbon = kwargs["IsCarbon"]
			if  8 < len(args):
				self.IsForwarded = args[8]
			if "IsForwarded" in kwargs:
				self.IsForwarded = kwargs["IsForwarded"]
			if  9 < len(args):
				self.ReplyID = args[9]
			if "ReplyID" in kwargs:
				self.ReplyID = kwargs["ReplyID"]
			if  10 < len(args):
				self.ReplyBody = args[10]
			if "ReplyBody" in kwargs:
				self.ReplyBody = kwargs["ReplyBody"]
			if  11 < len(args):
				self.Attachments = args[11]
			if "Attachments" in kwargs:
				self.Attachments = kwargs["Attachments"]
			if  12 < len(args):
				self.Preview = args[12]
			if "Preview" in kwargs:
				self.Preview = kwargs["Preview"]
			if  13 < len(args):
				self.Location = args[13]
			if "Location" in kwargs:
				self.Location = kwargs["Location"]
			if  14 < len(args):
				self.Poll = args[14]
			if "Poll" in kwargs:
				self.Poll = kwargs["Poll"]
			if  15 < len(args):
				self.Album = args[15]
			if "Album" in kwargs:
				self.Album = kwargs["Album"]
			if  16 < len(args):
				self.GroupInvite = args[16]
			if "GroupInvite" in kwargs:
				self.GroupInvite = kwargs["GroupInvite"]
			if  17 < len(args):
				self.MentionJIDs = args[17]
			if "MentionJIDs" in kwargs:
				self.MentionJIDs = kwargs["MentionJIDs"]
			if  18 < len(args):
				self.Receipts = args[18]
			if "Receipts" in kwargs:
				self.Receipts = kwargs["Receipts"]
			if  19 < len(args):
				self.Reactions = args[19]
			if "Reactions" in kwargs:
				self.Reactions = kwargs["Reactions"]
			if  20 < len(args):
				self.IsHistory = args[20]
			if "IsHistory" in kwargs:
				self.IsHistory = kwargs["IsHistory"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Message{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Message ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Kind(self):
		return _whatsapp.whatsapp_Message_Kind_Get(self.handle)
	@Kind.setter
	def Kind(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_Kind_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Message_Kind_Set(self.handle, value)
	@property
	def ID(self):
		return _whatsapp.whatsapp_Message_ID_Get(self.handle)
	@ID.setter
	def ID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_ID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Message_ID_Set(self.handle, value)
	@property
	def JID(self):
		return _whatsapp.whatsapp_Message_JID_Get(self.handle)
	@JID.setter
	def JID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_JID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Message_JID_Set(self.handle, value)
	@property
	def GroupJID(self):
		return _whatsapp.whatsapp_Message_GroupJID_Get(self.handle)
	@GroupJID.setter
	def GroupJID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_GroupJID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Message_GroupJID_Set(self.handle, value)
	@property
	def OriginJID(self):
		return _whatsapp.whatsapp_Message_OriginJID_Get(self.handle)
	@OriginJID.setter
	def OriginJID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_OriginJID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Message_OriginJID_Set(self.handle, value)
	@property
	def Body(self):
		return _whatsapp.whatsapp_Message_Body_Get(self.handle)
	@Body.setter
	def Body(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_Body_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Message_Body_Set(self.handle, value)
	@property
	def Timestamp(self):
		return _whatsapp.whatsapp_Message_Timestamp_Get(self.handle)
	@Timestamp.setter
	def Timestamp(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_Timestamp_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Message_Timestamp_Set(self.handle, value)
	@property
	def IsCarbon(self):
		return _whatsapp.whatsapp_Message_IsCarbon_Get(self.handle)
	@IsCarbon.setter
	def IsCarbon(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_IsCarbon_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Message_IsCarbon_Set(self.handle, value)
	@property
	def IsForwarded(self):
		return _whatsapp.whatsapp_Message_IsForwarded_Get(self.handle)
	@IsForwarded.setter
	def IsForwarded(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_IsForwarded_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Message_IsForwarded_Set(self.handle, value)
	@property
	def ReplyID(self):
		return _whatsapp.whatsapp_Message_ReplyID_Get(self.handle)
	@ReplyID.setter
	def ReplyID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_ReplyID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Message_ReplyID_Set(self.handle, value)
	@property
	def ReplyBody(self):
		return _whatsapp.whatsapp_Message_ReplyBody_Get(self.handle)
	@ReplyBody.setter
	def ReplyBody(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_ReplyBody_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Message_ReplyBody_Set(self.handle, value)
	@property
	def Attachments(self):
		return Slice_whatsapp_Attachment(handle=_whatsapp.whatsapp_Message_Attachments_Get(self.handle))
	@Attachments.setter
	def Attachments(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_Attachments_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Preview(self):
		return Preview(handle=_whatsapp.whatsapp_Message_Preview_Get(self.handle))
	@Preview.setter
	def Preview(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_Preview_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Location(self):
		return Location(handle=_whatsapp.whatsapp_Message_Location_Get(self.handle))
	@Location.setter
	def Location(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_Location_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Poll(self):
		return Poll(handle=_whatsapp.whatsapp_Message_Poll_Get(self.handle))
	@Poll.setter
	def Poll(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_Poll_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Album(self):
		return Album(handle=_whatsapp.whatsapp_Message_Album_Get(self.handle))
	@Album.setter
	def Album(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_Album_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def GroupInvite(self):
		return Group(handle=_whatsapp.whatsapp_Message_GroupInvite_Get(self.handle))
	@GroupInvite.setter
	def GroupInvite(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_GroupInvite_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def MentionJIDs(self):
		return go.Slice_string(handle=_whatsapp.whatsapp_Message_MentionJIDs_Get(self.handle))
	@MentionJIDs.setter
	def MentionJIDs(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_MentionJIDs_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Receipts(self):
		return Slice_whatsapp_Receipt(handle=_whatsapp.whatsapp_Message_Receipts_Get(self.handle))
	@Receipts.setter
	def Receipts(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_Receipts_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Reactions(self):
		return Slice_whatsapp_Message(handle=_whatsapp.whatsapp_Message_Reactions_Get(self.handle))
	@Reactions.setter
	def Reactions(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_Reactions_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def IsHistory(self):
		return _whatsapp.whatsapp_Message_IsHistory_Get(self.handle)
	@IsHistory.setter
	def IsHistory(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Message_IsHistory_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Message_IsHistory_Set(self.handle, value)

# Python type for struct whatsapp.ChatState
class ChatState(go.GoClass):
	"""A ChatState represents the activity of a contact within a certain discussion, for instance,\nwhether the contact is currently composing a message. This is separate to the concept of a\nPresence, which is the contact's general state across all discussions.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_ChatState_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.Kind = args[0]
			if "Kind" in kwargs:
				self.Kind = kwargs["Kind"]
			if  1 < len(args):
				self.JID = args[1]
			if "JID" in kwargs:
				self.JID = kwargs["JID"]
			if  2 < len(args):
				self.GroupJID = args[2]
			if "GroupJID" in kwargs:
				self.GroupJID = kwargs["GroupJID"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.ChatState{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.ChatState ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Kind(self):
		return _whatsapp.whatsapp_ChatState_Kind_Get(self.handle)
	@Kind.setter
	def Kind(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_ChatState_Kind_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_ChatState_Kind_Set(self.handle, value)
	@property
	def JID(self):
		return _whatsapp.whatsapp_ChatState_JID_Get(self.handle)
	@JID.setter
	def JID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_ChatState_JID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_ChatState_JID_Set(self.handle, value)
	@property
	def GroupJID(self):
		return _whatsapp.whatsapp_ChatState_GroupJID_Get(self.handle)
	@GroupJID.setter
	def GroupJID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_ChatState_GroupJID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_ChatState_GroupJID_Set(self.handle, value)

# Python type for struct whatsapp.Preview
class Preview(go.GoClass):
	"""A Preview represents a short description for a URL provided in a message body, as usually derived\nfrom the content of the page pointed at.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Preview_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.Kind = args[0]
			if "Kind" in kwargs:
				self.Kind = kwargs["Kind"]
			if  1 < len(args):
				self.URL = args[1]
			if "URL" in kwargs:
				self.URL = kwargs["URL"]
			if  2 < len(args):
				self.Title = args[2]
			if "Title" in kwargs:
				self.Title = kwargs["Title"]
			if  3 < len(args):
				self.Description = args[3]
			if "Description" in kwargs:
				self.Description = kwargs["Description"]
			if  4 < len(args):
				self.Thumbnail = args[4]
			if "Thumbnail" in kwargs:
				self.Thumbnail = kwargs["Thumbnail"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Preview{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Preview ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Kind(self):
		return _whatsapp.whatsapp_Preview_Kind_Get(self.handle)
	@Kind.setter
	def Kind(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Preview_Kind_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Preview_Kind_Set(self.handle, value)
	@property
	def URL(self):
		return _whatsapp.whatsapp_Preview_URL_Get(self.handle)
	@URL.setter
	def URL(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Preview_URL_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Preview_URL_Set(self.handle, value)
	@property
	def Title(self):
		return _whatsapp.whatsapp_Preview_Title_Get(self.handle)
	@Title.setter
	def Title(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Preview_Title_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Preview_Title_Set(self.handle, value)
	@property
	def Description(self):
		return _whatsapp.whatsapp_Preview_Description_Get(self.handle)
	@Description.setter
	def Description(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Preview_Description_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Preview_Description_Set(self.handle, value)
	@property
	def Thumbnail(self):
		return go.Slice_byte(handle=_whatsapp.whatsapp_Preview_Thumbnail_Get(self.handle))
	@Thumbnail.setter
	def Thumbnail(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Preview_Thumbnail_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))

# Python type for struct whatsapp.Receipt
class Receipt(go.GoClass):
	"""A Receipt represents a notice of delivery or presentation for [Message] instances sent or\nreceived. Receipts can be delivered for many messages at once, but are generally all delivered\nunder one specific state at a time.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Receipt_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.Kind = args[0]
			if "Kind" in kwargs:
				self.Kind = kwargs["Kind"]
			if  1 < len(args):
				self.MessageIDs = args[1]
			if "MessageIDs" in kwargs:
				self.MessageIDs = kwargs["MessageIDs"]
			if  2 < len(args):
				self.JID = args[2]
			if "JID" in kwargs:
				self.JID = kwargs["JID"]
			if  3 < len(args):
				self.GroupJID = args[3]
			if "GroupJID" in kwargs:
				self.GroupJID = kwargs["GroupJID"]
			if  4 < len(args):
				self.Timestamp = args[4]
			if "Timestamp" in kwargs:
				self.Timestamp = kwargs["Timestamp"]
			if  5 < len(args):
				self.IsCarbon = args[5]
			if "IsCarbon" in kwargs:
				self.IsCarbon = kwargs["IsCarbon"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Receipt{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Receipt ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Kind(self):
		return _whatsapp.whatsapp_Receipt_Kind_Get(self.handle)
	@Kind.setter
	def Kind(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Receipt_Kind_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Receipt_Kind_Set(self.handle, value)
	@property
	def MessageIDs(self):
		return go.Slice_string(handle=_whatsapp.whatsapp_Receipt_MessageIDs_Get(self.handle))
	@MessageIDs.setter
	def MessageIDs(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Receipt_MessageIDs_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def JID(self):
		return _whatsapp.whatsapp_Receipt_JID_Get(self.handle)
	@JID.setter
	def JID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Receipt_JID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Receipt_JID_Set(self.handle, value)
	@property
	def GroupJID(self):
		return _whatsapp.whatsapp_Receipt_GroupJID_Get(self.handle)
	@GroupJID.setter
	def GroupJID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Receipt_GroupJID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Receipt_GroupJID_Set(self.handle, value)
	@property
	def Timestamp(self):
		return _whatsapp.whatsapp_Receipt_Timestamp_Get(self.handle)
	@Timestamp.setter
	def Timestamp(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Receipt_Timestamp_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Receipt_Timestamp_Set(self.handle, value)
	@property
	def IsCarbon(self):
		return _whatsapp.whatsapp_Receipt_IsCarbon_Get(self.handle)
	@IsCarbon.setter
	def IsCarbon(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Receipt_IsCarbon_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Receipt_IsCarbon_Set(self.handle, value)

# Python type for struct whatsapp.Presence
class Presence(go.GoClass):
	"""Precence represents a contact's general state of activity, and is periodically updated as\ncontacts start or stop paying attention to their client of choice.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_whatsapp.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_whatsapp.IncRef(self.handle)
		else:
			self.handle = _whatsapp.whatsapp_Presence_CTor()
			_whatsapp.IncRef(self.handle)
			if  0 < len(args):
				self.JID = args[0]
			if "JID" in kwargs:
				self.JID = kwargs["JID"]
			if  1 < len(args):
				self.Kind = args[1]
			if "Kind" in kwargs:
				self.Kind = kwargs["Kind"]
			if  2 < len(args):
				self.LastSeen = args[2]
			if "LastSeen" in kwargs:
				self.LastSeen = kwargs["LastSeen"]
	def __del__(self):
		_whatsapp.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Presence{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'whatsapp.Presence ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def JID(self):
		return _whatsapp.whatsapp_Presence_JID_Get(self.handle)
	@JID.setter
	def JID(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Presence_JID_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Presence_JID_Set(self.handle, value)
	@property
	def Kind(self):
		return _whatsapp.whatsapp_Presence_Kind_Get(self.handle)
	@Kind.setter
	def Kind(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Presence_Kind_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Presence_Kind_Set(self.handle, value)
	@property
	def LastSeen(self):
		return _whatsapp.whatsapp_Presence_LastSeen_Get(self.handle)
	@LastSeen.setter
	def LastSeen(self, value):
		if isinstance(value, go.GoClass):
			_whatsapp.whatsapp_Presence_LastSeen_Set(self.handle, value.handle)
		else:
			_whatsapp.whatsapp_Presence_LastSeen_Set(self.handle, value)


# ---- Slices ---


# ---- Maps ---


# ---- Constructors ---
def NewGateway():
	"""NewGateway() object
	
	NewGateway returns a new, un-initialized Gateway. This function should always be followed by calls
	to [Gateway.Init], assuming a valid [Gateway.DBPath] is set.
	"""
	return Gateway(handle=_whatsapp.whatsapp_NewGateway())


# ---- Functions ---
def IsAnonymousJID(id):
	"""IsAnonymousJID(str id) bool
	
	IsAnonymousJID returns true if the JID given is not addressible, that is, if it's actually a LID.
	"""
	return _whatsapp.whatsapp_IsAnonymousJID(id)


