# -*- coding: utf-8 -*-
"""zhao.constants

This module provides common constants.
"""

G = 6.67408e-11  # m^3kg^-1s^-2
"""万有引力常数(牛顿常数)
(6.67408±0.00031)x10^-11 (2014年的科学技术数据委员会推荐的万有引力常数值)"""

g = 9.80665  # m/s^2 or N/kg
"""标准重力 这个数值被第三次国际度量衡会议（CGPM） 确立 (1901, CR 70)"""

ALL_ATOMS_IN_UNIVERSE = 6e79  # 全宇宙原子总数估值

AU = 149597870700
"""天文单位 astronomical unit"""

ARECIBO_MESSAGE = '''\
00000010101010000000000
00101000001010000000100
10001000100010010110010
10101010101010100100100
00000000000000000000000
00000000000011000000000
00000000001101000000000
00000000001101000000000
00000000010101000000000
00000000011111000000000
00000000000000000000000
11000011100011000011000
10000000000000110010000
11010001100011000011010
11111011111011111011111
00000000000000000000000
00010000000000000000010
00000000000000000000000
00001000000000000000001
11111000000000000011111
00000000000000000000000
11000011000011100011000
10000000100000000010000
11010000110001110011010
11111011111011111011111
00000000000000000000000
00010000001100000000010
00000000001100000000000
00001000001100000000001
11111000001100000011111
00000000001100000000000
00100000000100000000100
00010000001100000001000
00001100001100000010000
00000011000100001100000
00000000001100110000000
00000011000100001100000
00001100001100000010000
00010000001000000001000
00100000001100000000100
01000000001100000000100
01000000000100000001000
00100000001000000010000
00010000000000001100000
00001100000000110000000
00100011101011000000000
00100000001000000000000
00100000111110000000000
00100001011101001011011
00000010011100100111111
10111000011100000110111
00000000010100000111011
00100000010100000111111
00100000010100000110000
00100000110110000000000
00000000000000000000000
00111000001000000000000
00111010100010101010101
00111000000000101010100
00000000000000101000000
00000000111110000000000
00000011111111100000000
00001110000000111000000
00011000000000001100000
00110100000000010110000
01100110000000110011000
01000101000001010001000
01000100100010010001000
00000100010100010000000
00000100001000010000000
00000100000000010000000
00000001001010000000000
01111001111101001111000
'''
"""阿雷西博信息（Arecibo Message）

1974年，为庆祝阿雷西博射电望远镜完成改建，而创作的无线电信息，并以距离地球25,000光年的球状星团M13为目标，把信息透过该望远镜射向太空。该信息共有
1,679个二进制数字(ASCII)，而且1,679这个数字只能由两个质数相乘，因此只能把信息拆成73条横行及23条直行，这是假设该信息的读者会先将它排成一个长方
形。如果把它排成23条横行，它会变成白色噪声，相反如果把它排成73条横行，便可排出含有信息的一幅图。
"""

MORSE_CODE = {'A': '.-',     'B': '-...',   'C': '-.-.',
              'D': '-..',    'E': '.',      'F': '..-.',
              'G': '--.',    'H': '....',   'I': '..',
              'J': '.---',   'K': '-.-',    'L': '.-..',
              'M': '--',     'N': '-.',     'O': '---',
              'P': '.--.',   'Q': '--.-',   'R': '.-.',
              'S': '...',    'T': '-',      'U': '..-',
              'V': '...-',   'W': '.--',    'X': '-..-',
              'Y': '-.--',   'Z': '--..',
              '0': '-----',  '1': '.----',  '2': '..---',
              '3': '...--',  '4': '....-',  '5': '.....',
              '6': '-....',  '7': '--...',  '8': '---..',
              '9': '----.'}
"""摩尔斯电码 Morse code
"""
