'''Physical constants and conversion factors.
'''
import math

c_0 = 299792458
'''speed of light [ m/s ]'''
k_B = 1.380649e-23
'''Boltzmann constant [J/K]'''
N_A = 6.02214076E23
'''Avogadro constant [1/mol]'''
R   = 8.31446261815324
'''molar gas constant [J/(mol K)]'''
h   = 6.62607015E-34
'''Planck's constant [J s]'''
h_bar = h/(2*math.pi)
'''reduced Planck's constant [J s]'''
amu = 1.6605390666E-27
'''atomic mass unit [kg]'''
rbohr = 5.29177210903E-11
'''bohr radius [m]'''
E_h_p_particle = 2625499.5 # hartree/particle -> Joule/mol
'''hartree per particle [J/mol]'''
E_h = 4.3597447222071e-18
'''Hartree energy [J]'''


