# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.8.2055

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, conint
from vrt_lss_agro.models.calculation_info import CalculationInfo
from vrt_lss_agro.models.tracedata import Tracedata

class CalculationState(BaseModel):
    """
    Current calculation state.
    """
    tracedata: Tracedata = Field(...)
    progress: conint(strict=True, le=100, ge=0) = Field(..., description="Calculation progress as a percentage. The progress displays the current number of completed steps. ")
    info: CalculationInfo = Field(...)
    __properties = ["tracedata", "progress", "info"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CalculationState:
        """Create an instance of CalculationState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of tracedata
        if self.tracedata:
            _dict['tracedata'] = self.tracedata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of info
        if self.info:
            _dict['info'] = self.info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CalculationState:
        """Create an instance of CalculationState from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CalculationState.parse_obj(obj)

        _obj = CalculationState.parse_obj({
            "tracedata": Tracedata.from_dict(obj.get("tracedata")) if obj.get("tracedata") is not None else None,
            "progress": obj.get("progress") if obj.get("progress") is not None else 0,
            "info": CalculationInfo.from_dict(obj.get("info")) if obj.get("info") is not None else None
        })
        return _obj

