# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.8.2055

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_agro.models.attribute import Attribute
from vrt_lss_agro.models.dryer import Dryer
from vrt_lss_agro.models.gate import Gate
from vrt_lss_agro.models.silo import Silo
from vrt_lss_agro.models.storage import Storage

class Elevator(BaseModel):
    """
    A production facility. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Key, unique identifier.")
    gate: Gate = Field(...)
    dryers: Optional[conlist(Dryer, max_items=501, min_items=0, unique_items=True)] = Field(None, description="List of dryers.")
    storages: Optional[conlist(Storage, max_items=501, min_items=0, unique_items=True)] = Field(None, description="List of places for short-term storage of grain. ")
    silos: Optional[conlist(Silo, max_items=501, min_items=0, unique_items=True)] = Field(None, description="List of places for long-term storage of grain. ")
    attributes: Optional[conlist(Attribute, max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Attributes. Used to add service information.")
    __properties = ["key", "gate", "dryers", "storages", "silos", "attributes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Elevator:
        """Create an instance of Elevator from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of gate
        if self.gate:
            _dict['gate'] = self.gate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in dryers (list)
        _items = []
        if self.dryers:
            for _item in self.dryers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dryers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in storages (list)
        _items = []
        if self.storages:
            for _item in self.storages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['storages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in silos (list)
        _items = []
        if self.silos:
            for _item in self.silos:
                if _item:
                    _items.append(_item.to_dict())
            _dict['silos'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Elevator:
        """Create an instance of Elevator from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Elevator.parse_obj(obj)

        _obj = Elevator.parse_obj({
            "key": obj.get("key"),
            "gate": Gate.from_dict(obj.get("gate")) if obj.get("gate") is not None else None,
            "dryers": [Dryer.from_dict(_item) for _item in obj.get("dryers")] if obj.get("dryers") is not None else None,
            "storages": [Storage.from_dict(_item) for _item in obj.get("storages")] if obj.get("storages") is not None else None,
            "silos": [Silo.from_dict(_item) for _item in obj.get("silos")] if obj.get("silos") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj

