# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.8.2055

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, constr
from vrt_lss_agro.models.entity_type import EntityType

class EntityPath(BaseModel):
    """
    The description of the entity and the path to it. 
    """
    entity_key: Optional[constr(strict=True, max_length=1024)] = Field(..., description="Target entity key.")
    entity_type: EntityType = Field(...)
    child_entity: Optional[EntityPath] = None
    __properties = ["entity_key", "entity_type", "child_entity"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EntityPath:
        """Create an instance of EntityPath from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of child_entity
        if self.child_entity:
            _dict['child_entity'] = self.child_entity.to_dict()
        # set to None if entity_key (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_key is None and "entity_key" in self.__fields_set__:
            _dict['entity_key'] = None

        # set to None if child_entity (nullable) is None
        # and __fields_set__ contains the field
        if self.child_entity is None and "child_entity" in self.__fields_set__:
            _dict['child_entity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EntityPath:
        """Create an instance of EntityPath from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EntityPath.parse_obj(obj)

        _obj = EntityPath.parse_obj({
            "entity_key": obj.get("entity_key"),
            "entity_type": obj.get("entity_type"),
            "child_entity": EntityPath.from_dict(obj.get("child_entity")) if obj.get("child_entity") is not None else None
        })
        return _obj

