# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.8.2055

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from vrt_lss_agro.models.crop import Crop
from vrt_lss_agro.models.elevator import Elevator
from vrt_lss_agro.models.factory import Factory
from vrt_lss_agro.models.field import Field
from vrt_lss_agro.models.leftover import Leftover
from vrt_lss_agro.models.market import Market
from vrt_lss_agro.models.movement_matrix_element import MovementMatrixElement
from vrt_lss_agro.models.plan_settings import PlanSettings

class PlanTask(BaseModel):
    """
    Initial task.
    """
    crops: conlist(Crop, max_items=501, min_items=1, unique_items=True) = Field(..., description="List of crops.")
    fields: conlist(Field, max_items=20001, min_items=1, unique_items=True) = Field(..., description="List of fields.")
    elevators: Optional[conlist(Elevator, max_items=501, min_items=1, unique_items=True)] = Field(None, description="List of elevators.")
    factories: conlist(Factory, max_items=501, min_items=1, unique_items=True) = Field(..., description="List of factories.")
    markets: conlist(Market, max_items=501, min_items=1, unique_items=True) = Field(..., description="List of markets.")
    movement_matrix: conlist(MovementMatrixElement, max_items=8040402, min_items=1, unique_items=True) = Field(..., description="Matrix describing the cost (in kilometers and monetary units) of moving grain between objects (in both directions). If there is no corresponding entry in the matrix between the objects, the movement of grain between them is considered impossible. ")
    leftovers: Optional[conlist(Leftover, max_items=25001, min_items=0)] = Field(None, description="List of leftovers.")
    plan_settings: PlanSettings = Field(...)
    __properties = ["crops", "fields", "elevators", "factories", "markets", "movement_matrix", "leftovers", "plan_settings"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PlanTask:
        """Create an instance of PlanTask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in crops (list)
        _items = []
        if self.crops:
            for _item in self.crops:
                if _item:
                    _items.append(_item.to_dict())
            _dict['crops'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in fields (list)
        _items = []
        if self.fields:
            for _item in self.fields:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in elevators (list)
        _items = []
        if self.elevators:
            for _item in self.elevators:
                if _item:
                    _items.append(_item.to_dict())
            _dict['elevators'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in factories (list)
        _items = []
        if self.factories:
            for _item in self.factories:
                if _item:
                    _items.append(_item.to_dict())
            _dict['factories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in markets (list)
        _items = []
        if self.markets:
            for _item in self.markets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['markets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in movement_matrix (list)
        _items = []
        if self.movement_matrix:
            for _item in self.movement_matrix:
                if _item:
                    _items.append(_item.to_dict())
            _dict['movement_matrix'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in leftovers (list)
        _items = []
        if self.leftovers:
            for _item in self.leftovers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['leftovers'] = _items
        # override the default output from pydantic by calling `to_dict()` of plan_settings
        if self.plan_settings:
            _dict['plan_settings'] = self.plan_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PlanTask:
        """Create an instance of PlanTask from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PlanTask.parse_obj(obj)

        _obj = PlanTask.parse_obj({
            "crops": [Crop.from_dict(_item) for _item in obj.get("crops")] if obj.get("crops") is not None else None,
            "fields": [Field.from_dict(_item) for _item in obj.get("fields")] if obj.get("fields") is not None else None,
            "elevators": [Elevator.from_dict(_item) for _item in obj.get("elevators")] if obj.get("elevators") is not None else None,
            "factories": [Factory.from_dict(_item) for _item in obj.get("factories")] if obj.get("factories") is not None else None,
            "markets": [Market.from_dict(_item) for _item in obj.get("markets")] if obj.get("markets") is not None else None,
            "movement_matrix": [MovementMatrixElement.from_dict(_item) for _item in obj.get("movement_matrix")] if obj.get("movement_matrix") is not None else None,
            "leftovers": [Leftover.from_dict(_item) for _item in obj.get("leftovers")] if obj.get("leftovers") is not None else None,
            "plan_settings": PlanSettings.from_dict(obj.get("plan_settings")) if obj.get("plan_settings") is not None else None
        })
        return _obj

