# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.8.2055

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from vrt_lss_agro.models.entity_warning import EntityWarning
from vrt_lss_agro.models.tracedata import Tracedata

class ValidateResult(BaseModel):
    """
    Data validation result.
    """
    tracedata: Tracedata = Field(...)
    warnings: conlist(EntityWarning, max_items=100001, min_items=0) = Field(..., description="List of warnings. Depending on the flag `calculation_settings.treat_warnings_as_errors` - triggered checks are interpreted as errors or result in the removal of erroneous data from the calculation. ")
    __properties = ["tracedata", "warnings"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ValidateResult:
        """Create an instance of ValidateResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of tracedata
        if self.tracedata:
            _dict['tracedata'] = self.tracedata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in warnings (list)
        _items = []
        if self.warnings:
            for _item in self.warnings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['warnings'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ValidateResult:
        """Create an instance of ValidateResult from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ValidateResult.parse_obj(obj)

        _obj = ValidateResult.parse_obj({
            "tracedata": Tracedata.from_dict(obj.get("tracedata")) if obj.get("tracedata") is not None else None,
            "warnings": [EntityWarning.from_dict(_item) for _item in obj.get("warnings")] if obj.get("warnings") is not None else None
        })
        return _obj

