
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.secure_value_hash import TypeSecureValueHash
    from ...types.secure_credentials_encrypted import TypeSecureCredentialsEncrypted


class AcceptAuthorization(TLRequest[bool]):
    """
    Sends a Telegram Passport authorization form, effectively sharing data with the service

    Raises:
        `400`BotInvalidError: This is not a valid bot.
        `400`PublicKeyRequiredError: A public key is required.

    """

    _id = 0XF3ED4C73
    _result_id = 0X43B904E1

    def __init__(
        self,
        bot_id: int,
        scope: str,
        public_key: str,
        value_hashes: List['TypeSecureValueHash'],
        credentials: 'TypeSecureCredentialsEncrypted'
    ):

        """
        Sends a Telegram Passport authorization form, effectively sharing data with the service

        Args:
            bot_id (int): Bot ID
            scope (str): Telegram Passport element types requested by the service
            public_key (str): Service's public key
            value_hashes (List['TypeSecureValueHash']): Types of values sent and their hashes
            credentials ('TypeSecureCredentialsEncrypted'): Encrypted values
        """

        self.bot_id = bot_id
        self.scope = scope
        self.public_key = public_key
        self.value_hashes = value_hashes
        self.credentials = credentials

    def to_bytes(self, boxed: bool=True):
        with Writer(b'sL\xed\xf3' if boxed else b'') as writer:
            writer.long(self.bot_id)
            writer.string(self.scope)
            writer.string(self.public_key)
            writer.vector(
                self.value_hashes,
                lambda value: writer.object(
                    value,
                    group_id=0X79CBC208
                )
            )
            writer.object(
                self.credentials,
                group_id=0X18C0BB4B
            )

            return writer.getvalue()