
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


class ChangeAuthorizationSettings(TLRequest[bool]):
    """
    Change settings related to a session.

    Raises:
        `400`HashInvalidError: The provided hash is invalid.

    """

    _id = 0X40F48462
    _result_id = 0X43B904E1

    def __init__(
        self,
        hash: int,
        confirmed: bool = False,
        encrypted_requests_disabled: bool = False,
        call_requests_disabled: bool = False
    ):

        """
        Change settings related to a session.

        Args:
            hash (int): Session ID from the [authorization](https://core.telegram.org/constructor/authorization) constructor, fetchable using [account.getAuthorizations](https://core.telegram.org/method/account.getAuthorizations)
            confirmed (bool, optional): If set, [confirms a newly logged in session](https://core.telegram.org/api/auth#confirming-login).
            encrypted_requests_disabled (bool, optional): Whether to enable or disable receiving encrypted chats: if the flag is not set, the previous setting is not changed
            call_requests_disabled (bool, optional): Whether to enable or disable receiving calls: if the flag is not set, the previous setting is not changed
        """

        self.hash = hash
        self.confirmed = confirmed
        self.encrypted_requests_disabled = encrypted_requests_disabled
        self.call_requests_disabled = call_requests_disabled

    def to_bytes(self, boxed: bool=True):
        with Writer(b'b\x84\xf4@' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.confirmed, 3)
                writer.long(self.hash)

                if flags(self.encrypted_requests_disabled, 0):
                    writer.object(
                        self.encrypted_requests_disabled,
                        group_id=0X43B904E1
                    )

                if flags(self.call_requests_disabled, 1):
                    writer.object(
                        self.call_requests_disabled,
                        group_id=0X43B904E1
                    )

            return writer.getvalue()