
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.business_bot_rights import TypeBusinessBotRights
    from ...types.input_business_bot_recipients import TypeInputBusinessBotRecipients


class UpdateConnectedBot(TLRequest[TypeUpdates]):
    """
    Connect a [business bot](https://core.telegram.org/api/business#connected-bots) to the current account, or to change the current connection settings.

    Raises:
        `400`BotBusinessMissingError: The specified bot is not a business bot (the [user](https://core.telegram.org/constructor/user).`bot_business` flag is not set).
        `400`BusinessRecipientsEmptyError: You didn't set any flag in inputBusinessBotRecipients, thus the bot cannot work with *any* peer.
        `403`PremiumAccountRequiredError: A premium account is required to execute this action.

    """

    _id = 0X66A08C7E
    _result_id = 0XD68D29C0

    def __init__(
        self,
        bot: 'TypeInputUser',
        recipients: 'TypeInputBusinessBotRecipients',
        deleted: bool = False,
        rights: Optional['TypeBusinessBotRights'] = None
    ):

        """
        Connect a [business bot](https://core.telegram.org/api/business#connected-bots) to the current account, or to change the current connection settings.

        Args:
            bot ('TypeInputUser'): The bot to connect or disconnect
            recipients ('TypeInputBusinessBotRecipients'): Configuration for the business connection
            deleted (bool, optional): Whether to fully disconnect the bot from the current account.
            rights (Optional['TypeBusinessBotRights'], optional): ...
        """

        self.bot = bot
        self.recipients = recipients
        self.deleted = deleted
        self.rights = rights

    def to_bytes(self, boxed: bool=True):
        with Writer(b'~\x8c\xa0f' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.deleted, 1)

                if flags(self.rights, 0):
                    writer.object(
                        self.rights,
                        group_id=0XD14AA447
                    )
                writer.object(
                    self.bot,
                    group_id=0XB628962F
                )
                writer.object(
                    self.recipients,
                    group_id=0X25CF3823
                )

            return writer.getvalue()