
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING
from ...types.theme import TypeTheme
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_theme import TypeInputTheme
    from ...types.input_document import TypeInputDocument
    from ...types.input_theme_settings import TypeInputThemeSettings


class UpdateTheme(TLRequest[TypeTheme]):
    """
    Update theme

    Raises:
        `400`ThemeInvalidError: Invalid theme provided.

    """

    _id = 0X2BF40CCC
    _result_id = 0X5E6FFFBC

    def __init__(
        self,
        format: str,
        theme: 'TypeInputTheme',
        slug: Optional[str] = None,
        title: Optional[str] = None,
        document: Optional['TypeInputDocument'] = None,
        settings: Optional[List['TypeInputThemeSettings']] = None
    ):

        """
        Update theme

        Args:
            format (str): Theme format, a string that identifies the theming engines supported by the client
            theme ('TypeInputTheme'): Theme to update
            slug (Optional[str], optional): Unique theme ID
            title (Optional[str], optional): Theme name
            document (Optional['TypeInputDocument'], optional): Theme file
            settings (Optional[List['TypeInputThemeSettings']], optional): Theme settings
        """

        self.format = format
        self.theme = theme
        self.slug = slug
        self.title = title
        self.document = document
        self.settings = settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcc\x0c\xf4+' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.format)
                writer.object(
                    self.theme,
                    group_id=0X339F9825
                )

                if flags(self.slug, 0):
                    writer.string(self.slug)

                if flags(self.title, 1):
                    writer.string(self.title)

                if flags(self.document, 2):
                    writer.object(
                        self.document,
                        group_id=0X84313E
                    )

                if flags(self.settings, 3):
                    writer.vector(
                        self.settings,
                        lambda value: writer.object(
                            value,
                            group_id=0X7B33F03A
                        )
                    )

            return writer.getvalue()