
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...types.document import TypeDocument
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_file import TypeInputFile


class UploadTheme(TLRequest[TypeDocument]):
    """
    Upload theme

    Raises:
        `400`ThemeFileInvalidError: Invalid theme file provided.
        `400`ThemeMimeInvalidError: The theme's MIME type is invalid.

    """

    _id = 0X1C3DB333
    _result_id = 0X6547BD50

    def __init__(
        self,
        file: 'TypeInputFile',
        file_name: str,
        mime_type: str,
        thumb: Optional['TypeInputFile'] = None
    ):

        """
        Upload theme

        Args:
            file ('TypeInputFile'): [Previously uploaded](https://core.telegram.org/api/themes#uploading-theme-files) theme file with platform-specific colors for UI components, can be left unset when creating themes that only modify the wallpaper or accent colors.
            file_name (str): File name
            mime_type (str): MIME type, must be application/x-tgtheme-{format}, where format depends on the client
            thumb (Optional['TypeInputFile'], optional): Thumbnail
        """

        self.file = file
        self.file_name = file_name
        self.mime_type = mime_type
        self.thumb = thumb

    def to_bytes(self, boxed: bool=True):
        with Writer(b'3\xb3=\x1c' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.file,
                    group_id=0XB7247676
                )

                if flags(self.thumb, 0):
                    writer.object(
                        self.thumb,
                        group_id=0XB7247676
                    )
                writer.string(self.file_name)
                writer.string(self.mime_type)

            return writer.getvalue()