
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_channel import TypeInputChannel


class DeleteHistory(TLRequest[TypeUpdates]):
    """
    Delete the history of a [supergroup](https://core.telegram.org/api/channel)

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelParicipantMissingError: The current user is not in the channel.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChannelTooBigError: This channel has too many participants (>1000) to be deleted.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.

    """

    _id = 0X9BAA9647
    _result_id = 0XD68D29C0

    def __init__(
        self,
        channel: 'TypeInputChannel',
        max_id: int,
        for_everyone: bool = False
    ):

        """
        Delete the history of a [supergroup](https://core.telegram.org/api/channel)

        Args:
            channel ('TypeInputChannel'): [Supergroup](https://core.telegram.org/api/channel) whose history must be deleted
            max_id (int): ID of message up to which the history must be deleted
            for_everyone (bool, optional): Whether the history should be deleted for everyone
        """

        self.channel = channel
        self.max_id = max_id
        self.for_everyone = for_everyone

    def to_bytes(self, boxed: bool=True):
        with Writer(b'G\x96\xaa\x9b' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.for_everyone, 0)
                writer.object(
                    self.channel,
                    group_id=0X42691CEF
                )
                writer.int(self.max_id)

            return writer.getvalue()